#include <tangle/tangle.h>

int main(int argc, char** argv) {
	ClutterActor* stage;
	guint x, y;
	ClutterActor* texture;
	ClutterActor* scroller;
	ClutterActor* horizontal_scrollbar;
	ClutterActor* vertical_scrollbar;
	ClutterColor color = { 0, 0, 128, 255 };
	
	tangle_init(&argc, &argv);
	stage = clutter_stage_get_default();
	clutter_actor_set_size(stage, 800.0, 400.0);

	scroller = tangle_scroller_new();
	clutter_actor_set_position(scroller, 100.0, 50.0);
	clutter_actor_set_size(scroller, 500.0, 300.0);
//	g_object_set(scroller, "max-overshoot-x", 250.0, "max-overshoot-y", 150.0, "repeat-x", TRUE, "repeat-y", TRUE, NULL);
	g_object_set(scroller, "repeat-x", TRUE, "repeat-y", TRUE, "continuous-x", TRUE, "continuous-y", TRUE, NULL);
//	g_signal_connect(scroller, "clamp-scrolling-offset-x", G_CALLBACK(tangle_scroller_clamp_page_boundaries), NULL);
//	g_signal_connect_swapped(scroller, "clamp-scrolling-offset-x", G_CALLBACK(tangle_widget_clamp_child_boundaries), widget);
//	g_signal_connect_swapped(scroller, "clamp-scrolling-offset-y", G_CALLBACK(tangle_widget_clamp_child_boundaries), widget);
	clutter_container_add_actor(CLUTTER_CONTAINER(stage), scroller);

	for (x = 0; x < 20; x++) {
		for (y = 0; y < 10; y++) {
			texture = tangle_texture_new("test_image_135x100.jpg");
			clutter_actor_set_position(texture, x * 130.0, y * 100.0);
			clutter_container_add_actor(CLUTTER_CONTAINER(scroller), texture);
		}
	}
//	clutter_actor_set_size(scroller, 20 * 130.0, 10 * 100.0);
		
	horizontal_scrollbar = tangle_scrollbar_new_rectangle(FALSE, &color);
	tangle_scrollbar_bind_to_scroller(TANGLE_SCROLLBAR(horizontal_scrollbar), TANGLE_SCROLLER(scroller));
	clutter_actor_set_position(horizontal_scrollbar, 100.0, 350.0);
	clutter_actor_set_size(horizontal_scrollbar, 500.0, 10.0);
	clutter_container_add_actor(CLUTTER_CONTAINER(stage), horizontal_scrollbar);

	vertical_scrollbar = tangle_scrollbar_new_rectangle(TRUE, &color);
	tangle_scrollbar_bind_to_scroller(TANGLE_SCROLLBAR(vertical_scrollbar), TANGLE_SCROLLER(scroller));
	clutter_actor_set_position(vertical_scrollbar, 600.0, 50.0);
	clutter_actor_set_size(vertical_scrollbar, 10.0, 300.0);
	clutter_container_add_actor(CLUTTER_CONTAINER(stage), vertical_scrollbar);
	
	clutter_actor_show_all(stage);	
	clutter_main();

	return 0;
}
