#include <tangle/tangle.h>

const ClutterColor stage_color = { 0, 0, 0, 255 };
const ClutterColor red = { 255, 0, 0, 255 };

static void on_clicked(TangleButton* button, gpointer user_data) {
	g_printf("clicked %s\n", (tangle_button_get_selected(button) ? "(selected)" : ""));
}

static void on_notify_selected(GObject* object, GParamSpec* param_spec, gpointer user_data) {
	g_printf("selected %p\n", tangle_button_group_get_selected_button(TANGLE_BUTTON_GROUP(object)));
}

int main(int argc, char** argv) {
	ClutterActor* stage;
	ClutterActor* normal_texture;
	ClutterActor* active_texture;
	ClutterActor* selected_texture;
	ClutterActor* clickable_button;
	ClutterActor* selectable_button;
	ClutterActor* radio_button;
	ClutterActor* radio_button1;
	ClutterActor* radio_button2;
	ClutterActor* radio_button3;
	TangleButtonGroup* button_group;
	
	tangle_init(&argc, &argv);
	stage = clutter_stage_get_default();
	clutter_actor_set_size(stage, 800.0, 400.0);
	clutter_stage_set_color(CLUTTER_STAGE(stage), &stage_color);

	/* Clickable button */

	normal_texture = tangle_texture_new("test_image_100x74.jpg");
	active_texture = tangle_texture_new("test_image_135x100.jpg");

	clickable_button = tangle_button_new_with_background_actors(normal_texture, active_texture);
	clutter_actor_set_position(clickable_button, 100.0, 100.0);
	g_object_set(clickable_button, "highlight-color", &red, "highlight-distance", 20.0, "highlight-activate-duration", 2000, "highlight-inactivate-duration", 4000, NULL);
	g_signal_connect(clickable_button, "clicked", G_CALLBACK(on_clicked), NULL);

	/* Selectable button */

	normal_texture = tangle_texture_new("test_image_100x74.jpg");
	active_texture = tangle_texture_new("test_image_135x100.jpg");
	selected_texture = tangle_texture_new("test_image_selected_100x74.jpg");

	selectable_button = tangle_button_new_selectable_with_background_actors(normal_texture, active_texture, selected_texture);
	tangle_button_set_selected(TANGLE_BUTTON(selectable_button), TRUE);
	clutter_actor_set_position(selectable_button, 100.0, 300.0);
	g_signal_connect(selectable_button, "clicked", G_CALLBACK(on_clicked), NULL);

	/* Radio button alone */

	normal_texture = tangle_texture_new("test_image_100x74.jpg");
	active_texture = tangle_texture_new("test_image_135x100.jpg");
	selected_texture = tangle_texture_new("test_image_selected_100x74.jpg");

	radio_button = tangle_button_new_radio_with_background_actors(normal_texture, active_texture, selected_texture);
	clutter_actor_set_position(radio_button, 300.0, 300.0);
	g_signal_connect(radio_button, "clicked", G_CALLBACK(on_clicked), NULL);
	
	/* Radio buttons for a group */
	
	normal_texture = tangle_texture_new("test_image_100x74.jpg");
	active_texture = tangle_texture_new("test_image_135x100.jpg");
	selected_texture = tangle_texture_new("test_image_selected_100x74.jpg");

	radio_button1 = tangle_button_new_radio_with_background_actors(normal_texture, active_texture, selected_texture);
	clutter_actor_set_position(radio_button1, 300.0, 100.0);
	g_signal_connect(radio_button1, "clicked", G_CALLBACK(on_clicked), NULL);

	normal_texture = tangle_texture_new("test_image_100x74.jpg");
	active_texture = tangle_texture_new("test_image_135x100.jpg");
	selected_texture = tangle_texture_new("test_image_selected_100x74.jpg");

	radio_button2 = tangle_button_new_radio_with_background_actors(normal_texture, active_texture, selected_texture);
	clutter_actor_set_position(radio_button2, 450.0, 100.0);
	g_signal_connect(radio_button2, "clicked", G_CALLBACK(on_clicked), NULL);

	normal_texture = tangle_texture_new("test_image_100x74.jpg");
	active_texture = tangle_texture_new("test_image_135x100.jpg");
	selected_texture = tangle_texture_new("test_image_selected_100x74.jpg");

	radio_button3 = tangle_button_new_radio_with_background_actors(normal_texture, active_texture, selected_texture);
	clutter_actor_set_position(radio_button3, 600.0, 100.0);
	g_signal_connect(radio_button3, "clicked", G_CALLBACK(on_clicked), NULL);
	
	/* Automatically memory managed button group (NOTE! Uncomment only this or the one below!) */
	
	/* tangle_button_group_create(TANGLE_BUTTON(radio_button1), TANGLE_BUTTON(radio_button2), TANGLE_BUTTON(radio_button3), NULL); */

	/* Normal manually memory managed button group (NOTE! Uncomment only this or the one above!) */
	
	button_group = tangle_button_group_new_with_buttons(TANGLE_BUTTON(radio_button1), TANGLE_BUTTON(radio_button2), TANGLE_BUTTON(radio_button3), NULL);
	g_signal_connect(button_group, "notify::selected-button", G_CALLBACK(on_notify_selected), NULL);
	/* You have to free the memory allocated by the button_group by calling g_object_unref(button_group) later! */

	/* Add everything into the stage and start the application main loop*/
	
	clutter_container_add(CLUTTER_CONTAINER(stage), clickable_button, selectable_button, radio_button, radio_button1, radio_button2, radio_button3, NULL);
	
	clutter_actor_show_all(stage);	
	clutter_main();

	return 0;
}
