
#include <tangle/tangle.h>

const ClutterColor red = { 255, 0, 0, 255 };
const ClutterColor stage_color = { 128, 128, 128, 255 };

static gboolean start_animation(gpointer user_data) {
	ClutterActor* actor;
	ClutterAnimation* animation;
	
	actor = CLUTTER_ACTOR(user_data);
	animation = clutter_actor_animate(actor, 1, 2000, "x", 300.0, NULL);
	clutter_animation_set_loop(animation, TRUE);

	return FALSE;
}

int main(int argc, char** argv) {
	ClutterActor* stage;
	ClutterActor* bufferer;
	ClutterActor* actor;

	tangle_init(&argc, &argv);
	
	stage = clutter_stage_get_default();
	g_object_set(G_OBJECT(stage), "width", 800.0, "height", 480.0, NULL);
	clutter_stage_set_color(CLUTTER_STAGE(stage), &stage_color);

	bufferer = tangle_bufferer_new();
	tangle_bufferer_set_n_buffers(TANGLE_BUFFERER(bufferer), 5);
	g_object_set(G_OBJECT(bufferer), "x", 100.0, "y", 50.0, "width", 600.0, "height", 380.0, NULL);
	clutter_container_add_actor(CLUTTER_CONTAINER(stage), bufferer);

	actor = tangle_texture_new("test_image_100x74.jpg");
	clutter_actor_set_position(actor, 10.0, 10.0);
	clutter_container_add_actor(CLUTTER_CONTAINER(bufferer), actor);

	actor = tangle_texture_new("test_image_alpha_150x111.png");
	clutter_actor_set_position(actor, 0.0, 100.0);
	clutter_container_add_actor(CLUTTER_CONTAINER(bufferer), actor);

	g_timeout_add(6000, start_animation, actor);

	actor = tangle_texture_new("test_image_100x74.jpg");
	clutter_actor_set_position(actor, 20.0, 20.0);
	clutter_container_add_actor(CLUTTER_CONTAINER(bufferer), actor);

	actor = tangle_texture_new("test_image_alpha_150x111.png");
	clutter_actor_set_position(actor, 400.0, 200.0);
	clutter_container_add_actor(CLUTTER_CONTAINER(bufferer), actor);

	g_timeout_add(3000, start_animation, actor);

	actor = tangle_texture_new("test_image_100x74.jpg");
	clutter_actor_set_position(actor, 30.0, 30.0);
	clutter_container_add_actor(CLUTTER_CONTAINER(bufferer), actor);

	clutter_actor_show_all(stage);
	
	clutter_main();

	return 0;
}
