/*
 * tangle-hold-action.h
 *
 * This file is part of Tangle Toolkit - A graphical widget library based on Clutter Toolkit
 *
 * (c) 2009-2011 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#ifndef __TANGLE_HOLD_ACTION_H__
#define __TANGLE_HOLD_ACTION_H__

#include <clutter/clutter.h>

#define TANGLE_TYPE_HOLD_ACTION (tangle_hold_action_get_type())
#define TANGLE_HOLD_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), TANGLE_TYPE_HOLD_ACTION, TangleHoldAction))
#define TANGLE_IS_HOLD_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), TANGLE_TYPE_HOLD_ACTION))
#define TANGLE_HOLD_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), TANGLE_TYPE_HOLD_ACTION, TangleHoldActionClass))
#define TANGLE_IS_HOLD_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), TANGLE_TYPE_HOLD_ACTION))
#define TANGLE_HOLD_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), TANGLE_TYPE_HOLD_ACTION, TangleHoldActionClass))

typedef struct _TangleHoldActionPrivate TangleHoldActionPrivate;

typedef struct _TangleHoldAction {
	ClutterAction parent_instance;
	TangleHoldActionPrivate* priv;
} TangleHoldAction;

typedef struct _TangleHoldActionClass {
	ClutterActionClass parent_class;
	
	void (*held)(TangleHoldAction* hold_action);
} TangleHoldActionClass;

GType tangle_hold_action_get_type(void) G_GNUC_CONST;

ClutterAction* tangle_hold_action_new(void);

gboolean tangle_hold_action_get_pressed(TangleHoldAction* hold_action);
void tangle_hold_action_interrupt(TangleHoldAction* hold_action);

#endif

