/*
 * tangle-activity.h
 *
 * This file is part of Tangle Toolkit - A graphical widget library based on Clutter Toolkit
 *
 * (c) 2011 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#ifndef __TANGLE_ACTIVITY_H__
#define __TANGLE_ACTIVITY_H__

#include "tangle-object.h"

#define TANGLE_TYPE_ACTIVITY (tangle_activity_get_type())
#define TANGLE_ACTIVITY(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), TANGLE_TYPE_ACTIVITY, TangleActivity))
#define TANGLE_IS_ACTIVITY(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), TANGLE_TYPE_ACTIVITY))
#define TANGLE_ACTIVITY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), TANGLE_TYPE_ACTIVITY, TangleActivityClass))
#define TANGLE_IS_ACTIVITY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), TANGLE_TYPE_ACTIVITY))
#define TANGLE_ACTIVITY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), TANGLE_TYPE_ACTIVITY, TangleActivityClass))

typedef struct _TangleActivityPrivate TangleActivityPrivate;

typedef struct _TangleActivity {
	TangleObject parent_instance;
	TangleActivityPrivate* priv;
} TangleActivity;

typedef struct _TangleActivityClass {
	TangleObjectClass parent_class;
	
	void (*activate)(TangleActivity* activity);
} TangleActivityClass;

GType tangle_activity_get_type(void) G_GNUC_CONST;

void tangle_activity_activate(TangleActivity* activity);
gboolean tangle_activity_activate_false(TangleActivity* activity);
gboolean tangle_activity_activate_true(TangleActivity* activity);

#endif
