/*
 * tangle-fixed-layout.c
 *
 * This file is part of Tangle Toolkit - A graphical widget library based on Clutter Toolkit
 *
 * (c) 2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#include "tangle-fixed-layout.h"

G_DEFINE_TYPE(TangleFixedLayout, tangle_fixed_layout, TANGLE_TYPE_LAYOUT);

enum {
	PROP_0,
};

TangleLayout* tangle_fixed_layout_new(void) {

	return TANGLE_LAYOUT(g_object_new(TANGLE_TYPE_FIXED_LAYOUT, NULL));
}

static void tangle_fixed_layout_get_preferred_width(TangleLayout* layout, TangleWidget* widget, gfloat for_height, gfloat* min_width_p, gfloat* natural_width_p) {
	gfloat min_width;
	gfloat natural_width;
	TangleActorIterator actor_iterator;
	ClutterActor* actor;
	gfloat x, min, natural;

	min_width = natural_width = 0;
	for (tangle_widget_initialize_actor_iterator(widget, &actor_iterator); (actor = tangle_actor_iterator_get_actor(&actor_iterator)); tangle_actor_iterator_next(&actor_iterator)) {
		x = clutter_actor_get_x(actor);
		clutter_actor_get_preferred_size(actor, &min, NULL, &natural, NULL);

		if (x + min > min_width) {
			min_width = x + min;
		}
		if (x + natural > natural_width) {
			natural_width = x + natural;
		}
	}
	
	if (min_width_p) {
		*min_width_p = min_width;
	}
	if (natural_width_p) {
		*natural_width_p = natural_width;
	}		
}

static void tangle_fixed_layout_get_preferred_height(TangleLayout* layout, TangleWidget* widget, gfloat for_width, gfloat* min_height_p, gfloat* natural_height_p) {
	gfloat min_height;
	gfloat natural_height;
	TangleActorIterator actor_iterator;
	ClutterActor* actor;
	gfloat y, min, natural;

	min_height = natural_height = 0;
	for (tangle_widget_initialize_actor_iterator(widget, &actor_iterator); (actor = tangle_actor_iterator_get_actor(&actor_iterator)); tangle_actor_iterator_next(&actor_iterator)) {
		y = clutter_actor_get_y(actor);
		clutter_actor_get_preferred_size(actor, NULL, &min, NULL, &natural);

		if (y + min > min_height) {
			min_height = y + min;
		}
		if (y + natural > natural_height) {
			natural_height = y + natural;
		}
	}
	
	if (min_height_p) {
		*min_height_p = min_height;
	}
	if (natural_height_p) {
		*natural_height_p = natural_height;
	}		
}

static void tangle_fixed_layout_allocate(TangleLayout* layout, TangleWidget* widget, gfloat width, gfloat height, ClutterAllocationFlags flags) {
	TangleActorIterator actor_iterator;
	ClutterActor* actor;
	gfloat x, y, w, h;
	ClutterActorBox actor_box;

	for (tangle_widget_initialize_actor_iterator(widget, &actor_iterator); (actor = tangle_actor_iterator_get_actor(&actor_iterator)); tangle_actor_iterator_next(&actor_iterator)) {
		g_object_get(actor, "fixed-x", &x, "fixed-y", &y, NULL);
		clutter_actor_get_preferred_size(actor, NULL, NULL, &w, &h);
		
		actor_box.x1 = x;
		actor_box.x2 = x + w;
		actor_box.y1 = y;
		actor_box.y2 = y + h;
		tangle_layout_allocate_actor(layout, actor, &actor_box, flags);

	}
}

static void tangle_fixed_layout_class_init(TangleFixedLayoutClass* fixed_layout_class) {
	TangleLayoutClass* layout_class = TANGLE_LAYOUT_CLASS(fixed_layout_class);

	layout_class->get_preferred_width = tangle_fixed_layout_get_preferred_width;
	layout_class->get_preferred_height = tangle_fixed_layout_get_preferred_height;
	layout_class->allocate = tangle_fixed_layout_allocate;
}

static void tangle_fixed_layout_init(TangleFixedLayout* fixed_layout) {
}

