
#include <tangle/tangle.h>

ClutterColor gray = { 128, 128, 128, 255 };
ClutterColor red = { 255, 0, 0, 255 };

int main(int argc, char** argv) {
	ClutterActor* stage;
	ClutterActor* widget;
	ClutterActor* actor;
	ClutterAction* action;
	TangleBinding* binding;
	GValue value = { 0 };
	
	tangle_init(&argc, &argv);
	
	stage = clutter_stage_get_default();
	g_object_set(G_OBJECT(stage), "width", 800.0, "height", 480.0, NULL);

	widget = tangle_widget_new();
	clutter_actor_set_size(widget, 400.0, 200.0);
	tangle_widget_set_background_color(TANGLE_WIDGET(widget), &gray);
	clutter_container_add_actor(CLUTTER_CONTAINER(stage), widget);

	actor = clutter_rectangle_new_with_color(&red);
	clutter_actor_set_size(actor, 100, 100);
	clutter_container_add_actor(CLUTTER_CONTAINER(widget), actor);

	binding = tangle_binding_new(G_OBJECT(widget), "width", G_OBJECT(actor), "x");
	g_value_init(&value, G_TYPE_FLOAT);
	g_value_set_float(&value, -100.0);	
	tangle_binding_set_constant_term(binding, &value);
	g_value_unset(&value);

	binding = tangle_binding_new(G_OBJECT(widget), "height", G_OBJECT(actor), "y");
	g_value_init(&value, G_TYPE_FLOAT);
	g_value_set_float(&value, -100.0);
	tangle_binding_set_constant_term(binding, &value);
	g_value_unset(&value);
	
	action = tangle_stretch_action_new(widget);
	tangle_stretch_action_set_min_size(TANGLE_STRETCH_ACTION(action), 100.0, 50.0);
	tangle_stretch_action_set_max_size(TANGLE_STRETCH_ACTION(action), 700.0, 450.0);
	clutter_actor_add_action(actor, action);
	clutter_actor_set_reactive(actor, TRUE);

	clutter_actor_show_all(stage);
	
	clutter_main();


	return 0;
}
