#include <clutter/clutter.h>
#include <tangle/tangle.h>

int main(int argc, char** argv) {
	const gchar* filename;
	GError* error = NULL;
	ClutterScript* script;
	TangleProperties* properties;
	
	tangle_init(&argc, &argv);
	
	if (argc > 1) {
		filename = argv[1];
	} else {
		filename = "test-properties.json";
	}

	script = clutter_script_new();
	if (!clutter_script_load_from_file(script, filename, &error)) {
		g_critical("Error when loading '%s': %s", filename, error->message);
	} else if (!(properties = TANGLE_PROPERTIES(clutter_script_get_object(script, "main")))) {
		g_critical("Could not find an object named 'main' from '%s'.", filename);
	} else {
		g_print("boolean: %s\n", (tangle_properties_get_boolean(properties, "boolean") ? "TRUE" : "FALSE"));
		g_print("int: %" G_GINT64_FORMAT "\n", tangle_properties_get_int(properties, "int"));
		g_print("double: %lf\n", tangle_properties_get_double(properties, "double"));
		g_print("string: %s\n", tangle_properties_get_string(properties, "string"));
	}

	g_object_unref(script);
	
	return 0;
}
