/*
 * tangle-easing-transition.h
 *
 * This file is part of Tangle Toolkit - A graphical widget library based on Clutter Toolkit
 *
 * (c) 2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#ifndef __TANGLE_EASING_TRANSITION_H__
#define __TANGLE_EASING_TRANSITION_H__

#include "tangle-transition.h"

#define TANGLE_TYPE_EASING_TRANSITION (tangle_easing_transition_get_type())
#define TANGLE_EASING_TRANSITION(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), TANGLE_TYPE_EASING_TRANSITION, TangleEasingTransition))
#define TANGLE_IS_EASING_TRANSITION(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), TANGLE_TYPE_EASING_TRANSITION))
#define TANGLE_EASING_TRANSITION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), TANGLE_TYPE_EASING_TRANSITION, TangleEasingTransitionClass))
#define TANGLE_IS_EASING_TRANSITION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), TANGLE_TYPE_EASING_TRANSITION))
#define TANGLE_EASING_TRANSITION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), TANGLE_TYPE_EASING_TRANSITION, TangleEasingTransitionClass))

typedef struct _TangleEasingTransitionPrivate TangleEasingTransitionPrivate;

typedef struct _TangleEasingTransition {
	TangleTransition parent_instance;
	TangleEasingTransitionPrivate* priv;
} TangleEasingTransition;

typedef struct _TangleEasingTransitionClass {
	TangleTransitionClass parent_class;
} TangleEasingTransitionClass;

GType tangle_easing_transition_get_type(void) G_GNUC_CONST;

TangleTransition* tangle_easing_transition_new();

gulong tangle_easing_transition_get_mode(TangleEasingTransition* easing_transition);
void tangle_easing_transition_set_mode(TangleEasingTransition* easing_transition, gulong mode);
guint tangle_easing_transition_get_duration(TangleEasingTransition* easing_transition);
void tangle_easing_transition_set_duration(TangleEasingTransition* easing_transition, guint duration);
void tangle_easing_transition_set_mode_duration(TangleEasingTransition* easing_transition, glong mode, guint duration);

#endif
