/*
 * tangle-stylesheet.h
 *
 * This file is part of Tangle Toolkit - A graphical widget library based on Clutter Toolkit
 *
 * (c) 2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#ifndef __TANGLE_STYLESHEET_H__
#define __TANGLE_STYLESHEET_H__

#include "tangle-style.h"

#define TANGLE_TYPE_STYLESHEET (tangle_stylesheet_get_type())
#define TANGLE_STYLESHEET(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), TANGLE_TYPE_STYLESHEET, TangleStylesheet))
#define TANGLE_IS_STYLESHEET(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), TANGLE_TYPE_STYLESHEET))
#define TANGLE_STYLESHEET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), TANGLE_TYPE_STYLESHEET, TangleStylesheetClass))
#define TANGLE_IS_STYLESHEET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), TANGLE_TYPE_STYLESHEET))
#define TANGLE_STYLESHEET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), TANGLE_TYPE_STYLESHEET, TangleStylesheetClass))

typedef struct _TangleStylesheetPrivate TangleStylesheetPrivate;

typedef struct _TangleStylesheet {
	GObject parent_instance;
	TangleStylesheetPrivate* priv;
} TangleStylesheet;

typedef struct _TangleStylesheetClass {
	GObjectClass parent_class;
	
	/* signals */
	void (*style_added)(TangleStylesheet* stylesheet, TangleStyle* style);
	void (*style_removed)(TangleStylesheet* stylesheet, TangleStyle* style);
} TangleStylesheetClass;

GType tangle_stylesheet_get_type(void) G_GNUC_CONST;

TangleStylesheet* tangle_stylesheet_new();
TangleStylesheet* tangle_stylesheet_new_from_file(const gchar* name);

GList* tangle_stylesheet_get_styles(TangleStylesheet* stylesheet);
void tangle_stylesheet_add_style(TangleStylesheet* stylesheet, TangleStyle* style);
void tangle_stylesheet_remove_style(TangleStylesheet* stylesheet, TangleStyle* style);

void tangle_stylesheet_apply(TangleStylesheet* stylesheet, GObject* object);
void tangle_stylesheet_unapply(TangleStylesheet* stylesheet, GObject* object);
TangleStyle* tangle_stylesheet_get_style_for_object(TangleStylesheet* stylesheet, GObject* object);

TangleStylesheet* tangle_stylesheet_get_default();
void tangle_stylesheet_set_default(TangleStylesheet* stylesheet);

#endif
