/*
 * tangle-drag-actin.h
 *
 * This file is part of Tangle Toolkit - A graphical widget library based on Clutter Toolkit
 *
 * (c) 2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#ifndef __TANGLE_DRAG_ACTION_H__
#define __TANGLE_DRAG_ACTION_H__

#include <clutter/clutter.h>

#define TANGLE_TYPE_DRAG_ACTION (tangle_drag_action_get_type())
#define TANGLE_DRAG_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), TANGLE_TYPE_DRAG_ACTION, TangleDragAction))
#define TANGLE_IS_DRAG_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), TANGLE_TYPE_DRAG_ACTION))
#define TANGLE_DRAG_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), TANGLE_TYPE_DRAG_ACTION, TangleDragActionClass))
#define TANGLE_IS_DRAG_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), TANGLE_TYPE_DRAG_ACTION))
#define TANGLE_DRAG_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), TANGLE_TYPE_DRAG_ACTION, TangleDragActionClass))

typedef struct _TangleDragActionPrivate TangleDragActionPrivate;

typedef struct _TangleDragAction {
	ClutterDragAction parent_instance;
	TangleDragActionPrivate* priv;
} TangleDragAction;

typedef struct _TangleDragActionClass {
	ClutterDragActionClass parent_class;
} TangleDragActionClass;

GType tangle_drag_action_get_type(void) G_GNUC_CONST;

ClutterAction* tangle_drag_action_new();

ClutterActor* tangle_drag_action_get_drag_actor(TangleDragAction* drag_action);

#endif
