
#include <tangle/tangle.h>

ClutterColor black = { 0, 0, 0, 255 };
ClutterColor red = { 255, 0, 0, 255 };

static gboolean dodo(TangleDropAction* drop_action, TangleDragAction* drag_action, gpointer user_data) {
	g_print("%s\n", (const gchar*)user_data);
	
	return FALSE;
}

int main(int argc, char** argv) {
	ClutterActor* stage;
	ClutterActor* actor;
	ClutterAction* action;
	
	tangle_init(&argc, &argv);
	
	stage = clutter_stage_get_default();
	g_object_set(G_OBJECT(stage), "width", 800.0, "height", 480.0, NULL);

	actor = clutter_rectangle_new_with_color(&black);
	clutter_actor_set_size(actor, 100, 100);
	clutter_actor_set_position(actor, 0, 400);
	clutter_container_add_actor(CLUTTER_CONTAINER(stage), actor);

	action = tangle_drag_action_new();
	clutter_drag_action_set_drag_threshold(CLUTTER_DRAG_ACTION(action), 50.0, G_MAXUINT);
	clutter_actor_add_action(actor, action);
	clutter_actor_set_reactive(actor, TRUE);

	actor = clutter_rectangle_new_with_color(&red);
	clutter_actor_set_size(actor, 100, 100);
	clutter_actor_set_position(actor, 200, 200);
	clutter_container_add_actor(CLUTTER_CONTAINER(stage), actor);

	action = tangle_drop_action_new();
	g_signal_connect(action, "drag-begin", G_CALLBACK(dodo), "begin");
	g_signal_connect(action, "drag-motion", G_CALLBACK(dodo), "motion");
	g_signal_connect(action, "drag-end", G_CALLBACK(dodo), "end");
	g_signal_connect(action, "dropped", G_CALLBACK(dodo), "dropped");
	clutter_actor_add_action(actor, action);
	clutter_actor_set_reactive(actor, TRUE);

	clutter_actor_show_all(stage);
	
	clutter_main();


	return 0;
}
