/*
 * tangle-scroll-trick.h
 *
 * This file is part of Tangle Toolkit - A graphical widget library based on Clutter Toolkit
 *
 * (c) 2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#ifndef __TANGLE_SCROLL_TRICK_H__
#define __TANGLE_SCROLL_TRICK_H__

#include "tangle-trick.h"

#define TANGLE_TYPE_SCROLL_TRICK (tangle_scroll_trick_get_type())
#define TANGLE_SCROLL_TRICK(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), TANGLE_TYPE_SCROLL_TRICK, TangleScrollTrick))
#define TANGLE_IS_SCROLL_TRICK(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), TANGLE_TYPE_SCROLL_TRICK))
#define TANGLE_SCROLL_TRICK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), TANGLE_TYPE_SCROLL_TRICK, TangleScrollTrickClass))
#define TANGLE_IS_SCROLL_TRICK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), TANGLE_TYPE_SCROLL_TRICK))
#define TANGLE_SCROLL_TRICK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), TANGLE_TYPE_SCROLL_TRICK, TangleScrollTrickClass))

#define TANGLE_TYPE_SCROLL_AXIS (tangle_scroll_axis_get_type())

typedef struct _TangleScrollTrickPrivate TangleScrollTrickPrivate;

typedef struct _TangleScrollTrick {
	TangleTrick parent_instance;
	TangleScrollTrickPrivate* priv;
} TangleScrollTrick;

typedef struct _TangleScrollTrickClass {
	TangleTrickClass parent_class;
} TangleScrollTrickClass;

typedef enum {
	TANGLE_SCROLL_NO_AXIS = 0,
	TANGLE_SCROLL_X_AXIS,
	TANGLE_SCROLL_Y_AXIS,
	TANGLE_SCROLL_XY_AXIS
} TangleScrollAxis;

GType tangle_scroll_trick_get_type(void) G_GNUC_CONST;
GType tangle_scroll_axis_get_type(void) G_GNUC_CONST;

TangleTrick* tangle_scroll_trick_new();

TangleScrollAxis tangle_scroll_trick_get_axis(TangleScrollTrick* scroll_trick);
void tangle_scroll_trick_set_axis(TangleScrollTrick* scroll_trick, TangleScrollAxis axis);

void tangle_scroll_trick_get_offsets(TangleScrollTrick* scroll_trick, gfloat* offset_x_return, gfloat* offset_y_return);
void tangle_scroll_trick_set_offsets(TangleScrollTrick* scroll_trick, gfloat offset_x, gfloat offset_y);

void tangle_scroll_trick_get_max_offsets(TangleScrollTrick* scroll_trick, gfloat* max_offset_x_return, gfloat* max_offset_y_return);
void tangle_scroll_trick_get_page_lengths(TangleScrollTrick* scroll_trick, gfloat* page_length_x_return, gfloat* page_length_y_return);

TangleScrollAxis tangle_scroll_trick_get_repeat_axis(TangleScrollTrick* scroll_trick);
void tangle_scroll_trick_set_repeat_axis(TangleScrollTrick* scroll_trick, TangleScrollAxis repeat_axis);

void tangle_scroll_trick_clamp_page_boundaries(TangleScrollTrick* scroll_trick, TangleClamp* clamp);


#endif
