/*
 * tangle-warehouse.h
 *
 * This file is part of Tangle Toolkit - A graphical widget library based on Clutter Toolkit
 *
 * (c) 2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#ifndef __TANGLE_WAREHOUSE_H__
#define __TANGLE_WAREHOUSE_H__

#include <clutter/clutter.h>

#define TANGLE_TYPE_WAREHOUSE (tangle_warehouse_get_type())
#define TANGLE_WAREHOUSE(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), TANGLE_TYPE_WAREHOUSE, TangleWarehouse))
#define TANGLE_IS_WAREHOUSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), TANGLE_TYPE_WAREHOUSE))
#define TANGLE_WAREHOUSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), TANGLE_TYPE_WAREHOUSE, TangleWarehouseClass))
#define TANGLE_IS_WAREHOUSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), TANGLE_TYPE_WAREHOUSE))
#define TANGLE_WAREHOUSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), TANGLE_TYPE_WAREHOUSE, TangleWarehouseClass))

typedef struct _TangleWarehousePrivate TangleWarehousePrivate;

typedef struct _TangleWarehouse {
	GObject parent_instance;
	TangleWarehousePrivate* priv;
} TangleWarehouse;

typedef struct _TangleWarehouseClass {
	GObjectClass parent_class;
} TangleWarehouseClass;

GType tangle_warehouse_get_type(void) G_GNUC_CONST;

TangleWarehouse* tangle_warehouse_new(void);

TangleWarehouse* tangle_actor_get_warehouse_parent(ClutterActor* actor);

#endif
