#include <tangle/tangle.h>

static ClutterColor normal_color = { 0, 128, 128, 255 };
static ClutterColor interactive_color = { 255, 64, 64, 255 };
static ClutterColor gradient_color = { 0, 255, 255, 255 };

static gboolean on_clicked(TangleButton* button, gpointer user_data) {
	printf("jee\n");
	
	return FALSE;
}

int main(int argc, char** argv) {
	ClutterActor* stage;
	ClutterActor* widget;
	ClutterActor* actors[4];
	
	tangle_init(&argc, &argv);
	stage = clutter_stage_get_default();
	clutter_actor_set_size(stage, 800.0, 400.0);
	
	widget = tangle_widget_new();
	tangle_widget_set_layout(TANGLE_WIDGET(widget), tangle_box_layout_new());
	clutter_container_add_actor(CLUTTER_CONTAINER(stage), widget);
	
	actors[0] = tangle_button_new_with_background_actors(tangle_grid_new(20.0, 20.0),
	                                                     tangle_grid_new(10.0, 10.0));
	g_signal_connect(actors[0], "clicked", G_CALLBACK(on_clicked), NULL);
	clutter_actor_set_size(actors[0], 1350.0, 1000.0);	

	actors[1] = tangle_scrolling_actor_new(actors[0]);
	tangle_scrolling_actor_set_scrolling_threshold_x(TANGLE_SCROLLING_ACTOR(actors[1]), 100.0);
	tangle_scrolling_actor_set_scrolling_threshold_y(TANGLE_SCROLLING_ACTOR(actors[1]), 50.0);
	clutter_actor_set_size(actors[1], 150.0, 100.0);
	clutter_container_add_actor(CLUTTER_CONTAINER(widget), actors[1]);

	actors[2] = tangle_draggable_actor_new(tangle_grid_new(5.0, 5.0));
	clutter_actor_set_size(actors[2], 1350.0, 1000.0);	
	tangle_draggable_actor_set_dragging_threshold_x(TANGLE_DRAGGABLE_ACTOR(actors[2]), G_MAXFLOAT);
	tangle_draggable_actor_set_dragging_threshold_y(TANGLE_DRAGGABLE_ACTOR(actors[2]), 20.0);

	actors[3] = tangle_scrolling_actor_new(actors[2]);
//	tangle_scrolling_actor_set_scrolling_threshold_x(TANGLE_SCROLLING_ACTOR(actors[3]), 100.0);
//	tangle_scrolling_actor_set_scrolling_threshold_y(TANGLE_SCROLLING_ACTOR(actors[3]), 50.0);
	clutter_actor_set_size(actors[3], 150.0, 100.0);
	clutter_container_add_actor(CLUTTER_CONTAINER(widget), actors[3]);

	clutter_actor_show_all(stage);
	
	clutter_main();

	return 0;
}
