
#include "tangle/tangle.h"

static ClutterColor red = { 255, 0, 0, 255 };
static ClutterColor green = { 0, 255, 0, 255 };
static ClutterColor blue = { 0, 0, 255, 255 };
static ClutterColor light_red = { 255, 128, 128, 255 };
static ClutterColor light_green = { 128, 255, 128, 255 };
static ClutterColor light_blue = { 128, 128, 255, 255 };
static ClutterColor* colors[] = { &red, &green, &blue };
static ClutterColor* light_colors[] = { &light_red, &light_green, &light_blue };

static gboolean on_button_clicked(TangleButton* button, gpointer user_data) {
	TangleVault* vault;
	TangleActor* hide_actor;
	TangleActor* show_actor;

	vault = TANGLE_VAULT(user_data);
	tangle_vault_get(vault, 2, TANGLE_TYPE_ACTOR, &hide_actor, TANGLE_TYPE_ACTOR, &show_actor);
	
	tangle_actor_hide_animated(hide_actor);
	tangle_actor_show(show_actor);
}

static void on_transition_completed(TangleActor* actor, ClutterActorBox* old_allocation, ClutterActorBox* current_allocation, gpointer user_data) {
	g_print("Transition completed: %p: ", actor);
	if (old_allocation) {
		g_print("(%f, %f)(%f, %f) => ", old_allocation->x1, old_allocation->y1, old_allocation->x2, old_allocation->y2);
	} else {
		g_print("hidden => ");
	}
	if (current_allocation) {
		g_print("(%f, %f)(%f, %f)\n", current_allocation->x1, current_allocation->y1, current_allocation->x2, current_allocation->y2);
	} else {
		g_print("hidden\n");
	}
}

int main(int argc, char** argv) {
	ClutterActor* stage;
	ClutterActor* stack;
	TangleTransition* transition;
	ClutterActor* views[3];
	ClutterActor* buttons[3];
	gint i;
	TangleVault* vault;
	
	tangle_init(&argc, &argv);
	
	tangle_stylesheet_set_default(tangle_stylesheet_new_from_file("stack-layout-stylesheet"));

	stage = clutter_stage_get_default();
	clutter_actor_set_size(stage, 800.0, 480.0);

	stack = tangle_widget_new_with_layout(tangle_stack_layout_new());
	clutter_actor_set_size(stack, 800.0, 480.0);
	clutter_container_add_actor(CLUTTER_CONTAINER(stage), CLUTTER_ACTOR(stack));

	//transition = tangle_easing_transition_new(1, 1500);
	//g_object_set(transition, "use-opacity", TRUE, "show-from-scale", 0.5, "hide-to-scale", 2.0, NULL);

	for (i = 0; i < 3; i++) {
		views[i] = tangle_view_new_with_layout(tangle_stack_layout_new());
		g_signal_connect(views[i], "transition-completed", G_CALLBACK(on_transition_completed), NULL);
		clutter_actor_hide(views[i]);
//		tangle_actor_set_transition(TANGLE_ACTOR(views[i]), transition);
		clutter_container_add_actor(CLUTTER_CONTAINER(stack), views[i]);

		buttons[i] = tangle_button_new_with_background_actors(clutter_rectangle_new_with_color(colors[i]), clutter_rectangle_new_with_color(light_colors[i]));
		clutter_container_add_actor(CLUTTER_CONTAINER(views[i]), buttons[i]);
	}
	for (i = 0; i < 3; i++) {
		vault = tangle_vault_new(2, TANGLE_TYPE_ACTOR, views[i], TANGLE_TYPE_ACTOR, views[(i + 1) % 3]);
		tangle_signal_connect_vault(buttons[i], "clicked", G_CALLBACK(on_button_clicked), vault);
	}
	
	clutter_actor_show(stage);
	clutter_actor_show(views[0]);

	clutter_main();

	return 0;
}
