/*
 * tangle-call-function-action.h
 *
 * This file is part of Tangle Toolkit - A graphical actor library based on Clutter Toolkit
 *
 * (c) 2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#ifndef __TANGLE_CALL_FUNCTION_ACTION_H__
#define __TANGLE_CALL_FUNCTION_ACTION_H__

#include "tangle-action.h"

#define TANGLE_TYPE_CALL_FUNCTION_ACTION (tangle_call_function_action_get_type())
#define TANGLE_CALL_FUNCTION_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), TANGLE_TYPE_CALL_FUNCTION_ACTION, TangleCallFunctionAction))
#define TANGLE_IS_CALL_FUNCTION_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), TANGLE_TYPE_CALL_FUNCTION_ACTION))
#define TANGLE_CALL_FUNCTION_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), TANGLE_TYPE_CALL_FUNCTION_ACTION, TangleCallFunctionActionClass))
#define TANGLE_IS_CALL_FUNCTION_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), TANGLE_TYPE_CALL_FUNCTION_ACTION))
#define TANGLE_CALL_FUNCTION_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), TANGLE_TYPE_CALL_FUNCTION_ACTION, TangleCallFunctionActionClass))

typedef struct _TangleCallFunctionActionPrivate TangleCallFunctionActionPrivate;

typedef struct _TangleCallFunctionAction {
	TangleAction parent_instance;
	TangleCallFunctionActionPrivate* priv;
} TangleCallFunctionAction;

typedef struct _TangleCallFunctionActionClass {
	TangleActionClass parent_class;
} TangleCallFunctionActionClass;

GType tangle_call_function_action_get_type(void) G_GNUC_CONST;

TangleAction* tangle_call_function_action_new(void);
TangleAction* tangle_call_function_action_new_with_function(TangleActionFunction function_pointer);

const gchar* tangle_call_function_action_get_function_name(TangleCallFunctionAction* action);
void tangle_call_function_action_set_function_name(TangleCallFunctionAction* action, const gchar* function_name);
TangleActionFunction tangle_call_function_action_get_function_pointer(TangleCallFunctionAction* action);
void tangle_call_function_action_set_function_pointer(TangleCallFunctionAction* action, TangleActionFunction function_pointer);

#endif
