/*
 * tangle-scrolling-actor.h
 *
 * This file is part of Tangle Toolkit - A graphical actor library based on Clutter Toolkit
 *
 * (c) 2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#ifndef __TANGLE_SCROLLING_ACTOR_H__
#define __TANGLE_SCROLLING_ACTOR_H__

#include "tangle-wrapper-actor.h"

#define TANGLE_TYPE_SCROLLING_ACTOR (tangle_scrolling_actor_get_type())
#define TANGLE_SCROLLING_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), TANGLE_TYPE_SCROLLING_ACTOR, TangleScrollingActor))
#define TANGLE_IS_SCROLLING_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), TANGLE_TYPE_SCROLLING_ACTOR))
#define TANGLE_SCROLLING_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), TANGLE_TYPE_SCROLLING_ACTOR, TangleScrollingActorClass))
#define TANGLE_IS_SCROLLING_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), TANGLE_TYPE_SCROLLING_ACTOR))
#define TANGLE_SCROLLING_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), TANGLE_TYPE_SCROLLING_ACTOR, TangleScrollingActorClass))

typedef struct _TangleScrollingActorPrivate TangleScrollingActorPrivate;

typedef struct _TangleScrollingActor {
	TangleWrapperActor parent_instance;
	TangleScrollingActorPrivate* priv;
} TangleScrollingActor;

typedef struct _TangleScrollingActorClass {
	TangleWrapperActorClass parent_class;
} TangleScrollingActorClass;

GType tangle_scrolling_actor_get_type(void) G_GNUC_CONST;

ClutterActor* tangle_scrolling_actor_new(ClutterActor* wrapped);

gfloat tangle_scrolling_actor_get_scrolling_offset_x(TangleScrollingActor* scrolling_actor);
void tangle_scrolling_actor_set_scrolling_offset_x(TangleScrollingActor* scrolling_actor, gfloat scrolling_offset_x);
gfloat tangle_scrolling_actor_get_scrolling_offset_y(TangleScrollingActor* scrolling_actor);
void tangle_scrolling_actor_set_scrolling_offset_y(TangleScrollingActor* scrolling_actor, gfloat scrolling_offset_y);

gfloat tangle_scrolling_actor_get_scrolling_width(TangleScrollingActor* scrolling_actor);
gfloat tangle_scrolling_actor_get_scrolling_height(TangleScrollingActor* scrolling_actor);

gfloat tangle_scrolling_actor_get_scrolling_treshold_x(TangleScrollingActor* scrolling_actor);
void tangle_scrolling_actor_set_scrolling_treshold_x(TangleScrollingActor* scrolling_actor, gfloat scrolling_threshold_x);
gfloat tangle_scrolling_actor_get_scrolling_treshold_y(TangleScrollingActor* scrolling_actor);
void tangle_scrolling_actor_set_scrolling_treshold_y(TangleScrollingActor* scrolling_actor, gfloat scrolling_threshold_y);
void tangle_scrolling_actor_set_scrolling_treshold(TangleScrollingActor* scrolling_actor, gfloat scrolling_threshold);

#endif
