/*
 * tangle-layout.h
 *
 * This file is part of Tangle Toolkit - A graphical widget library based on Clutter Toolkit
 *
 * (c) 2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#ifndef __TANGLE_LAYOUT_H__
#define __TANGLE_LAYOUT_H__

#define TANGLE_TYPE_LAYOUT (tangle_layout_get_type())
#define TANGLE_LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), TANGLE_TYPE_LAYOUT, TangleLayout))
#define TANGLE_IS_LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), TANGLE_TYPE_LAYOUT))
#define TANGLE_LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), TANGLE_TYPE_LAYOUT, TangleLayoutClass))
#define TANGLE_IS_LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), TANGLE_TYPE_LAYOUT))
#define TANGLE_LAYOUT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), TANGLE_TYPE_LAYOUT, TangleLayoutClass))

typedef struct _TangleLayoutPrivate TangleLayoutPrivate;
typedef struct _TangleLayout TangleLayout;
typedef struct _TangleLayoutClass TangleLayoutClass;

#include "tangle-widget.h"
#include "tangle-layout-meta.h"

struct _TangleLayout {
	GObject parent_instance;
	TangleLayoutPrivate* priv;
};

struct _TangleLayoutClass {
	GObjectClass parent_class;
	
	void (*get_preferred_width)(TangleLayout* layout, TangleWidget* widget, gfloat for_height, gfloat* min_width_p, gfloat* natural_width_p);
	void (*get_preferred_height)(TangleLayout* layout, TangleWidget* widget, gfloat for_width, gfloat* min_height_p, gfloat* natural_height_p);
	void (*allocate)(TangleLayout* layout, TangleWidget* widget, gfloat width, gfloat height, ClutterAllocationFlags flags);
	TangleLayoutMeta* (*create_layout_meta)(TangleLayout* layout, ClutterActor* actor);
};

typedef enum {
	TANGLE_LAYOUT_DIRECTION_LTR_TTB = 0,
	TANGLE_LAYOUT_DIRECTION_RTL_TTB = 1,
	TANGLE_LAYOUT_DIRECTION_LTR_BTT = 2,
	TANGLE_LAYOUT_DIRECTION_RTL_BTT = 3,
	TANGLE_LAYOUT_DIRECTION_TTB_LTR = 4,
	TANGLE_LAYOUT_DIRECTION_TTB_RTL = 5,
	TANGLE_LAYOUT_DIRECTION_BTT_LTR = 6,
	TANGLE_LAYOUT_DIRECTION_BTT_RTL = 7
} TangleLayoutDirection;

#define TANGLE_LAYOUT_DIRECTION_RTL TANGLE_LAYOUT_DIRECTION_RTL_TTB
#define TANGLE_LAYOUT_DIRECTION_BTT TANGLE_LAYOUT_DIRECTION_LTR_BTT
#define TANGLE_LAYOUT_DIRECTION_VERTICAL_FIRST TANGLE_LAYOUT_DIRECTION_TTB_LTR

GType tangle_layout_get_type(void) G_GNUC_CONST;

TangleWidget* tangle_layout_get_widget(TangleLayout* layout);
void tangle_layout_set_widget(TangleLayout* layout, TangleWidget* widget);

void tangle_layout_get_preferred_width(TangleLayout* layout, gfloat for_height, gfloat* min_width_p, gfloat* natural_width_p);
void tangle_layout_get_preferred_actor_width(TangleLayout* layout, ClutterActor* actor, gfloat for_height, gfloat* min_width_p, gfloat* natural_width_p);
void tangle_layout_get_preferred_interactive_width(TangleLayout* layout, ClutterActor* actor, gfloat for_height, gboolean interactive, gfloat* min_width_p, gfloat* natural_width_p, gfloat* max_width_p);

void tangle_layout_get_preferred_height(TangleLayout* layout, gfloat for_width, gfloat* min_height_p, gfloat* natural_height_p);
void tangle_layout_get_preferred_actor_height(TangleLayout* layout, ClutterActor* actor, gfloat for_width, gfloat* min_height_p, gfloat* natural_height_p);
void tangle_layout_get_preferred_interactive_height(TangleLayout* layout, ClutterActor* actor, gfloat for_width, gboolean interactive, gfloat* min_height_p, gfloat* natural_height_p, gfloat* max_height_p);

void tangle_layout_allocate(TangleLayout* layout, const ClutterActorBox* box, ClutterAllocationFlags flags);
void tangle_layout_allocate_actor(TangleLayout* layout, ClutterActor* actor, ClutterActorBox* box, ClutterAllocationFlags flags);

TangleLayoutDirection tangle_layout_get_direction(TangleLayout* layout);
void tangle_layout_set_direction(TangleLayout* layout, TangleLayoutDirection direction);

TangleLayoutMeta* tangle_layout_get_meta(TangleLayout* layout, ClutterActor* actor);

#endif
