/*
 * tangle-stylable.h
 *
 * This file is part of Tangle Toolkit - A graphical widget library based on Clutter Toolkit
 *
 * (c) 2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#ifndef __TANGLE_STYLABLE_H__
#define __TANGLE_STYLABLE_H__

#include <clutter/clutter.h>
#include "tangle-stylesheet.h"

#define TANGLE_TYPE_STYLABLE (tangle_stylable_get_type ())
#define TANGLE_STYLABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TANGLE_TYPE_STYLABLE, TangleStylable))
#define TANGLE_IS_STYLABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TANGLE_TYPE_STYLABLE))
#define TANGLE_STYLABLE_GET_IFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TANGLE_TYPE_STYLABLE, TangleStylableIface))

typedef struct _TangleStylable TangleStylable;

typedef struct _TangleStylableIface
{
	GTypeInterface parent_interface;
	
	gboolean (*apply_stylesheet)(TangleStylable* stylable, TangleStylesheet* stylesheet);
	gboolean (*unapply_stylesheet)(TangleStylable* stylable, TangleStylesheet* stylesheet);
	gboolean (*set_style_property)(TangleStylable* stylable, const gchar* name, const GValue* value);
	gboolean (*unset_style_property)(TangleStylable* stylable, const gchar* name, const GValue* value);
	gboolean (*is_style_property)(TangleStylable* stylable, const gchar* name, const GValue* value);
} TangleStylableIface;

GType tangle_stylable_get_type(void);

gboolean tangle_stylable_apply_stylesheet(TangleStylable* stylable, TangleStylesheet* stylesheet);
gboolean tangle_stylable_unapply_stylesheet(TangleStylable* stylable, TangleStylesheet* stylesheet);
gboolean tangle_stylable_set_style_property(TangleStylable* stylable, const gchar* name, const GValue* value);
gboolean tangle_stylable_unset_style_property(TangleStylable* stylable, const gchar* name, const GValue* value);
gboolean tangle_stylable_is_style_property(TangleStylable* stylable, const gchar* name, const GValue* value);

#endif
