/*
 * tangle-wrapper-actor.h
 *
 * This file is part of Tangle Toolkit - A graphical actor library based on Clutter Toolkit
 *
 * (c) 2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#ifndef __TANGLE_WRAPPER_ACTOR_H__
#define __TANGLE_WRAPPER_ACTOR_H__

#include "tangle-actor.h"

#define TANGLE_TYPE_WRAPPER_ACTOR (tangle_wrapper_actor_get_type())
#define TANGLE_WRAPPER_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), TANGLE_TYPE_WRAPPER_ACTOR, TangleWrapperActor))
#define TANGLE_IS_WRAPPER_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), TANGLE_TYPE_WRAPPER_ACTOR))
#define TANGLE_WRAPPER_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), TANGLE_TYPE_WRAPPER_ACTOR, TangleWrapperActorClass))
#define TANGLE_IS_WRAPPER_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), TANGLE_TYPE_WRAPPER_ACTOR))
#define TANGLE_WRAPPER_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), TANGLE_TYPE_WRAPPER_ACTOR, TangleWrapperActorClass))

typedef struct _TangleWrapperActorPrivate TangleWrapperActorPrivate;

typedef struct _TangleWrapperActor {
	TangleActor parent_instance;
	TangleWrapperActorPrivate* priv;
} TangleWrapperActor;

typedef struct _TangleWrapperActorClass {
	TangleActorClass parent_class;
	void (*allocate_wrapped)(TangleWrapperActor* wrapper_actor, ClutterActor* wrapped, const ClutterActorBox* box, ClutterAllocationFlags flags);
} TangleWrapperActorClass;

GType tangle_wrapper_actor_get_type(void) G_GNUC_CONST;

ClutterActor* tangle_wrapper_actor_new(ClutterActor* wrapped);

ClutterActor* tangle_wrapper_actor_get_wrapped(TangleWrapperActor* wrapper_actor);

#endif
