
/*
 * tangle-misc.h
 *
 * This file is part of Tangle Toolkit - A graphical widget library based on Clutter Toolkit
 *
 * (c) 2009-2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#ifndef __TANGLE_MISC_H__
#define __TANGLE_MISC_H__

#include <glib-object.h>

gboolean tangle_init(int* argc, char*** argv);

#define TANGLE_UNREF_AND_NULLIFY_OBJECT_POINTER(x) tangle_unref_and_nullify_object_pointer_impl((GObject**)&(x))
#define TANGLE_UNREF_OBJECT(x) (x ? g_object_unref(x) : ; )

void tangle_unref_and_nullify_object_pointer_impl(GObject** object_pointer);

typedef gpointer TanglePointers;

TanglePointers* tangle_pointers_new(gint n, ...);
void tangle_pointers_get(TanglePointers* pointers, gint n, ...);
void tangle_pointers_free(TanglePointers* pointers, gint n);

#define TANGLE_POINTERS(p) ((TanglePointers*)(p))

gboolean tangle_lookup_construct_properties(GType type, guint n_construct_properties, GObjectConstructParam* construct_properties, const gchar* first_property_name, ...);
GObject* tangle_construct_with_extra_properties(GObject* (*constructor)(GType, guint, GObjectConstructParam*), GType type, guint n_construct_properties, GObjectConstructParam* construct_properties, const gchar* first_extra_property_name, ...);

gboolean tangle_signal_accumulator_non_null_handled(GSignalInvocationHint* ihint, GValue* return_accu, const GValue* handler_return, gpointer user_data);

#endif
