/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.gtk.OS;

public class HTMLTransfer
extends ByteArrayTransfer {
    private static HTMLTransfer _instance = new HTMLTransfer();
    private static final String TEXT_HTML = "text/html";
    private static final int TEXT_HTML_ID = HTMLTransfer.registerType("text/html");
    private static final String TEXT_HTML2 = "TEXT/HTML";
    private static final int TEXT_HTML2_ID = HTMLTransfer.registerType("TEXT/HTML");

    private HTMLTransfer() {
    }

    public static HTMLTransfer getInstance() {
        return _instance;
    }

    @Override
    public void javaToNative(Object object, TransferData transferData) {
        transferData.result = 0;
        if (!this.checkHTML(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        String string = (String)object;
        int n = string.length();
        char[] cArray = new char[n + 1];
        string.getChars(0, n, cArray, 0);
        int n2 = cArray.length * 2;
        int n3 = OS.g_malloc(n2);
        if (n3 == 0) {
            return;
        }
        OS.memmove(n3, cArray, n2);
        transferData.length = n2;
        transferData.format = 8;
        transferData.pValue = n3;
        transferData.result = 1;
    }

    @Override
    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.pValue == 0) {
            return null;
        }
        int n = transferData.format * transferData.length / 8 / 2 * 2;
        if (n <= 0) {
            return null;
        }
        char[] cArray = new char[n / 2];
        OS.memmove(cArray, transferData.pValue, n);
        String string = new String(cArray);
        int n2 = string.indexOf(0);
        return n2 == -1 ? string : string.substring(0, n2);
    }

    @Override
    protected int[] getTypeIds() {
        return new int[]{TEXT_HTML_ID, TEXT_HTML2_ID};
    }

    @Override
    protected String[] getTypeNames() {
        return new String[]{TEXT_HTML, TEXT_HTML2};
    }

    boolean checkHTML(Object object) {
        return object != null && object instanceof String && ((String)object).length() > 0;
    }

    @Override
    protected boolean validate(Object object) {
        return this.checkHTML(object);
    }
}

