TARGET = qoauth

VERSION = 1.0.1

TEMPLATE = lib
QT += network
QT -= gui
CONFIG += \
    crypto \
    create_prl

OBJECTS_DIR = tmp
MOC_DIR = tmp
INC_DIR = include

INCLUDEPATH += .

PUBLIC_HEADERS += \
    qoauth_global.h \
    qoauth_namespace.h \
    interface.h
PRIVATE_HEADERS += \
    interface_p.h

HEADERS = \
    $$PUBLIC_HEADERS \
    $$PRIVATE_HEADERS
SOURCES += interface.cpp

DEFINES += QOAUTH

headers.files = \
    $${PUBLIC_HEADERS} \
    $${INC_DIR}/QtOAuth
features.path = $$[QMAKE_MKSPECS]/features
features.files = oauth.prf
docs.files = doc/html

unix {
    isEmpty( PREFIX ):INSTALL_PREFIX = /usr
    else:INSTALL_PREFIX = $${PREFIX}

    # this creates a pkgconfig file
    system( ./pcfile.sh $${INSTALL_PREFIX} $${VERSION} )
    pkgconfig.files = qoauth.pc
    
    contains(QMAKE_HOST.arch, x86_64) {
      target.path = $${INSTALL_PREFIX}/lib64
    } else {
      target.path = $${INSTALL_PREFIX}/lib
    }

    headers.path = $${INSTALL_PREFIX}/include/QtOAuth
    docs.path = $${INSTALL_PREFIX}/share/doc/$${TARGET}-$${VERSION}/html
    pkgconfig.path = $${target.path}/pkgconfig
    INSTALLS += \
        target \
        headers \
        docs \
        pkgconfig \
        features
}
