/** This file is part of PeerHood.
*
*   PeerHood is free software: you can redistribute it and/or modify
*   it under the terms of the GNU Lesser General Public License 
*   version 2 as published by the Free Software Foundation.
*
*   PeerHood is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU Lesser General Public License for more details.
*
*   You should have received a copy of the GNU Lesser General Public
*   License along with PeerHood. If not, see <http://www.gnu.org/licenses/>.
*/

// Emacs, hail the mighty -*-C++-*-

/**
 * Copyright 2003 LUT. .
 *
 * @name DaemonDevice.h
 * @memo Implementation of the MAbstractDevice. This version is used by the
 * PeerHood daemon.
 *
 * @version 0.2
 * date     09.04.2003
 * change   19.03.2005
 */

#ifndef __DAEMONDEVICE_H__
#define __DAEMONDEVICE_H__

#include <BaseDevice.h>

/**
 * @memo Implementation of the MAbstractDevice interface. This version is used
 * by the PeerHood daemon and the plugins.
 * @doc Implementation of the MAbstractDevice interface. This version is used
 * by the PeerHood daemon and the plugins. The specialities of this version are
 * functions that allow modifications to the stored data unlike in the case of
 * <code>CLibDevice</code>. 
 *
 * @see MAbstractDevice
 * @see CBaseDevice
 * @see CLibDevice
 */
class CDaemonDevice : public CBaseDevice
{
 public:
  CDaemonDevice(const CDaemonDevice&);
  CDaemonDevice(const char* aData);
  CDaemonDevice(const std::string& aDeviceAddress);
  CDaemonDevice(const std::string& aDeviceAddress, const std::string& aReferrerName);

  int GetTimestamp();
  const std::string& GetReferrerName();
  void IncreaseTimestamp();

  int GetNeighborListSize();

  // Some setters
  void SetPeerHood(bool aHasPeerHood);
  void SetPrototype(const char* aProto);
  void SetTimestamp(int aValue);
  void SetDeviceName(const std::string& aDeviceName);
  void SetChecksum(unsigned int aChecksum);

  void AddPrototype(char* aPrototype);

  void SetReferrerName(const std::string& aReferrerName);
  char* MarshallL(int* aLength);

  // Method to add devices into the list of neighboring devices
  void AddNeighboringDevice(CDaemonDevice* aDaemonDevice);

  void DebugDevice();

  bool CheckNeighbors(const std::string& aAddress);
  
 private:
  int iTimestamp;
  
  // List for devices seen by this device
  std::list<CDaemonDevice*> iNeighboringDevices;
};

#endif // __DAEMONDEVICE_H__
