/** This file is part of PeerHood.
*
*   PeerHood is free software: you can redistribute it and/or modify
*   it under the terms of the GNU Lesser General Public License 
*   version 2 as published by the Free Software Foundation.
*
*   PeerHood is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU Lesser General Public License for more details.
*
*   You should have received a copy of the GNU Lesser General Public
*   License along with PeerHood. If not, see <http://www.gnu.org/licenses/>.
*/

/**
 * Copyright 2008 LUT. .
 *
 * @name MaemoBTListener.h
 * @memo Maemo BTcond-specific implementation of MAbstractListener
 *
 * @version 0.19
 * date     10.10.2008
 * change   17.12.2008
 */

#ifndef __MAEMOBTLISTENER_H_
#define __MAEMOBTLISTENER_H_

#include <dbus/dbus.h>
#include <syslog.h>
#include <stdio.h>
#include "AbstractListener.h"
#include "AbstractStateConverter.h"

#define ERR(format, msg...) printf(format "\n",## msg)

#ifdef PH_DEBUG
#define DBG(format, msg...) syslog(LOG_DEBUG, format "\n" , ## msg)
#else
#define DBG( A... )
#endif

/**
 * @memo Maemo btcond specific implementation of MAbstractListner
 * @doc Listens signals emitted by btcond in Maemo. Changes the activity 
 * state of the owner component. Used by the owner component only. When
 * created listener automatically registers to given component. Currently listens
 * only device up & down signals from btcond. Uses private connection to D-Bus.
 * Initial state checking is not implemented - btcond doesn't support initial check
 * of the device, only changes in device state are sent as signals. To check the
 * initial state use BluezBTListener.
 * 
 * @see MAbstractListener
 * @see MAbstractStateConverter
 * @see BluezBTListener
 * 
 */
class CMaemoBTListener : public MAbstractListener
{
public:
	CMaemoBTListener(MAbstractStateConverter *aConverter);
	virtual ~CMaemoBTListener();
	
	// Listener interface
	bool Connect();
	void Disconnect();
	void CheckInitialState();
	void CheckState();
	const std::string& GetName();
	
private:
	CMaemoBTListener();
	bool SetupConnection();
	bool RegisterSignals();
	void HandleMessage(DBusMessage* message);
	
	// Connection object
	DBusConnection* iConnection;

	// Name of the listener
	std::string iName;

	// Connection to "owner"
	MAbstractStateConverter* iConverter;
};

#endif /*__MAEMOBTLISTENER_H_*/
