/** This file is part of PeerHood.
*
*   PeerHood is free software: you can redistribute it and/or modify
*   it under the terms of the GNU Lesser General Public License 
*   version 2 as published by the Free Software Foundation.
*
*   PeerHood is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU Lesser General Public License for more details.
*
*   You should have received a copy of the GNU Lesser General Public
*   License along with PeerHood. If not, see <http://www.gnu.org/licenses/>.
*/

/**
 * Copyright 2008 LUT. .
 *
 * @name ListenerFactory.h
 * @memo Definition of the static abstract listener factory. Used to create
 * platform and / or device specific MAbstractListener objects based on the
 * prototype name for monitoring device / system state.
 *
 * @version 0.02
 * date     25.08.2008
 * change   23.09.2008
 */

#ifndef __LISTENERFACTORY_H__
#define __LISTENERFACTORY_H__

#include <list>
#include "AbstractStateConverter.h"
#include "AbstractListener.h"
#include "AbstractListenerCreator.h"

/** 
 * @memo Static abstract listener factory class, creates platform / device 
 * specific listeners for system state changes based on the prototype name.
 * @doc Class for creating MAbstractListener objects for system state
 * monitoring. This class has a list of creators (MAbstractListenerCreator)
 * which are used to create actual objects, creators have to register into this
 * listener by calling the Register()-function when the creator is created. 
 */

class ListenerFactory
{
public:
	
	virtual ~ListenerFactory();
	
	static ListenerFactory* GetInstance();
	
	void Register(MAbstractListenerCreator* aCreator);
	
	int CreateListeners(const std::string& aName, MAbstractStateConverter* aConverter);
	
private:

	ListenerFactory();
		
	std::list<MAbstractListenerCreator*> iCreators;
	
	static ListenerFactory *iInstance;
};

#endif /*__LISTENERFACTORY_H__*/

