/** This file is part of PeerHood.
*
*   PeerHood is free software: you can redistribute it and/or modify
*   it under the terms of the GNU Lesser General Public License 
*   version 2 as published by the Free Software Foundation.
*
*   PeerHood is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU Lesser General Public License for more details.
*
*   You should have received a copy of the GNU Lesser General Public
*   License along with PeerHood. If not, see <http://www.gnu.org/licenses/>.
*/

/* 
 * @name C_Callback.h
 * @memo C_Callback class, inherits CBasicCallback. A callback for C applications.
 *
 * @version 0.34
 * date     12.11.2009
 * change   17.03.2010
 */

#include "BasicCallback.h"

#ifndef __C_CALLBACK_H
#define __C_CALLBACK_H

#ifdef __cplusplus

class C_Callback : public CBasicCallback
{
	public:
	C_Callback(void(*callback_notify)(short, const char*, void*),
		void(*callback_newconnection)(const unsigned short, MAbstractConnection*, int, void*),
		void *notifydata,
		void *newconndata);
	
	virtual void Notify(TEventType aEvent, const std::string& aAddress);
  virtual void NewConnection(const unsigned short aPort, MAbstractConnection* aConnection, int aConnectionId);
  
  private:
  void (*callback_notify_function)(short,const char*,void*) __attribute__((cdecl));
  void (*callback_newconnection_function)(const unsigned short, MAbstractConnection*, int, void*) __attribute__((cdecl));
  
  void *iNotifyData;
  void *iNewConnectionData;
};

#else // C
typedef
	struct C_Callback
		C_Callback;
#endif // __cplusplus

#ifdef __cplusplus
extern "C" {
#endif

C_Callback* ph_c_create_callback(void(*callback_notify)(short, const char*, void*),
	void(*callback_newconnection)(const unsigned short, MAbstractConnection*, int, void*),
	void *notifydata,
	void *newconndata);

void ph_c_delete_callback(C_Callback* aCallback);

#ifdef __cplusplus
}
#endif


#endif // __C_CALLBACK_H
