/** This file is part of PeerHood.
*
*   PeerHood is free software: you can redistribute it and/or modify
*   it under the terms of the GNU Lesser General Public License 
*   version 2 as published by the Free Software Foundation.
*
*   PeerHood is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU Lesser General Public License for more details.
*
*   You should have received a copy of the GNU Lesser General Public
*   License along with PeerHood. If not, see <http://www.gnu.org/licenses/>.
*/

// Emacs, hail the mighty -*-C++-*-

/**
 * Copyright 2003 LUT. .
 *
 * @name BaseDevice.h
 * @memo Basic implementation of the MAbstractDevice interface.
 *
 * @version 0.1
 * date     23.04.2003
 * change   23.04.2003
 * update 2.8.2006 JP - add information concerning all prototypes supported
 */

#ifndef __BASEDEVICE_H__
#define __BASEDEVICE_H__

#include "AbstractDevice.h"
#include <list>
#include <string.h>

/**
 * @memo Basic implementation of the MAbstractDevice interface.
 * @doc <Basic implementation of the MAbstractDevice interface. This class
 * contains only a minimum implementation of the interface.
 *
 * @see MAbstractDevice
 * @see CLibDevice
 * @see CDaemonDevice
 */
class CBaseDevice : public MAbstractDevice
{
 public:
  virtual ~CBaseDevice();

  void AddService(CService* aService);

  // Some getters
  const std::string& GetAddress();
  const std::string& GetName();
  unsigned int GetChecksum();

  const std::string& GetPrototype();
  TServiceList* GetServiceListL();

  int GetProtoListSize();
  int GetServiceListSize();

  bool HasService(const std::string& aServiceName);
  bool HasPeerHood();

  bool CheckService(unsigned short aPort);
  bool CheckPrototype(char* aProto);

 protected:
  // PeerHood flag
  bool iHasPeerHood;

  // Device id things
  std::string iAddress;
  std::string iName;
  std::string iReferrerName;
  unsigned int iChecksum;

  // Prototype issues
  // iPrototype is the one that found the device
  // iSupportedPrototypes lists all protos supported by the device
  std::string iPrototype;
  std::list<char*> iSupportedPrototypes;

  // iServiceList is the list of services in remote device
  std::list<CService*> iServiceList;
};

#endif // __BASEDEVICE_H__
