/** This file is part of PeerHood.
*
*   PeerHood is free software: you can redistribute it and/or modify
*   it under the terms of the GNU Lesser General Public License 
*   version 2 as published by the Free Software Foundation.
*
*   PeerHood is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU Lesser General Public License for more details.
*
*   You should have received a copy of the GNU Lesser General Public
*   License along with PeerHood. If not, see <http://www.gnu.org/licenses/>.
*/

/**
 * Copyright 2008 LUT. .
 *
 * @name BluezBTCreator.cc
 * @memo Bluez-specific implementation of MAbstractListenerCreator
 *
 * @version 0.16
 * date     14.11.2008
 * change   16.12.2008
 */

#include <string>
#include "ListenerFactory.h"
#include "BluezBTCreator.h"
#include "BluezBTListener.h"

/**
 * @memo Constructor
 * @doc When created the instance registers itself to ListenerFactory.
 */
CBluezBTCreator::CBluezBTCreator()
{
	/** @TODO Remove hard-coded value, get it from somewhere ? */
	iProto = std::string("bt");
	DBG("CBluezBTCreator::Constructor: %s",iProto.c_str());
	ListenerFactory::GetInstance()->Register(this);
}

/**
 * @memo Creates a listener
 * @doc Creates a BluezBTListener if the given type name corresponds to "bt". Returns
 * a reference to that listener. The component that will be given as parameter will be passed
 * to the listeners constructor.
 * 
 * @param aName Name of the type that is being created.
 * @param aConverter Component that will own the listener.
 * 
 * @returns reference to created instance or NULL if the type name was incorrect
 */
MAbstractListener* CBluezBTCreator::CreateListener(const std::string & aName, MAbstractStateConverter* aConverter)
{
	if(iProto.compare(aName) == 0)
	{
		return new CBluezBTListener(aConverter);
	}
	else return NULL;
}

static CBluezBTCreator bluezbtcreator;
