/** This file is part of PeerHood.
*
*   PeerHood is free software: you can redistribute it and/or modify
*   it under the terms of the GNU Lesser General Public License 
*   version 2 as published by the Free Software Foundation.
*
*   PeerHood is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU Lesser General Public License for more details.
*
*   You should have received a copy of the GNU Lesser General Public
*   License along with PeerHood. If not, see <http://www.gnu.org/licenses/>.
*/

/**
 * Copyright 2003 LUT. .
 *
 * @name Daemon.cc
 * @memo Main file of the PeerHood Daemon.
 *
 * @version 0.1
 * date     03.04.2003
 * change   03.04.2003
 */

#include <syslog.h>
#include <cstdlib>
#include <unistd.h>
#include <string.h>
#include <iostream>

#include "Daemon.h"


using namespace std;

/**
 * @memo Main function of the PeerHood Daemon.
 * @doc Main function of the PeerHood Daemon. This function creates a new
 * instance of the Daemon class and initializes it. If the initialization is
 * succesfull then the daemon object is started. The daemon keeps running until
 * it is terminated either by SIGTERM or SIGINT signal.
 *
 * @return system failure code if the daemon initialization fails
 */
int main(int argc, char** argv)
{
	CDaemon daemon;
	
	// 2 parameters given
	if(argc == 2 || argc == 3)
	{
		if(strcmp(argv[1],"active") == 0) daemon.DaemonRevertMode(false);
		else if(strcmp(argv[1],"passive") == 0) daemon.DaemonRevertMode(true);
		else
		{
			cerr << "Invalid parameter, starting anyway." << endl << "Correct usage: ./peerhoodd <active|passive>" << endl;
			cerr << "Or run as daemon: ./peerhoodd <active|passive> <daemon>" << endl;
		}
	}

  DBG("  ");
  DBG("  ");
  DBG("    ---- starting daemon ----    ");
  DBG("  ");
  DBG("  ");

  cerr << "starting peerhoodd" << endl;
  
  /* TODO: MakeDaemon closes stdin,out, error: not hood */
  
  if((argc == 3) && (strcmp(argv[2],"daemon") == 0))
  {
		if (!daemon.MakeDaemon()) {
		  ERR("failed to initialize");
		  cerr << "failed to initialize" << endl;
		  exit(EXIT_FAILURE);
		}
	}
  else
  {
		if (!daemon.Init()) {
		  ERR("failed to initialize");
		  cerr << "failed to initialize" << endl;
		  exit(EXIT_FAILURE);
		}
	}


  DBG("  ");
  DBG("    ---- up and running ----    ");
  DBG("  ");

  daemon.Run();

  return 0;
}
