/** This file is part of PeerHood.
*
*   PeerHood is free software: you can redistribute it and/or modify
*   it under the terms of the GNU Lesser General Public License 
*   version 2 as published by the Free Software Foundation.
*
*   PeerHood is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU Lesser General Public License for more details.
*
*   You should have received a copy of the GNU Lesser General Public
*   License along with PeerHood. If not, see <http://www.gnu.org/licenses/>.
*/

// Emacs, hail the mighty -*-C++-*-

/**
 * Copyright 2003 LUT. .
 *
 * @name UDPConnection.h
 * @memo UDP -specific implementation
 * 
 * @version 0.11
 * date     04.07.2003
 * change   28.04.2010
 */

#ifndef __UDPCONNECTION_H__
#define __UDPCONNECTION_H__

#include <string>
#include "IFSearch.h"

/**
 * @memo WLAN UDP -specific implementation
 * @doc WLAN UDP -specific implementation
 * This class offers a unified interface through what WLAN can be used
 * like any other transport medium in the PeerHood environment.
 */
class CUDPConnection
{
 public:
   CUDPConnection(const std::string& aIface);
  ~CUDPConnection();
  void Close();
  
  bool Listen(int aPort, const std::string& aMode);
  bool IsListening();
  bool HasData();
 
  int Write(const void* aOutBuf, int aLength, int aPort, const std::string& aAddress, const std::string& aMode);
  int Read(void* aInBuf, int aLength);
  int GetFd();

  struct IFInfo *GetInterfaces();
  const std::string& GetRemoteAddress();
  unsigned int GetDeviceChecksum();
 
 private:
  std::string iIface;
  int iSocket;
  bool iConnected;
  bool iIsListening;
  std::string iRemoteAddress;
  struct IFInfo *iIfaces;
};

#endif //__UDPCONNECTION_H__
