/** This file is part of PeerHood.
*
*   PeerHood is free software: you can redistribute it and/or modify
*   it under the terms of the GNU Lesser General Public License 
*   version 2 as published by the Free Software Foundation.
*
*   PeerHood is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU Lesser General Public License for more details.
*
*   You should have received a copy of the GNU Lesser General Public
*   License along with PeerHood. If not, see <http://www.gnu.org/licenses/>.
*/

// Emacs, hail the mighty -*-C++-*-

/**
 * Copyright 2003 LUT. .
 *
 * @name LocalConnection.h
 * @memo Local (UNIX) socket specific implementation of the MAbstractConnection
 * interface.
 *
 * @version 0.2
 * date     23.04.2003
 * change   28.04.2010
 */

#ifndef __LOCALCONNECTION_H__
#define __LOCALCONNECTION_H__

#include <AbstractConnection.h>

/**
 * @memo Local (UNIX) socket specific implementation of the MAbstractConnection
 * interface.
 * @doc Local (UNIX) socket specific implementation of the MAbstractConnection interface.
 * This class offers a unified interface through what local sockets can be used
 * like any other transport medium in the PeerHood environment. Note that no
 * instances of this class should be created directly. Instead, use the
 * provided PeerHood factory class.
 *
 * @see MAbstractConnection
 */
class CLocalConnection : public MAbstractConnection
{
 public:
  CLocalConnection();
  virtual ~CLocalConnection();
  MAbstractConnection* AcceptL();
  void Close();
  bool Connect(const std::string& aAddress, int aPort);
  bool Disconnect();
  bool Listen();
  bool Listen(int aPort);
  bool IsConnected();
  bool IsListening();
  bool HasData();
  int Write(const void* aOutBuf, int aLength);
  int Read(void* aInBuf, int aLength);
  const std::string& GetRemoteAddress();
  unsigned int GetDeviceChecksum();
  void SetDeviceChecksum(unsigned int aChecksum);
  int GetFd();

 private:
  int iSocket;
  bool iConnected;
  bool iIsListening;
  std::string iRemoteAddress;
  std::string iAddress;
};

#endif // __LOCALCONNECTION_H__
