/** This file is part of PeerHood.
*
*   PeerHood is free software: you can redistribute it and/or modify
*   it under the terms of the GNU Lesser General Public License 
*   version 2 as published by the Free Software Foundation.
*
*   PeerHood is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU Lesser General Public License for more details.
*
*   You should have received a copy of the GNU Lesser General Public
*   License along with PeerHood. If not, see <http://www.gnu.org/licenses/>.
*/

// Emacs, hail the mighty -*-C++-*-

/**
 * Copyright 2003 LUT. .
 *
 * @name LibDevice.h
 * @memo PeerHood library specific implementation of the MAbstractDevice
 * interface.
 *
 * @version 0.1
 * date     17.04.2003
 * change   17.04.2003
 */

#ifndef __LIBDEVICE_H__
#define __LIBDEVICE_H__

#include "BaseDevice.h"
#include <string.h>

/**
 * @memo PeerHood library specific version of the MAbstractDevice interface.
 * @doc PeerHood library specific version of the MAbstractDevice interface.
 * This implementation lacks many method present in the daemon specific version
 * of the base class. CLibDevice is more tuned for the needs of the developer
 * who's using the PeerHood library.
 *
 * @see MAbstractDevice
 * @see CDaemonDevice
 */
class CLibDevice : public CBaseDevice
{
 public:
  CLibDevice(const char* aData);
};

#endif // __LIBDEVICE_H__
