#ifndef LIBOPENSPOTIFY_CACHE_H
#define LIBOPENSPOTIFY_CACHE_H

#include <spotify/api.h>
#include "sp_opaque.h"
#include "request.h"
#include "debug.h"
//#include <stdbool.h>

//void cache_init(sp_session *session);
int cache_process(sp_session *session, struct request *req);

int cache_init();
void cache_clear();
int cache_contains(unsigned char *id);
unsigned char *cache_load(unsigned char *id, unsigned int *size);
void cache_remove(unsigned char *id);
void cache_store(unsigned char *id, unsigned char *data, unsigned int size);

unsigned int cache_get_meta_playlist_revision();
void cache_set_meta_playlist_revision(unsigned int revision);

#endif
