// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBNOTIFYMM_NOTIFICATION_H
#define _LIBNOTIFYMM_NOTIFICATION_H


#include <glibmm.h>

/* $Id: client.hg,v 1.17 2006/12/23 09:29:35 murrayc Exp $ */
// -*- C++ -*- //

/* client.h
 *
 * Copyright 2003 libnotifymm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libnotifymm/notification.h>


#include <gtkmm/widget.h>
#include <gtkmm/statusicon.h>

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _NotifyNotification NotifyNotification;
typedef struct _NotifyNotificationClass NotifyNotificationClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Notify
{ class Notification_Class; } // namespace Notify
namespace Notify
{

//TODO: Use an enum?
extern const int EXPIRES_DEFAULT;
extern const int EXPIRES_NEVER;

/** @addtogroup libnotifymmEnums Enums and Flags */

/**
 * @ingroup libnotifymmEnums
 */
enum Urgency
{
  URGENCY_LOW,
  URGENCY_NORMAL,
  URGENCY_CRITICAL
};

} // namespace Notify


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Notify::Urgency> : public Glib::Value_Enum<Notify::Urgency>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Notify
{


/** Notification offers a way to show notification for a widget or 
 * in the system tray.
 */

class Notification : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Notification CppObjectType;
  typedef Notification_Class CppClassType;
  typedef NotifyNotification BaseObjectType;
  typedef NotifyNotificationClass BaseClassType;

private:  friend class Notification_Class;
  static CppClassType notification_class_;

private:
  // noncopyable
  Notification(const Notification&);
  Notification& operator=(const Notification&);

protected:
  explicit Notification(const Glib::ConstructParams& construct_params);
  explicit Notification(NotifyNotification* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Notification();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  NotifyNotification*       gobj()       { return reinterpret_cast<NotifyNotification*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const NotifyNotification* gobj() const { return reinterpret_cast<NotifyNotification*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  NotifyNotification* gobj_copy();

private:

public:
  
  /** A constructor for Notification
   *
   * @param summary summary of the notification
   * @param body body text of the notification
   *
   * Creates a new Notification with summary and body. You can set attach_widget and icon later
   */
  Notification(const Glib::ustring& summary, const Glib::ustring& body);
  
  /** A constructor for Notification
   *
   * @param summary summary of the notification
   * @param body body text of the notification
   * @param icon_name name of the icon for the notification, can be a stock id
   *
   * Creates a new Notification with summary, body and icon. You can set an attach_widget later
   */
  Notification(const Glib::ustring& summary, const Glib::ustring& body, const Glib::ustring& icon_name);

  /** A constructor for Notification
   *
   * @param summary summary of the notification
   * @param body body text of the notification
   * @param icon_name name of the icon for the notification, can be a stock id
   * @param attach_widget widget the notification is attach to
   *
   * Creates a new Notification
   */
  explicit Notification(const Glib::ustring& summary, const Glib::ustring& body, const Glib::ustring& icon_name, Gtk::Widget& attach_widget);
  
  /** A constructor for Notification
   *
   * @param summary summary of the notification
   * @param body body text of the notification
   * @param icon_name name of the icon for the notification, can be a stock id
   * @param status_icon Gtk::StatusIcon the notification is attached to
   *
   * Creates a new Notification
   */
  explicit Notification(const Glib::ustring& summary, const Glib::ustring& body, const Glib::ustring& icon_name, const Glib::RefPtr<Gtk::StatusIcon>& status_icon);

  
  /** Updates the notification text and icon. This won't send the update out
   * and display it on the screen. For that, you will need to call
   * show().
   * @param summary The new required summary text.
   * @param body The optional body text.
   * @param icon The optional icon theme icon name or filename.
   * @return <tt>true</tt>, unless an invalid parameter was passed.
   */
  bool update(const Glib::ustring& summary, const Glib::ustring& body, const Glib::ustring& icon);
  
  
  /** Attaches the notification to a widget. This will set hints on the
   * notification requesting that the notification point to the widget's
   * location. If @a attach is <tt>0</tt>, the widget will be unset.
   * @param attach The widget to attach to, or <tt>0</tt>.
   */
  void attach_to_widget(Gtk::Widget& attach);
  
  /** Attaches the notification to a Gtk::StatusIcon. This will set hints on the
   * notification requesting that the notification point to the status icon's
   * location. If @a status_icon is <tt>0</tt>, the status icon will be unset.
   * 
   * Since: 0.4.1
   * @param status_icon The Gtk::StatusIcon to attach to, or <tt>0</tt>.
   */
  void attach_to_status_icon(const Glib::RefPtr<Gtk::StatusIcon>& status_icon);
  
  
  /** Sets the geometry hints on the notification. This sets the screen
   * the notification should appear on and the X, Y coordinates it should
   * point to, if the particular notification supports X, Y hints.
   * 
   * Since: 0.4.1
   * @param screen The Gdk::Screen the notification should appear on.
   * @param x The X coordinate to point to.
   * @param y The Y coordinate to point to.
   */
  void set_geometry_hints(const Glib::RefPtr<Gdk::Screen>& screen, int x, int y);
  
  /** Tells the notification server to display the notification on the screen.
   * @return <tt>true</tt> if successful. On error, this will return <tt>false</tt> and set
   *  @a error.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool show();
#else
  bool show(std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Sets the timeout of the notification. To set the default time, pass
   * Notify::EXPIRES_DEFAULT as @a timeout. To set the notification to never
   * expire, pass Notify::EXPIRES_NEVER.
   * @param timeout The timeout in milliseconds.
   */
  void set_timeout(int timeout);
  
  /** Sets the category of this notification. This can be used by the
   * notification server to filter or display the data in a certain way.
   * @param category The category.
   */
  void set_category(const Glib::ustring& category);
  
  /** Sets the urgency level of this notification.
   * 
   * See: Notify::Urgency
   * @param urgency The urgency level.
   */
  void set_urgency(Urgency urgency);
  
  /** Sets the icon in the notification from a Gdk::Pixbuf.
   * 
   * This will only work when libnotify is compiled against D-BUS 0.60 or
   * higher.
   * @param icon The icon.
   */
  void set_icon_from_pixbuf(const Glib::RefPtr<Gdk::Pixbuf>& icon);

  
  /** Sets a hint with a 32-bit integer value.
   * @param key The hint.
   * @param value The hint's value.
   */
  void set_hint(const Glib::ustring& key, int value);
  
  /** Sets a hint with a double value.
   * @param key The hint.
   * @param value The hint's value.
   */
  void set_hint(const Glib::ustring& key, double value);
  
  /** Sets a hint with a string value.
   * @param key The hint.
   * @param value The hint's value.
   */
  void set_hint(const Glib::ustring& key, const Glib::ustring& value);
  
  /** Sets a hint with a byte value.
   * @param key The hint.
   * @param value The hint's value.
   */
  void set_hint(const Glib::ustring& key, guchar value);

  /** Set byte array hint
   * 
   * @param key The hint.
   * @param values The hint's value.
   *
   * Sets a hint with a byte array value.
   */
  void set_hint(const Glib::ustring& key, const Glib::ArrayHandle<guchar>& values);
  

  /** For instance,
   * void on_invoke(const Glib::ustring& action);
   */
  typedef sigc::slot<void, const Glib::ustring& /* action */> SlotInvokeAction;

  /** Add an action to the notification
   *
   * @param action The action id
   * @param label The action label
   * @param slot A function or method to call when the action is invoked
   *
   * Adds an action to a notification. When the action is invoked, the
   * specified callback function will be called.
   */
  void add_action(const Glib::ustring& action, const Glib::ustring& label, const SlotInvokeAction& slot);
  

  /** Clears all hints from the notification.
   */
  void clear_hints();

  
  /** Clears all actions from the notification.
   */
  void clear_actions();
  
  /** Tells the notification server to hide the notification on the screen.
   * @return <tt>true</tt> if successful. On error, this will return <tt>false</tt> and set
   *  @a error.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  void close();
#else
  void close(std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /**
   * @par Prototype:
   * <tt>void on_my_%closed()</tt>
   */

  Glib::SignalProxy0< void > signal_closed();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The notification ID.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_id() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The notification ID.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_id() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The summary text.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_summary() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The summary text.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_summary() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The message body text.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_body() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The message body text.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_body() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The icon filename or icon theme-compliant name.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_icon_name() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The icon filename or icon theme-compliant name.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_icon_name() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The widget to attach the notification to.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Gtk::Widget> property_attach_widget() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The widget to attach the notification to.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Gtk::Widget> property_attach_widget() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The status icon to attach the notification to.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Gtk::StatusIcon> > property_status_icon() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The status icon to attach the notification to.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gtk::StatusIcon> > property_status_icon() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_closed();
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Notify


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Notify::Notification
   */
  Glib::RefPtr<Notify::Notification> wrap(NotifyNotification* object, bool take_copy = false);
}


#endif /* _LIBNOTIFYMM_NOTIFICATION_H */

