<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text"/>
<xsl:param name="USERNAME"/>  
<xsl:param name="TOKEN"/>  
<xsl:param name="SECRET"/>  
<xsl:param name="TIME"/>  
<xsl:param name="NONCE"/>
<xsl:param name="SUBDOMAIN"/>

<xsl:variable name="RESPONSE" select="'Response'"/>
<xsl:variable name="PARAMS" select="'Params'"/>
<xsl:variable name="STRING" select="'string'"/>
<xsl:variable name="STRUCT" select="'struct'"/>
<xsl:variable name="ARRAY" select="'array'"/>
<xsl:variable name="IMG" select="'img'"/>

<xsl:include href="errors.xsl"/>

<xsl:template match="/">
 <xsl:apply-templates select="/data/response"/>
 <xsl:apply-templates select="/data/error"/>
 <xsl:apply-templates select="/data/info"/>
</xsl:template>

<xsl:template match="response">

    <xsl:element name="{$RESPONSE}">
        <xsl:attribute name="class">photos</xsl:attribute>
        <xsl:attribute name="function">getListPhotoComments</xsl:attribute>
        <xsl:element name="{$PARAMS}">

            <xsl:element name="{$ARRAY}">
                <xsl:variable name="quantity" select="count(content/comment)"/>

                <xsl:attribute name="name">commentsList</xsl:attribute>
                <xsl:attribute name="page">
                        <xsl:value-of select="/data/Request/Params/number[@name='page']"/> 
                </xsl:attribute>

                <xsl:attribute name="pageSize">
                        <xsl:value-of select="/data/Request/Params/number[@name='pageSize']"/> 
                </xsl:attribute>

                <xsl:attribute name="quantity">
                        <xsl:value-of select="number($quantity)"/>
                </xsl:attribute>


                <xsl:attribute name="ownerId">
                    <xsl:value-of select="/data/Request/Params/string[@name='ownerId']"/>
                </xsl:attribute>

                <xsl:attribute name="albumId">
                    <xsl:value-of select="/data/Request/Params/string[@name='albumId']"/>
                </xsl:attribute>

                <xsl:attribute name="photoId">
                    <xsl:value-of select="/data/Request/Params/string[@name='photoId']"/>
                </xsl:attribute>

                <xsl:for-each select="content/comment">
                        <xsl:element name="{$STRUCT}">
                            <xsl:attribute name="name">comment</xsl:attribute>

                            <xsl:element name="{$STRING}">
                               <xsl:attribute name="name">SenderName</xsl:attribute>
                                    <xsl:value-of select="facebook_name"/>
                            </xsl:element>


                            <xsl:element name="{$STRING}">
                                <xsl:attribute name="name">Time</xsl:attribute>
                                <xsl:value-of select="display_date"/>
                            </xsl:element>

                            <xsl:element name="{$STRING}">
                                <xsl:attribute name="name">Text</xsl:attribute>
                                <xsl:value-of select="comment_content"/>
                            </xsl:element>

                        </xsl:element>
                </xsl:for-each>

            </xsl:element> 

        </xsl:element> 
    </xsl:element> 
</xsl:template>

</xsl:stylesheet>
