<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text"/>
<xsl:variable name="ERROR_CODE" select="/data/response[status='Exception']/code"/>  

<xsl:template match="/data">
 <xsl:apply-templates select="/data/error"/>
 <xsl:apply-templates select="/data/info"/>
</xsl:template>

<xsl:template match="/data/response[status='Exception']">
    <xsl:element name="{$RESPONSE}">
        <xsl:attribute name="class">systemMessages</xsl:attribute>
            <xsl:attribute name="function">errorMessage</xsl:attribute>
        <xsl:element name="{$PARAMS}">
            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">moduleName</xsl:attribute>
                <xsl:text>photobucket</xsl:text>
            </xsl:element> 
            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">code</xsl:attribute>
                <xsl:if test="document('errors.xml')//mysocials_errors/error[server_code=$ERROR_CODE]">
                    <xsl:value-of select="document('errors.xml')//mysocials_errors/error[server_code=$ERROR_CODE]/code"/>
                </xsl:if>
            </xsl:element> 
            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">text</xsl:attribute>
                <xsl:value-of select="document('errors.xml')//mysocials_errors/error[server_code=$ERROR_CODE]/message"/>
            </xsl:element> 
            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">comment</xsl:attribute>
                <xsl:value-of select="message"/>
            </xsl:element> 
        </xsl:element>
        </xsl:element>
</xsl:template>

<xsl:template match="/data/info">
    <xsl:element name="{$RESPONSE}">
        <xsl:attribute name="class">systemMessages</xsl:attribute>
            <xsl:attribute name="function">infoMessage</xsl:attribute>
        <xsl:element name="{$PARAMS}">
        </xsl:element>
        </xsl:element>
</xsl:template>

</xsl:stylesheet>
