#include "he-cell-renderer-toggle.h"

struct _HeCellRendererToggle {
	GtkCellRendererToggle __parent_instance__;
};

struct _HeCellRendererToggleClass {
	GtkCellRendererToggleClass __parent_class__;

	gboolean have_pbs;
	GdkPixbuf *pb_CheckButtonChecked;
	GdkPixbuf *pb_CheckButtonCheckedDisabled;
	GdkPixbuf *pb_CheckButtonUnchecked;
	GdkPixbuf *pb_CheckButtonUncheckedDisabled;
};

G_DEFINE_TYPE(HeCellRendererToggle, he_cell_renderer_toggle, GTK_TYPE_CELL_RENDERER_TOGGLE);

static void
notify_pbs(GtkSettings *settings, GParamSpec *pspec, HeCellRendererToggleClass *hcrt_class)
{
	if (hcrt_class->have_pbs) {
		hcrt_class->have_pbs = FALSE;
		g_object_unref(hcrt_class->pb_CheckButtonChecked);
		hcrt_class->pb_CheckButtonChecked           = NULL;
		g_object_unref(hcrt_class->pb_CheckButtonCheckedDisabled);
		hcrt_class->pb_CheckButtonCheckedDisabled   = NULL;
		g_object_unref(hcrt_class->pb_CheckButtonUnchecked);
		hcrt_class->pb_CheckButtonUnchecked         = NULL;
		g_object_unref(hcrt_class->pb_CheckButtonUncheckedDisabled);
		hcrt_class->pb_CheckButtonUncheckedDisabled = NULL;
	}
	
	hcrt_class->pb_CheckButtonChecked           = 
		gdk_pixbuf_new_from_file("/etc/hildon/theme/images/CheckButtonChecked.png", NULL);
	hcrt_class->pb_CheckButtonCheckedDisabled   =
		gdk_pixbuf_new_from_file("/etc/hildon/theme/images/CheckButtonCheckedDisabled.png", NULL);
	hcrt_class->pb_CheckButtonUnchecked         =
		gdk_pixbuf_new_from_file("/etc/hildon/theme/images/CheckButtonUnchecked.png", NULL);
	hcrt_class->pb_CheckButtonUncheckedDisabled =
		gdk_pixbuf_new_from_file("/etc/hildon/theme/images/CheckButtonUncheckedDisabled.png", NULL);

	if (!(hcrt_class->pb_CheckButtonChecked   && hcrt_class->pb_CheckButtonCheckedDisabled &&
	      hcrt_class->pb_CheckButtonUnchecked && hcrt_class->pb_CheckButtonUncheckedDisabled)) {
		if (hcrt_class->pb_CheckButtonChecked)
			g_object_unref(hcrt_class->pb_CheckButtonChecked);
		if (hcrt_class->pb_CheckButtonCheckedDisabled)
			g_object_unref(hcrt_class->pb_CheckButtonCheckedDisabled);
		if (hcrt_class->pb_CheckButtonUnchecked)
			g_object_unref(hcrt_class->pb_CheckButtonUnchecked);
		if (hcrt_class->pb_CheckButtonUncheckedDisabled)
			g_object_unref(hcrt_class->pb_CheckButtonUncheckedDisabled);

		hcrt_class->pb_CheckButtonChecked           = NULL;
		hcrt_class->pb_CheckButtonCheckedDisabled   = NULL;
		hcrt_class->pb_CheckButtonUnchecked         = NULL;
		hcrt_class->pb_CheckButtonUncheckedDisabled = NULL;
	}
	else
		hcrt_class->have_pbs = TRUE;
}

static void
he_cell_renderer_toggle_get_size(GtkCellRenderer *cell, GtkWidget *widget, GdkRectangle *cell_area, gint *x_offset, gint *y_offset, gint *width, gint *height)
{
	HeCellRendererToggleClass *hcrt_class = HE_CELL_RENDERER_TOGGLE_GET_CLASS(cell);

	if (!(hcrt_class->have_pbs))
		GTK_CELL_RENDERER_CLASS(he_cell_renderer_toggle_parent_class)->get_size(cell, widget, cell_area, x_offset, y_offset, width, height);
	else {
		/* Copied verbatim from gtk+2.0-2.14.7 */
		gint calc_width;
		gint calc_height;

		calc_width = (gint) cell->xpad * 2 + gdk_pixbuf_get_width(hcrt_class->pb_CheckButtonChecked);
		calc_height = (gint) cell->ypad * 2 + gdk_pixbuf_get_height(hcrt_class->pb_CheckButtonChecked);

		if (width)
			*width = calc_width;

		if (height)
			*height = calc_height;

		if (cell_area) {
			if (x_offset) {
				*x_offset = ((gtk_widget_get_direction (widget) == GTK_TEXT_DIR_RTL) ?
			 		(1.0 - cell->xalign) : cell->xalign) * (cell_area->width - calc_width);
				*x_offset = MAX (*x_offset, 0);
			}
			if (y_offset) {
				*y_offset = cell->yalign * (cell_area->height - calc_height);
				*y_offset = MAX (*y_offset, 0);
			}
		}
		else {
			if (x_offset) *x_offset = 0;
			if (y_offset) *y_offset = 0;
		}
	}
}

static void
he_cell_renderer_toggle_render(GtkCellRenderer *cell, GdkDrawable *wnd, GtkWidget *widget, GdkRectangle *bkgnd, GdkRectangle *cell_area, GdkRectangle *expose_area, GtkCellRendererState flags)
{
	gboolean inconsistent = FALSE, active = FALSE;
	GtkCellRendererToggle *celltoggle = GTK_CELL_RENDERER_TOGGLE(cell);
	HeCellRendererToggleClass *hcrt_class = HE_CELL_RENDERER_TOGGLE_GET_CLASS(cell);

	g_object_get(G_OBJECT(cell), "inconsistent", &inconsistent, "active", &active, NULL);

	if (!(hcrt_class->have_pbs) || celltoggle->radio || inconsistent)
		GTK_CELL_RENDERER_CLASS(he_cell_renderer_toggle_parent_class)->render(cell, wnd, widget, bkgnd, cell_area, expose_area, flags);
	else {
		GdkGC *gc = NULL;
		gint width, height;
		gint x_offset, y_offset;
		GtkStateType state = 0;

		gtk_cell_renderer_get_size (cell, widget, cell_area,
		                            &x_offset, &y_offset,
		                            &width, &height);
		width -= cell->xpad*2;
		height -= cell->ypad*2;

		if (width <= 0 || height <= 0)
			return;

		if (GTK_WIDGET_STATE (widget) == GTK_STATE_INSENSITIVE || !cell->sensitive)
			state = GTK_STATE_INSENSITIVE;
		else
		if ((flags & GTK_CELL_RENDERER_SELECTED) == GTK_CELL_RENDERER_SELECTED) {
			if (GTK_WIDGET_HAS_FOCUS (widget))
				state = GTK_STATE_SELECTED;
			else
				state = GTK_STATE_ACTIVE;
		}
		else {
			if (celltoggle->activatable)
				state = GTK_STATE_NORMAL;
			else
				state = GTK_STATE_INSENSITIVE;
		}

		GdkPixbuf *pb = active
			? GTK_STATE_INSENSITIVE == state ? hcrt_class->pb_CheckButtonCheckedDisabled   : hcrt_class->pb_CheckButtonChecked
			: GTK_STATE_INSENSITIVE == state ? hcrt_class->pb_CheckButtonUncheckedDisabled : hcrt_class->pb_CheckButtonUnchecked;

		gc = gdk_gc_new(wnd);
		gdk_draw_pixbuf(wnd, gc, pb, 0, 0, cell_area->x + x_offset + cell->xpad, cell_area->y + y_offset + cell->ypad,
			gdk_pixbuf_get_width(pb), gdk_pixbuf_get_height(pb), GDK_RGB_DITHER_NONE, 0, 0);
		g_object_unref(gc);
	}
}

static void
he_cell_renderer_toggle_class_init(HeCellRendererToggleClass *hcrt_class)
{
	GtkCellRendererClass *cr_class = GTK_CELL_RENDERER_CLASS(hcrt_class);
	GtkSettings *settings = gtk_settings_get_default();

	cr_class->get_size = he_cell_renderer_toggle_get_size;
	cr_class->render = he_cell_renderer_toggle_render;

	hcrt_class->have_pbs = FALSE;
	hcrt_class->pb_CheckButtonChecked           = NULL;
	hcrt_class->pb_CheckButtonCheckedDisabled   = NULL;
	hcrt_class->pb_CheckButtonUnchecked         = NULL;
	hcrt_class->pb_CheckButtonUncheckedDisabled = NULL;

	notify_pbs(settings, g_object_class_find_property(G_OBJECT_GET_CLASS(settings), "gtk-theme-name"), hcrt_class);
	g_signal_connect(G_OBJECT(settings), "notify::gtk-theme-name", (GCallback)notify_pbs, hcrt_class);
}

static void
he_cell_renderer_toggle_init(HeCellRendererToggle *hcrt)
{
}
