<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
		 xmlns:df="http://api.facebook.com/1.0/" exclude-result-prefixes="df">
<xsl:output method="text"/>

<xsl:template match="/data/df:error_response">
    <xsl:variable name="ERROR_CODE" select="/data/df:error_response/df:error_code"/>  
    <xsl:element name="{$RESPONSE}">
        <xsl:attribute name="class">systemMessages</xsl:attribute>
        <xsl:attribute name="function">errorMessage</xsl:attribute>
        <xsl:element name="{$PARAMS}">
            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">moduleName</xsl:attribute>
                <xsl:text>facebook</xsl:text>
            </xsl:element>
            <xsl:choose>
                <xsl:when test="document('errors.xml')//mysocials_errors/error[server_code=$ERROR_CODE]">
                    <xsl:element name="{$STRING}">
                        <xsl:attribute name="name">code</xsl:attribute>
                        <xsl:value-of select="document('errors.xml')//mysocials_errors/error[server_code=$ERROR_CODE]/code"/>
                    </xsl:element> 
                    <xsl:element name="{$STRING}">
                        <xsl:attribute name="name">text</xsl:attribute>
                        <xsl:value-of select="document('errors.xml')//mysocials_errors/error[server_code=$ERROR_CODE]/message"/>
                    </xsl:element> 
                </xsl:when>
                <xsl:otherwise>
                    <xsl:element name="{$STRING}">
                        <xsl:attribute name="name">code</xsl:attribute>
                        <xsl:value-of select="document('errors.xml')//mysocials_errors/error[server_code='600']/code"/>
                    </xsl:element> 
                    <xsl:element name="{$STRING}">
                        <xsl:attribute name="name">text</xsl:attribute>
                        <xsl:value-of select="document('errors.xml')//mysocials_errors/error[server_code='600']/message"/>
                    </xsl:element> 
                </xsl:otherwise>
            </xsl:choose>
            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">comment</xsl:attribute>
                <xsl:value-of select="/data/df:error_response/df:error_msg"/>
            </xsl:element>
            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">log</xsl:attribute>
                <xsl:copy-of select="/data/df:error_response/df:request_args"/>
            </xsl:element>
        </xsl:element>
    </xsl:element>
</xsl:template>

<xsl:template match="/data/info_response">
    <xsl:element name="{$RESPONSE}">
        <xsl:attribute name="class">systemMessages</xsl:attribute>
            <xsl:attribute name="function">infoMessage</xsl:attribute>
        <xsl:element name="{$PARAMS}">
        </xsl:element>
    </xsl:element>
</xsl:template>

</xsl:stylesheet>
