<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    <xsl:output method="text"/>
    <xsl:param name="MID"/>
    <xsl:param name="SID"/>
    <xsl:param name="SECRET"/>
    
    <xsl:param name="LIMIT">100000</xsl:param>
    <xsl:variable name="NO_URL" select="'no_url'"/>
    <xsl:variable name="URL" select="'url'"/>
    <xsl:variable name="SIG" select="'sig'"/>
    <xsl:variable name="STRING" select="'string'"/>
    <xsl:variable name="PARSER" select="'parser'"/>
    <xsl:variable name="POST_PARAM" select="'post_param'"/>
    <xsl:variable name="RESPONSE" select="'Response'"/>
    <xsl:variable name="INNER_REQUEST" select="'InnerRequest'"/>
    <xsl:variable name="FUNCTION" select="/Request/@function"/>
    
    <xsl:variable name="PARAMS" select="/Request/Params"/>
    
    <xsl:variable name="PARAMS_ALL" select="document('requests.xml')//requests/request[@function=$FUNCTION]"/>
    
    
    <xsl:include href="url_encode.xsl"/>
    <xsl:template name="space-replace">
        <xsl:param name="text" />
        <xsl:choose>
            <xsl:when test="contains($text,' ')">
                <xsl:value-of select="substring-before($text,' ')" />
                <xsl:value-of select="'%20'" />
                <xsl:call-template name="space-replace">
                    <xsl:with-param name="text"
          select="substring-after($text,' ')" />
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$text" />
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="arg-replace">
        <xsl:param name="text" />
        <xsl:param name="replace" />
        <xsl:variable name="rs" select="concat('%',$replace)"/>
        <xsl:choose>
            <xsl:when test="contains($text, $rs)">
                <xsl:call-template name="url-encode">
                    <xsl:with-param name="str" select="substring-before($text,$rs)" />
                </xsl:call-template>
                <xsl:choose>
                    <xsl:when test="$PARAMS_ALL/param[$replace]/@select != '.'">
                        <xsl:apply-templates select="$PARAMS">
                            <xsl:with-param name="node">
                                <xsl:value-of select="$PARAMS_ALL/param[$replace]/@select"/>
                            </xsl:with-param>
                        </xsl:apply-templates>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="url-encode">
                            <xsl:with-param name="str" select="$PARAMS_ALL/param[$replace]/."/>
                        </xsl:call-template>
                    </xsl:otherwise>
                </xsl:choose>
                <xsl:call-template name="arg-replace">
                    <xsl:with-param name="text" select="substring-after($text,$rs)" />
                    <xsl:with-param name="replace" select="$replace + 1" />
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="url-encode">
                    <xsl:with-param name="str" select="$text" />
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    
    
    <xsl:template match="//Request">
        <xsl:choose>
            <xsl:when test="$FUNCTION = 'setSettings'">
                <xsl:element name="{$INNER_REQUEST}">
                    <xsl:attribute name="type">
                        <xsl:value-of select="'settings'"/>
                    </xsl:attribute>
                    <xsl:copy-of select="$PARAMS"/>
                    
                    <xsl:element name="parser">
                        <xsl:attribute name="type">settings</xsl:attribute>
                        <xsl:text>set_settings.xsl</xsl:text>
                    </xsl:element>
                    
                </xsl:element>
            </xsl:when>
            
            <xsl:when test="$FUNCTION = 'getSettings'">
                <xsl:element name="{$RESPONSE}">
                    <xsl:attribute name="class">settings</xsl:attribute>
                    <xsl:attribute name="function">getSettings</xsl:attribute>
                    <xsl:element name="{'Params'}">
                        <xsl:element name="{$STRING}">
                            <xsl:attribute name="name">mid</xsl:attribute>
                            <xsl:if test="$MID != '(null)'">
                                <xsl:value-of select="$MID"/>
                            </xsl:if>
                        </xsl:element>
                        
                        <xsl:element name="{$STRING}">
                            <xsl:attribute name="name">sid</xsl:attribute>
                            <xsl:if test="$SID != '(null)'">
                                <xsl:value-of select="$SID"/>
                            </xsl:if>
                        </xsl:element>
                        
                        <xsl:element name="{$STRING}">
                            <xsl:attribute name="name">secret</xsl:attribute>
                            <xsl:if test="$SECRET != '(null)'">
                                <xsl:value-of select="$SECRET"/>
                            </xsl:if>
                        </xsl:element>
                    </xsl:element>
                </xsl:element>
            </xsl:when>
            <xsl:when test="$FUNCTION = 'getPhoto'">
                <xsl:element name="{$INNER_REQUEST}">
                    <xsl:attribute name="type">
                        <xsl:value-of select="'get'"/>
                    </xsl:attribute>
                    <xsl:element name="url">
                        <xsl:value-of select="$PARAMS/string[@name='url']"/>
                    </xsl:element>
                    <xsl:copy-of select="$PARAMS"/>
                    
                    <xsl:element name="parser">
                        <xsl:attribute name="type">download</xsl:attribute>
                        <xsl:text>get_photo.xsl</xsl:text>
                    </xsl:element>
                </xsl:element>
            </xsl:when>
            
            <xsl:when test="$FUNCTION = document('requests.xml')//requests/request/@function">
                <xsl:element name="{$INNER_REQUEST}">
                    <xsl:attribute name="type">
                        <xsl:value-of select="$PARAMS_ALL/type"/>
                    </xsl:attribute>
                    
                    <!--  For GET -->
                    <xsl:if test="$PARAMS_ALL/type = 'get'">
                        
                        <xsl:element name="{$URL}">
                            <xsl:value-of select="$PARAMS_ALL/url"  disable-output-escaping="yes" />
                            <xsl:call-template name="arg-replace">
                                <xsl:with-param name="text" select="$PARAMS_ALL/req" />
                                <xsl:with-param name="replace" select="1" />
                            </xsl:call-template>
                            <xsl:text disable-output-escaping="yes">&amp;access_token=</xsl:text>
                            <xsl:value-of select="$SID"  disable-output-escaping="yes" />
                        </xsl:element>
                        
                    </xsl:if>
                    <!--  For POST -->                   
                    <xsl:if test="$PARAMS_ALL/type = 'post'">
                        <xsl:copy > <!-- select="$PARAMS_ALL/url" -->
                            <xsl:attribute name="class">
                                <xsl:value-of select="$PARAMS_ALL/url/Request/@class"/>
                            </xsl:attribute>
                            <xsl:attribute name="function">
                                <xsl:value-of select="$PARAMS_ALL/url/Request/@function"/>
                            </xsl:attribute>
                            <xsl:copy-of select="$PARAMS"/>
                        </xsl:copy>
                        <xsl:for-each select="$PARAMS_ALL/param"> 
                            <xsl:element name="{$POST_PARAM}">
                                <xsl:attribute name="name">
                                    <xsl:value-of select="@name"/>
                                </xsl:attribute>
                                <xsl:choose>
                                    <xsl:when test="@select != '.'">
                                        <xsl:apply-templates select="$PARAMS">
                                            <xsl:with-param name="node">
                                                <xsl:value-of select="@select"/>
                                            </xsl:with-param>
                                        </xsl:apply-templates>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:value-of select="."/>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:element>
                        </xsl:for-each>
                        
                        
                    </xsl:if>
                    <!--  end For POST -->
                    <xsl:copy-of select="$PARAMS_ALL/parser"/>
                </xsl:element>
                
            </xsl:when>
            <!--  Not found function -->
            <xsl:otherwise>
                <xsl:element name="{$RESPONSE}">
                    <xsl:attribute name="class">systemMessages</xsl:attribute>
                    <xsl:attribute name="function">errorMessage</xsl:attribute>
                    <xsl:element name="{'Params'}">
                        <xsl:element name="{$STRING}">
                            <xsl:attribute name="name">moduleName</xsl:attribute>
                            <xsl:text>facebook</xsl:text>
                        </xsl:element>
                        <xsl:element name="{$STRING}">
                            <xsl:attribute name="name">code</xsl:attribute>
                            <xsl:text>402</xsl:text>
                        </xsl:element>
                        <xsl:element name="{$STRING}">
                            <xsl:attribute name="name">text</xsl:attribute>
                            <xsl:text>Unable to perform request</xsl:text>
                        </xsl:element>
                    </xsl:element>
                </xsl:element>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="Params">
        <xsl:param name="node"/>
        
        <xsl:if test="$node = 'id'">
            <xsl:choose>
                <xsl:when test="string-length(@id) != 0">
                    <xsl:value-of select="substring-after(@id, 'fb') "/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="$MID"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:if>
        
        <xsl:if test="$node != 'id'">
            <xsl:choose>
                <xsl:when test="($node = 'albumId') or ($node = 'messageId') or ($node = 'photoId') or ($node='ownerId')">
                    <xsl:value-of select="substring-after(//*[@name=$node], 'fb') "/>
                </xsl:when>
                <xsl:when test="$node = 'timeOffset'">
                    <xsl:if test="number(//*[@name=$node])>0">
                        <xsl:text disable-output-escaping="yes">AND%20</xsl:text>
                        <xsl:value-of select="number(//*[@name=$node])"/>
                        <xsl:text disable-output-escaping="yes">>created_time</xsl:text>
                    </xsl:if>
                </xsl:when>
                <xsl:when test="$node = 'from'">
		        <xsl:if test="//number[@name='from']">
		            <xsl:if test="not(//number[@name='to'])">
		                <xsl:text>LIMIT%20</xsl:text>
		                <xsl:value-of select="$LIMIT"/>
		            </xsl:if>
		            <xsl:text>OFFSET%20</xsl:text>
		            <xsl:value-of select="number(//number[@name=$node])"/>
		        </xsl:if>
<!--
                    <xsl:choose>
                        <xsl:when test="//number[@name='from']">
                            <xsl:if test="not(//number[@name='to'])">
                                <xsl:text>LIMIT%20</xsl:text>
                                <xsl:value-of select="$LIMIT"/>
                            </xsl:if>
                            <xsl:text>OFFSET%20</xsl:text>
                            <xsl:value-of select="number(//number[@name=$node])"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:if test="//number[@name='to']">
                                <xsl:text>OFFSET%200</xsl:text>
                            </xsl:if>
                        </xsl:otherwise>
                    </xsl:choose>
-->

                </xsl:when>
                <xsl:when test="$node = 'to'">
                    <xsl:if test="//number[@name='to']">
                        <xsl:text>LIMIT%20</xsl:text>
                        <xsl:choose>
                            <xsl:when test="//number[@name='from']">
                                <xsl:value-of select="number(//number[@name=$node]) - number(//number[@name='from'])"/>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:value-of select="number(//number[@name=$node])"/>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:if>
                </xsl:when>
                <xsl:when test="$node = 'start'">
                     <xsl:choose>
		            <xsl:when test="//number[@name='from']">
		                <xsl:value-of select="number(//number[@name='from'])"/>
		            </xsl:when>
		            <xsl:otherwise>
		                <xsl:value-of select="'0'"/>
		            </xsl:otherwise>
                     </xsl:choose>
                </xsl:when>
                <xsl:when test="not(//*[@name=$node])">
                    <xsl:value-of select="$PARAMS_ALL/param[@select=$node]"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="//*[@name=$node]"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:if>
        
    </xsl:template>
</xsl:stylesheet>
