<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
	 xmlns:df="http://api.facebook.com/1.0/" exclude-result-prefixes="df">
<xsl:output method="text"/>
<xsl:param name="SID"/>  

<xsl:variable name="URL" select="'url'"/>
<xsl:variable name="SIG" select="'sig'"/>
<xsl:variable name="INNER_REQUEST" select="'InnerRequest'"/>
<xsl:variable name="REQUEST" select="'Request'"/>
<xsl:variable name="RESPONSE" select="'Response'"/>
<xsl:variable name="PARAMS" select="'Params'"/>
<xsl:variable name="STRING" select="'string'"/>
<xsl:variable name="IMG" select="'img'"/>
<xsl:variable name="FUNCTION" select="/Request/@function"/>  
<xsl:include href="errors.xsl"/>


<xsl:template match="/df:fql_query_response/df:user">
    <xsl:element name="{$RESPONSE}">
        <xsl:attribute name="class">profile</xsl:attribute>
        <xsl:attribute name="function">getProfile</xsl:attribute>
        <xsl:element name="{$PARAMS}">

            <xsl:attribute name="id">
                <xsl:text>fb</xsl:text>
                <xsl:value-of select="df:uid"/>
            </xsl:attribute>

            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">FirstName</xsl:attribute>
                <xsl:value-of select="df:first_name"/>
            </xsl:element> 

            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">LastName</xsl:attribute>
                <xsl:value-of select="df:last_name"/>
            </xsl:element>

            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">Gender</xsl:attribute>
                <xsl:value-of select="df:sex" />
            </xsl:element>

            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">Birthday</xsl:attribute>
                <xsl:value-of select="df:birthday_date"/>
            </xsl:element>

            <xsl:element name="{$IMG}">
                <xsl:attribute name="name">Img</xsl:attribute>
                <xsl:value-of select="df:pic_big"/>
            </xsl:element>

            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">CityName</xsl:attribute>
                <xsl:value-of select="df:current_location/df:city"/>
            </xsl:element>

            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">CountryName</xsl:attribute>
                <xsl:value-of select="df:current_location/df:country"/>
            </xsl:element>
        </xsl:element>
    </xsl:element>
</xsl:template>
</xsl:stylesheet>
