<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
		 xmlns:df="http://api.facebook.com/1.0/" exclude-result-prefixes="df">
<xsl:output method="text"/>

<xsl:template match="/df:error_response">
    <xsl:element name="{$RESPONSE}">
        <xsl:attribute name="class">systemMessages</xsl:attribute>
            <xsl:attribute name="function">errorMessage</xsl:attribute>
        <xsl:element name="{$PARAMS}">
            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">moduleName</xsl:attribute>
                <xsl:text>facebook</xsl:text>
            </xsl:element>
            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">code</xsl:attribute>
                <xsl:value-of select="/df:error_response/df:error_code"/>
            </xsl:element>
            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">text</xsl:attribute>
                <xsl:value-of select="/df:error_response/df:error_msg"/>
            </xsl:element>
            <xsl:copy-of select="/df:error_response/df:request_args"/>
        </xsl:element>
    </xsl:element>
</xsl:template>

<xsl:template match="/info_response">
    <xsl:element name="{$RESPONSE}">
        <xsl:attribute name="class">systemMessages</xsl:attribute>
            <xsl:attribute name="function">infoMessage</xsl:attribute>
        <xsl:element name="{$PARAMS}">
            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">moduleName</xsl:attribute>
                <xsl:text>facebook</xsl:text>
            </xsl:element> 
            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">code</xsl:attribute>
                <xsl:value-of select="/info_response/info_code"/>
            </xsl:element> 
            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">text</xsl:attribute>
                <xsl:value-of select="/info_response/info_msg"/>
            </xsl:element> 
        </xsl:element>
    </xsl:element>
</xsl:template>

</xsl:stylesheet>
