import hildon
import gtk

ABOUT_MESSAGE = """Libellule is a local search application.

<b>Maintainer : </b>David Hautbois
<b>Email :</b> david.hautbois@free.fr"""


def create_menu(window, app):
    """Build the menu"""
    
    menu = hildon.AppMenu()
    button = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
    button.set_label("About...")
    button.connect("clicked", display_about_dialog, app)
    menu.append(button)
    menu.show_all()
    return menu
    
    
def display_about_dialog(widget,  app):
    about_window = hildon.StackableWindow()    
    vbox = gtk.VBox(False, 0)
    label = gtk.Label()
    label.set_markup(ABOUT_MESSAGE)
    vbox.pack_start(label, True, True, 0)
    hbox = gtk.HBox(False, 0)
    i = gtk.Image()
    i.set_from_file("/usr/share/libellule/qype.png")
    eb = gtk.EventBox()    
    eb.connect("button-press-event", open_url, app, "http://www.qype.co.uk")
    eb.add(i);
    hbox.pack_start(eb);
    vbox.pack_start(hbox);
    about_window.add(vbox)  
    about_window.set_title("About Libellule")
    about_window.show_all()
    

def open_url(widget, data, app, url):
        print url
        app.osso_r.rpc_run('com.nokia.osso_browser', 
                            '/com/nokia/osso_browser/request', 
                            'com.nokia.osso_browser', 
                            'load_url', (url, ),
                            False, True) 
