#ifndef COLUMBUSCONTROLLER_H
#define COLUMBUSCONTROLLER_H

#include "config.h"

#include <rx/ConfigManager.h>

#include "ColumbusModel.h"
#include "ColumbusWaypointModel.h"

#include "ColumbusPluginManager.h"

#include "logging/LoggingManager.h"

#include <QList>
#include <QObject>

#include <QGeoPositionInfo>
#include <QGeoSatelliteInfo>

#include <QSqlDatabase>

QTM_USE_NAMESPACE

class ColumbusControllerPrivate;

class ColumbusController : public QObject
{
    Q_OBJECT

public:
    explicit ColumbusController  (QObject *parent = 0);
            ~ColumbusController  ();

    bool                    initialize  ();

    ConfigManager*          config      () const;
    PluginManager*          plugins     () const;
    LoggingManager*         logger      () const;

    QSqlDatabase            database    () const;
    ColumbusModel*          model       () const;
    ColumbusWaypointModel*  waypoints   () const;

signals:
    void positionUpdated            (const QGeoPositionInfo &position);

    void satellitesInViewUpdated    (const QList<QGeoSatelliteInfo> &satellites);
    void satellitesInUseUpdated     (const QList<QGeoSatelliteInfo> &satellites);

protected slots:
    void onConfigUpdated            (const QString &key, QVariant value);
    void onPositionUpdated          (const QGeoPositionInfo &position);
    void onPositionTimeout          ();

protected:
    void setupConfig();

private:
    ColumbusControllerPrivate *d;
};

#endif // COLUMBUSCONTROLLER_H
