#ifndef LOGGINGSERVICEPERFORMERFACTORY_H
#define LOGGINGSERVICEPERFORMERFACTORY_H

#include "LoggingManager.h"
#include "LoggingServicePerformer.h"

#include <QObject>

class LoggingServicePerformerFactoryPrivate;

class LoggingServicePerformerFactory : public QObject
{
    Q_OBJECT

public:
    explicit LoggingServicePerformerFactory(AbstractGeoLoggingFormatter *formatter, LoggingManager *manager, QObject *parent = 0);

    LoggingServicePerformer* createInstance(QIODevice *io, QObject *parent);
    void              destroyInstance(LoggingServicePerformer *performer);

private:
    LoggingServicePerformerFactoryPrivate *d;
};

#endif // LOGGINGSERVICEPERFORMERFACTORY_H
