#include "ColumbusWaypoint.h"

class ColumbusWaypointPrivate
{
public:
    QString         name;
    QGeoCoordinate  coordinate;
};

ColumbusWaypoint::ColumbusWaypoint()
{
}

ColumbusWaypoint::ColumbusWaypoint(const QString &name, const QGeoCoordinate &coordinate)
{
    this->d = new ColumbusWaypointPrivate;
    d->name         = name;
    d->coordinate   = coordinate;
}

ColumbusWaypoint::ColumbusWaypoint(const ColumbusWaypoint &other)
{
    this->d = new ColumbusWaypointPrivate;
    d->name         = other.name();
    d->coordinate   = other.coordinate();
}

ColumbusWaypoint::~ColumbusWaypoint()
{
    delete this->d;
}

QString ColumbusWaypoint::name() const
{
    return d->name;
}

QGeoCoordinate ColumbusWaypoint::coordinate() const
{
    return d->coordinate;
}
