#ifndef ABSTRACTGEOLOGGINGFORMATTER_H
#define ABSTRACTGEOLOGGINGFORMATTER_H

#include "AbstractLoggingFormatter.h"

#include <QList>

#include <QGeoPositionInfo>
#include <QGeoSatelliteInfo>

class AbstractGeoLoggingFormatter : public AbstractLoggingFormatter
{
    Q_OBJECT

public:
    explicit AbstractGeoLoggingFormatter(QObject *parent = 0) : AbstractLoggingFormatter(parent) {}

public slots:
    virtual void onPositionUpdate(const QtMobility::QGeoPositionInfo &position) = 0;

    virtual void onSatellitesInUse(const QList<QtMobility::QGeoSatelliteInfo> &satellites) = 0;
    virtual void onSatellitesInView(const QList<QtMobility::QGeoSatelliteInfo> &satellites) = 0;
};

#endif // ABSTRACTGEOLOGGINGFORMATTER_H
