#include "luxwidget.h"

#include <QApplication>
#include <QMaemo5Style>

#include <X11/extensions/Xrender.h>

int main(int argc, char **argv)
{
    bool  argbVisual=false;
    Display *dpy = XOpenDisplay(0); // open default display
    if (!dpy) {
        qWarning("Cannot connect to the X server");
        exit(1);
    }

    int screen = DefaultScreen(dpy);
    Colormap colormap = 0;
    Visual *visual = 0;
    int eventBase, errorBase;

    if (XRenderQueryExtension(dpy, &eventBase, &errorBase)) {
        int nvi;
        XVisualInfo templ;
        templ.screen  = screen;
        templ.depth   = 32;
        templ.c_class = TrueColor;
        XVisualInfo *xvi = XGetVisualInfo(dpy, VisualScreenMask |
                                          VisualDepthMask |
                                          VisualClassMask, &templ, &nvi);
    
        for (int i = 0; i < nvi; ++i) {
            XRenderPictFormat *format = XRenderFindVisualFormat(dpy,
                                                                xvi[i].visual);
            if (format->type == PictTypeDirect && format->direct.alphaMask) {
                visual = xvi[i].visual;
                colormap = XCreateColormap(dpy, RootWindow(dpy, screen),
                                           visual, AllocNone);
                argbVisual=true;
                break;
            }
        }
    }

    QApplication app(dpy, argc, argv,
                     Qt::HANDLE(visual), Qt::HANDLE(colormap));

    QApplication::setStyle( new QMaemo5Style() );
    LuxWidget w;
    w.resize(180, 100);
    w.show();

    return app.exec();
}
