/*
 * Copyright (C) 2010 Corentin Chary <corentin.chary@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "builtin.h"
#include "station.h"

static struct {
        int number;
        int arrondissementNumber;
        const char *name;
        const char *address;
        const char *fullAddress;
        double x;
        double y;
} stations[] = {
        { 20020, 10, "20020 - Pyrenees Renouvier", "183 Rue Des Pyrenees -", "183 Rue Des Pyrenees - 75020 Paris", 48.8610788965, 2.40036206404 },
        { 20017, 10, "20017 - Rue Saint Blaise", "69 Rue Saint Blaise -", "69 Rue Saint Blaise - 75020 Paris", 48.8568139503, 2.40903291746 },
        { 20016, 10, "20016 - Pyrenees Vitruve", "114 Bis Rue Des Pyrenees -", "114 Bis Rue Des Pyrenees - 75020 Paris", 48.8567446285, 2.40461989489 },
        { 12027, 10, "12027 - Montgallet Charenton", "2 Rue Montgallet -", "2 Rue Montgallet - 75012 Paris", 48.8426790666, 2.38657345077 },
        { 12026, 10, "12026 - Parc De Bercy", "61 Rue De Bercy -", "61 Rue De Bercy - 75012 Paris", 48.8376028148, 2.38223901841 },
        { 20013, 10, "20013 - Place De La Reunion", "106 Rue Alexandre Dumas -", "106 Rue Alexandre Dumas - 75020 Paris", 48.8553185618, 2.39921099443 },
        { 20012, 10, "20012 - Buzenval Vignoles", "90 Rue Buzenval -", "90 Rue Buzenval - 75020 Paris", 48.8539339524, 2.40024441521 },
        { 20011, 10, "20011 - Pyrnes-Dagorno", "103 Rue Des Pyrennees -", "103 Rue Des Pyrennees - 75020 Paris", 48.8556029462, 2.40510872636 },
        { 20008, 10, "20008 - Maraichers", "73 Rue Des Pyrenees -", "73 Rue Des Pyrenees - 75020 Paris", 48.8531669036, 2.40588183407 },
        { 20007, 10, "20007 - Buzenval", "52 Rue Buzenval -", "52 Rue Buzenval - 75020 Paris", 48.8515696551, 2.40135828426 },
        { 20005, 10, "20005 - Rue De Lagny Saint Mande", "2 Rue Reynaldo Hahn -", "2 Rue Reynaldo Hahn - 75020 Paris", 48.8492625678, 2.41214103111 },
        { 20004, 10, "20004 - Porte De Vincennes Bis", "2 Rue Du Commandant L'Herminier -", "2 Rue Du Commandant L'Herminier - 75020 Paris", 48.847076104, 2.41601889248 },
        { 20002, 10, "20002 - Pixerecourt", "Face 65 Rue Pixerecourt -", "Face 65 Rue Pixerecourt - 75020 Paris", 48.8736544713, 2.39593575659 },
        { 20001, 10, "20001 - Place De La Nation", "1 Cours De Vincennes -", "1 Cours De Vincennes - 75020 Paris", 48.8485327917, 2.39965228289 },
        { 13055, 10, "13055 - Lagroua", "18 Rue Marie Andree Lagroua -", "18 Rue Marie Andree Lagroua - 75013 Paris", 48.8284990832, 2.38031173188 },
        { 13054, 10, "13054 - Pau Casals", "1 Rue Pau Casals -", "1 Rue Pau Casals - 75013 Paris", 48.8311604569, 2.37734621361 },
        { 10041, 10, "10041 - Chartres (18 Arr.)", "Face 39 Boulevard De La Chapelle -", "Face 39 Boulevard De La Chapelle - 75010 Paris", 48.8840657432, 2.35584234301 },
        { 10039, 10, "10039 - Sambre Et Meuse", "37 Rue Sambre Et Meuse -", "37 Rue Sambre Et Meuse - 75010 Paris", 48.8742743879, 2.37401424156 },
        { 10038, 10, "10038 - Colonel Fabien", "69 Rue De La Grange Aux Belles -", "69 Rue De La Grange Aux Belles - 75010 Paris", 48.8775649496, 2.36984713827 },
        { 10037, 10, "10037 - Version 2 Jaures", "Eglise Saint Joseph Artisan -", "Eglise Saint Joseph Artisan - 75010 Paris", 48.8811064283, 2.36798252895 },
        { 10035, 10, "10035 - Aubervilliers", "1 Boulevard De La Chapelle -", "1 Boulevard De La Chapelle - 75010 Paris", 48.884252836, 2.36438676921 },
        { 10034, 10, "10034 - Chapelle Louis Blanc", "68 Rue Louis Blanc -", "68 Rue Louis Blanc - 75010 Paris", 48.8838493184, 2.36005308899 },
        { 10033, 10, "10033 - Lariboisiere", "15 Rue Saint Vincent De Paul -", "15 Rue Saint Vincent De Paul - 75010 Paris", 48.8808398125, 2.35238006296 },
        { 10031, 10, "10031 - Aqueduc", "48 Rue Louis Blanc -", "48 Rue Louis Blanc - 75010 Paris", 48.8820152212, 2.36345897701 },
        { 10029, 10, "10029 - Place De Roubaix", "39 Rue De Dunkerque -", "39 Rue De Dunkerque - 75010 Paris", 48.880741086, 2.35128991867 },
        { 10028, 10, "10028 - Gare Du Nord Denan", "24 Rue De Dunkerque -", "24 Rue De Dunkerque - 75010 Paris", 48.8804713053, 2.35261160376 },
        { 10027, 10, "10027 - Dunkerque", "4 Rue De Dunkerque -", "4 Rue De Dunkerque - 75010 Paris", 48.879365014, 2.35823884785 },
        { 10026, 10, "10026 - Chateau Landon", "2 Rue De Chateau Landon -", "2 Rue De Chateau Landon - 75010 Paris", 48.8791035616, 2.36247643219 },
        { 10025, 10, "10025 - Ecluses Saint Martin", "148 Quai De Jemmapes -", "148 Quai De Jemmapes - 75010 Paris", 48.8773502275, 2.36607272508 },
        { 10023, 10, "10023 - Verdun", "1 Avenue De Verdun -", "1 Avenue De Verdun - 75010 Paris", 48.876057217, 2.3607990489 },
        { 10022, 10, "10022 - Chabrol Saint Quentin", "Face 124 Rue Du Faubourg Saint Denis -", "Face 124 Rue Du Faubourg Saint Denis - 75010 Paris", 48.8766692209, 2.35589419239 },
        { 10021, 10, "10021 - Marche St Quentin", "4 Rue Des Petits Hotels -", "4 Rue Des Petits Hotels - 75010 Paris", 48.8772625552, 2.35474986127 },
        { 10020, 10, "10020 - Chabrol", "59 Rue Chabrol -", "59 Rue Chabrol - 75010 Paris", 48.8770742865, 2.35123442396 },
        { 10019, 10, "10019 - Paradis", "23 Rue Paradis -", "23 Rue Paradis - 75010 Paris", 48.8749621178, 2.35250097236 },
        { 10018, 10, "10018 - Alban Satragne", "110-112 Rue Faubourg Saint Denis -", "110-112 Rue Faubourg Saint Denis - 75010 Paris", 48.8756266675, 2.35607094383 },
        { 10017, 10, "10017 - Gare De L'Est Saint Laurent", "1 Rue De La Fidelite -", "1 Rue De La Fidelite - 75010 Paris", 48.8746918342, 2.35702434429 },
        { 10016, 10, "10016 - Villemin", "29 Rue Des Recollets -", "29 Rue Des Recollets - 75010 Paris", 48.875113805, 2.35947699886 },
        { 10015, 10, "10015 - Recollets", "46 Rue Lucie Sampaix -", "46 Rue Lucie Sampaix - 75010 Paris", 48.8741066306, 2.36247400118 },
        { 10014, 10, "10014 - Beaurepaire", "14 Rue De Marseille -", "14 Rue De Marseille - 75010 Paris", 48.8716078002, 2.36410767091 },
        { 10013, 10, "10013 - Saint Louis", "2 Rue Alibert -", "2 Rue Alibert - 75010 Paris", 48.8709961872, 2.36613731271 },
        { 10012, 10, "10012 - Vinaigriers", "58 Rue Des Vinaigriers -", "58 Rue Des Vinaigriers - 75010 Paris", 48.8732984601, 2.35898573917 },
        { 10011, 10, "10011 - Bourse Du Travail", "3 Rue Du Chateau D'Eau -", "3 Rue Du Chateau D'Eau - 75010 Paris", 48.8692715172, 2.36215831045 },
        { 10010, 10, "10010 - Jacques Bonsergent", "Face 8 Place Jacques Bonsergent -", "Face 8 Place Jacques Bonsergent - 75010 Paris", 48.8708804455, 2.3612054136 },
        { 10009, 10, "10009 - Hittorff", "Face 14 Rue Hittorff -", "Face 14 Rue Hittorff - 75010 Paris", 48.872049478, 2.35754105475 },
        { 10007, 10, "10007 - Chateau D'Eau", "57 Rue Du Chateau D'Eau -", "57 Rue Du Chateau D'Eau - 75010 Paris", 48.8723463774, 2.35557928074 },
        { 10006, 10, "10006 - Petites Ecuries", "5 Rue Des Petites Ecuries -", "5 Rue Des Petites Ecuries - 75010 Paris", 48.873065599, 2.35397185265 },
        { 10005, 1, "10005 - Conservatoire", "59 Rue Des Petites Ecuries -", "59 Rue Des Petites Ecuries - 75010 Paris", 48.8739919624, 2.34819529145 },
        { 10004, 10, "10004 - Metz", "7 Rue De Metz -", "7 Rue De Metz - 75010 Paris", 48.8710435329, 2.35338537316 },
        { 10003, 1, "10003 - Hauteville", "1 Rue D'Hauteville -", "1 Rue D'Hauteville - 75010 Paris", 48.8704957668, 2.34951605747 },
        { 10002, 10, "10002 - Strasbourg", "3 Bd Strasbourg -", "3 Bd Strasbourg - 75010 Paris", 48.8694257052, 2.35416140759 },
        { 10001, 3, "10001 - Johann Strauss", "Face 50 Rue Rene Boulanger -", "Face 50 Rue Rene Boulanger - 75010 Paris", 48.8684630946, 2.35996458418 },
        { 13011, 10, "13011 - Compo Formio", "112 Bd De L'Hopital -", "112 Bd De L'Hopital - 75013 Paris", 48.8356141738, 2.35850705862 },
        { 11102, 10, "11102 - Rue Des Boulets ( Complementaire )", "3 Rue Alexandre Dumas -", "3 Rue Alexandre Dumas - 75011 Paris", 48.8527350222, 2.38906168683 },
        { 13006, 5, "13006 - Saint Marcel Jeanne D'Arc", "02 Rue Dumeril -", "02 Rue Dumeril - 75013 Paris", 48.8379691632, 2.35709204148 },
        { 13005, 10, "13005 - Arago Cordeliere - Version 2", "2 Rue Des Cordelieres -", "2 Rue Des Cordelieres - 75013 Paris", 48.8354807462, 2.34828247165 },
        { 13004, 10, "13004 - Glaciere", "88 Boulevard Auguste Blanqui (Sur Tpc) -", "88 Boulevard Auguste Blanqui (Sur Tpc) - 75013 Paris", 48.8306905085, 2.34645727126 },
        { 13001, 5, "13001 - Port Royal", "51 Boulevard Port Royal -", "51 Boulevard Port Royal - 75013 Paris", 48.8374402173, 2.34614532205 },
        { 20015, 10, "20015 - Bagnolet-Orteaux", "44 Bis Rue De Bagnolet -", "44 Bis Rue De Bagnolet - 75020 Paris", 48.8570715336, 2.39839587486 },
        { 20014, 10, "20014 - Alexandre Dumas", "142 Bd Charonne -", "142 Bd Charonne - 75020 Paris", 48.8561025572, 2.39505783895 },
        { 16026, 10, "16026 - Ranelagh", "91 Rue Du Ranelagh -", "91 Rue Du Ranelagh - 75016 Paris", 48.8554147358, 2.27032702904 },
        { 11045, 3, "11045 - Saint Sebastien Froissard", "12 Bd Des Filles Du Calvaire -", "12 Bd Des Filles Du Calvaire - 75011 Paris", 48.8613255023, 2.36727611919 },
        { 11044, 10, "11044 - Richard Lenoir Voltaire Nord", "Face 104 Boulevard Richard Lenoir -", "Face 104 Boulevard Richard Lenoir - 75011 Paris", 48.8631487565, 2.37166340135 },
        { 11043, 3, "11043 - Cirque D Hiver", "Place Pasdeloup -", "Place Pasdeloup - 75011 Paris", 48.8627095951, 2.36714070344 },
        { 11042, 10, "11042 - Oberkampf", "1 Rue Du Grand Prieure -", "1 Rue Du Grand Prieure - 75011 Paris", 48.8646323021, 2.3694167209 },
        { 11041, 10, "11041 - Saint Ambroise", "2 Rue Lacharriere -", "2 Rue Lacharriere - 75011 Paris", 48.8606939741, 2.37566639866 },
        { 11040, 3, "11040 - Temple Jean Pierre Timbaud", "18 Bd Du Temple -", "18 Bd Du Temple - 75011 Paris", 48.8644803446, 2.36618817203 },
        { 11039, 10, "11039 - Jules Ferry Republique", "Face 121 Boulevard Richard Lenoir -", "Face 121 Boulevard Richard Lenoir - 75011 Paris", 48.8657377412, 2.36944465156 },
        { 11038, 3, "11038 - Temple Republique", "44 Bd Du Temple -", "44 Bd Du Temple - 75011 Paris", 48.8656938865, 2.36515353995 },
        { 11037, 3, "11037 - Faubourg Du Temple Place De La Republique", "2 Rue Du Faubourg Du Temple -", "2 Rue Du Faubourg Du Temple - 75011 Paris", 48.8676891752, 2.36474592312 },
        { 11036, 10, "11036 - Jules Ferry Faubourg Du Temple", "Face 28 Rue Jules Ferry -", "Face 28 Rue Jules Ferry - 75011 Paris", 48.8684343958, 2.36774342446 },
        { 11035, 10, "11035 - Goncourt", "140 Avenue Parmentier -", "140 Avenue Parmentier - 75011 Paris", 48.8690983234, 2.37189894721 },
        { 11034, 10, "11034 - Parmentier Fontaine Au Roi", "124 Avenue Parmentier -", "124 Avenue Parmentier - 75011 Paris", 48.8678397976, 2.37290621233 },
        { 11033, 10, "11033 - Breguet Sabin", "Face 23 Bd Richard Lenoir -", "Face 23 Bd Richard Lenoir - 75011 Paris", 48.8567050643, 2.37067847683 },
        { 11032, 10, "11032 - Metallos", "81 Bis Rue Jp Timbaud -", "81 Bis Rue Jp Timbaud - 75011 Paris", 48.8679192168, 2.37751086642 },
        { 11031, 10, "11031 - Parmentier", "1 Rue Jacquard -", "1 Rue Jacquard - 75011 Paris", 48.8644245999, 2.37290386426 },
        { 11030, 10, "11030 - Saint Maur Oberkampf", "80 Rue Oberkampf -", "80 Rue Oberkampf - 75011 Paris", 48.8650437098, 2.37616002435 },
        { 1102, 1, "01102 - Francaise", "6 Rue Francaise -", "6 Rue Francaise - 75001 Paris", 48.8639891016, 2.34762105504 },
        { 11028, 10, "11028 - Bluets Republique", "Face 20 Rue Guillaume Bertrand -", "Face 20 Rue Guillaume Bertrand - 75011 Paris", 48.8639007604, 2.38065443341 },
        { 11027, 10, "11027 - Saint Ambroise Parmentier", "17 Rue Saint Ambroise -", "17 Rue Saint Ambroise - 75011 Paris", 48.861987621, 2.37730193897 },
        { 11026, 10, "11026 - Chemin Vert Saint Maur", "105 Rue Du Chemin Vert -", "105 Rue Du Chemin Vert - 75011 Paris", 48.8610514424, 2.38151018894 },
        { 11025, 10, "11025 - Froment Breguet", "9 Rue Froment -", "9 Rue Froment - 75011 Paris", 48.8569111844, 2.37272163721 },
        { 11024, 10, "11024 - Boulevard Voltaire", "82 Rue Sedaine -", "82 Rue Sedaine - 75011 Paris", 48.858733596, 2.379002009 },
        { 11023, 10, "11023 - Leo Frot Roquette", "2 Rue Saint Maur -", "2 Rue Saint Maur - 75011 Paris", 48.8587318564, 2.38370113619 },
        { 11022, 10, "11022 - Leon Blum Roquette", "142 Rue De La Roquette -", "142 Rue De La Roquette - 75011 Paris", 48.8578337764, 2.38197053767 },
        { 11020, 10, "11020 - Charonne", "1 Rue De Belfort -", "1 Rue De Belfort - 75011 Paris", 48.8563954262, 2.38292270096 },
        { 11019, 10, "11019 - Charonne Philippe Auguste", "156 Rue De Charonne -", "156 Rue De Charonne - 75011 Paris", 48.8554036336, 2.39056252935 },
        { 11018, 10, "11018 - Saint Maur Avenue De La Republique", "87 Rue De Saint Maur -", "87 Rue De Saint Maur - 75011 Paris", 48.8643780481, 2.37794402594 },
        { 11016, 10, "11016 - Philippe Auguste", "5 Rue Du Passage Philippe Auguste -", "5 Rue Du Passage Philippe Auguste - 75011 Paris", 48.8516187294, 2.39314621058 },
        { 11012, 10, "11012 - Montreuil Voltaire", "93 Rue De Montreuil -", "93 Rue De Montreuil - 75011 Paris", 48.8505491756, 2.39324038768 },
        { 11010, 10, "11010 - St Antoine Gonnet", "1 Rue Des Boulets -", "1 Rue Des Boulets - 75011 Paris", 48.8491479168, 2.39153660685 },
        { 11009, 10, "11009 - Rue Des Boulets", "45 Rue Des Boulets -", "45 Rue Des Boulets - 75011 Paris", 48.8520161257, 2.38882944747 },
        { 11008, 10, "11008 - Faidherbe Chaligny", "223 Rue Du Faubourg Saint Antoine -", "223 Rue Du Faubourg Saint Antoine - 75011 Paris", 48.8503643624, 2.38415667127 },
        { 11007, 10, "11007 - Faidherbe Palais De La Femme", "17 Rue Jean Mace -", "17 Rue Jean Mace - 75011 Paris", 48.8529890639, 2.38323294223 },
        { 11006, 10, "11006 - Ledru Rollin-Basfroi", "169 Avenue Ledru Rollin -", "169 Avenue Ledru Rollin - 75011 Paris", 48.8562799572, 2.37920433419 },
        { 11004, 10, "11004 - Charonne Saint Antoine", "3 Rue De Charonne -", "3 Rue De Charonne - 75011 Paris", 48.8521923023, 2.37427097007 },
        { 11003, 10, "11003 - Roquette Dallery", "29 Rue Keller -", "29 Rue Keller - 75011 Paris", 48.8555802149, 2.37540383437 },
        { 11001, 10, "11001 - Bastille Richard Lenoir", "2 Boulevard Richard Lenoir -", "2 Boulevard Richard Lenoir - 75011 Paris", 48.8536046454, 2.369777604 },
        { 15048, 10, "15048 - Olivier De Serre", "Place Amedee Giordani -", "Place Amedee Giordani - 75015 Paris", 48.8302235041, 2.29098348803 },
        { 15044, 10, "15044 - J Dupre", "65 Rue Dantzig -", "65 Rue Dantzig - 75015 Paris", 48.8305849728, 2.29634679578 },
        { 15043, 10, "15043 - Brancion", "122 Rue Brancion -", "122 Rue Brancion - 75015 Paris", 48.829049721, 2.301411994 },
        { 15042, 10, "15042 - Farman", "52 Rue Henry Farman -", "52 Rue Henry Farman - 75015 Paris", 48.8340971804, 2.27185208694 },
        { 15041, 10, "15041 - Labrouste", "13 Rue Franquet -", "13 Rue Franquet - 75015 Paris", 48.8328350232, 2.30685492489 },
        { 15040, 10, "15040 - Monclar", "33 Bis Rue Saint Armand -", "33 Bis Rue Saint Armand - 75015 Paris", 48.8339589837, 2.3089236185 },
        { 16027, 10, "16027 - Jasmin", "79 Av Mozart-", "79 Av Mozart- 75016 Paris", 48.8526904917, 2.2684919685 },
        { 15027, 10, "15027 - Gide", "2 Rue Georges Duhamel -", "2 Rue Georges Duhamel - 75015 Paris", 48.8385976857, 2.31405408216 },
        { 16021, 10, "16021 - Rue Francois Ponsard", "1 Rue Francois Ponsard -", "1 Rue Francois Ponsard - 75016 Paris", 48.8582838936, 2.27430052635 },
        { 15020, 10, "15020 - Mairie Du 15Eme", "4 Rue Leon Seche -", "4 Rue Leon Seche - 75015 Paris", 48.8417392574, 2.29842127963 },
        { 15013, 10, "15013 - Lecourbe Volontaire", "Dev 1 Rue Des Volontaires -", "Dev 1 Rue Des Volontaires - 75015 Paris", 48.843467188, 2.30635849547 },
        { 15011, 10, "15011 - Thebaud Rue De Cambronne", "32 Rue Cambronne -", "32 Rue Cambronne - 75015 Paris", 48.8458026924, 2.30186340651 },
        { 1025, 1, "01025 - Temple De L'Oratoire", "2 Rue De L'Oratoire -", "2 Rue De L'Oratoire - 75001 Paris", 48.8612663418, 2.34001981072 },
        { 1024, 1, "01024 - Louvre Coq Heron", "20 Rue Coquilliere -", "20 Rue Coquilliere - 75001 Paris", 48.863737787, 2.34258087392 },
        { 1023, 1, "01023 - Andre Malraux Musee Du Louvre", "165 Rue Saint Honore -", "165 Rue Saint Honore - 75001 Paris", 48.8635131929, 2.33463927367 },
        { 1022, 1, "01022 - Rue De La Paix", "37 Rue Casanova -", "37 Rue Casanova - 75001 Paris", 48.8681684822, 2.33044311211 },
        { 1020, 1, "01020 - Rivoli Concorde", "2 Rue Cambon -", "2 Rue Cambon - 75001 Paris", 48.8661009779, 2.32522592932 },
        { 1019, 1, "01019 - Saint Honore Vendome", "237 Rue Saint Honore -", "237 Rue Saint Honore - 75001 Paris", 48.8665955569, 2.32834541888 },
        { 1018, 1, "01018 - Rivoli Tuilerie", "2 Rue D'Alger -", "2 Rue D'Alger - 75001 Paris", 48.8647532268, 2.32949000369 },
        { 1017, 1, "01017 - Saint Honore", "215 Rue Saint Honore -", "215 Rue Saint Honore - 75001 Paris", 48.8654722832, 2.33059331294 },
        { 1016, 1, "01016 - Opera Pyramides", "27 Rue Therese -", "27 Rue Therese - 75001 Paris", 48.8663621835, 2.33436667676 },
        { 1015, 1, "01015 - Place Andre Malraux", "2 Place Andre Malraux -", "2 Place Andre Malraux - 75001 Paris", 48.8639535926, 2.33566090387 },
        { 1014, 1, "01014 - Rivoli Musee Du Louvre", "5 Rue De L'Echelle -", "5 Rue De L'Echelle - 75001 Paris", 48.8637019143, 2.33408076356 },
        { 1013, 1, "01013 - Saint Honore", "186 Rue Saint Honore -", "186 Rue Saint Honore - 75001 Paris", 48.8624257439, 2.33822181733 },
        { 1012, 1, "01012 - Bourse Du Commerce", "Face 29 Rue Jean Jacques Rousseau -", "Face 29 Rue Jean Jacques Rousseau - 75001 Paris", 48.8628480802, 2.34147742145 },
        { 12040, 10, "12040 - Porte De Charenton", "Face 2 Av. De La Porte De Charenton -", "Face 2 Av. De La Porte De Charenton - 75012 Paris", 48.8314748946, 2.3987196651 },
        { 12039, 10, "12039 - Decaen", "45 Avenue Du General Michel Bizot -", "45 Avenue Du General Michel Bizot - 75012 Paris", 48.8347451274, 2.40110605351 },
        { 12038, 10, "12038 - Bel Air", "Face 12 Boulevard Picpus -", "Face 12 Boulevard Picpus - 75012 Paris", 48.8399311083, 2.40082650582 },
        { 12036, 10, "12036 - Reuilly", "116 Rue De Reuilly -", "116 Rue De Reuilly - 75012 Paris", 48.8401049723, 2.39472685199 },
        { 12035, 10, "12035 - Madagascar", "4 Rue De Madagascar -", "4 Rue De Madagascar - 75012 Paris", 48.8346122901, 2.3973074911 },
        { 12034, 10, "12034 - Pirogues De Bercy", "20 Rue Des Pirogues De Bercy -", "20 Rue Des Pirogues De Bercy - 75012 Paris", 48.8322984963, 2.38638660567 },
        { 12033, 10, "12033 - Saint Emilion", "Face 28 Rue Francois Truffaut -", "Face 28 Rue Francois Truffaut - 75012 Paris", 48.8333412707, 2.38587026116 },
        { 12032, 10, "12032 - Porte Doree", "1 Place Edouard Renard -", "1 Place Edouard Renard - 75012 Paris", 48.8355954967, 2.40724728093 },
        { 12031, 10, "12031 - Lame", "49 Rue Gabriel Lame -", "49 Rue Gabriel Lame - 75012 Paris", 48.8351838327, 2.38561331248 },
        { 12029, 10, "12029 - Dugommier", "Face 4 Boulevard De Reuilly -", "Face 4 Boulevard De Reuilly - 75012 Paris", 48.8387051304, 2.38993267831 },
        { 12022, 10, "12022 - Bizot", "Face 29 Rue Du Sahel -", "Face 29 Rue Du Sahel - 75012 Paris", 48.8409986607, 2.40440882448 },
        { 12021, 10, "12021 - Courteline", "1 Avenue Courteline -", "1 Avenue Courteline - 75012 Paris", 48.8444731628, 2.41063625574 },
        { 12019, 10, "12019 - Gare De Reuilly", "58 Rue De La Gare De Reuilly -", "58 Rue De La Gare De Reuilly - 75012 Paris", 48.8424314688, 2.39731654246 },
        { 12018, 10, "12018 - Saint Mande - Favre", "5 Avenue Saint Mande -", "5 Avenue Saint Mande - 75012 Paris", 48.8455687192, 2.39610824335 },
        { 12017, 10, "12017 - St Mande Netter", "82 Avenue Saint Mande -", "82 Avenue Saint Mande - 75012 Paris", 48.8447279441, 2.40536684135 },
        { 12016, 10, "12016 - Picpus", "43 Avenue De Saint Mande -", "43 Avenue De Saint Mande - 75012 Paris", 48.8451256247, 2.40135032112 },
        { 12015, 10, "12015 - Nation Picpus", "Face 67 Boulevard De Picpus -", "Face 67 Boulevard De Picpus - 75012 Paris", 48.8466900036, 2.40031732387 },
        { 12014, 10, "12014 - Nation", "16 Place De La Nation Sur Tpc -", "16 Place De La Nation Sur Tpc - 75012 Paris", 48.847312716, 2.3952523091 },
        { 12013, 10, "12013 - Rue Montgallet", "Face 39 Rue Montgallet -", "Face 39 Rue Montgallet - 75012 Paris", 48.8441966323, 2.38967953465 },
        { 12012, 10, "12012 - Reuilly Diderot", "71 Boulevard Diderot -", "71 Boulevard Diderot - 75012 Paris", 48.8474337032, 2.38599241041 },
        { 12011, 10, "12011 - Charenton", "160 Rue Charenton -", "160 Rue Charenton - 75012 Paris", 48.8447568223, 2.38244947707 },
        { 12010, 10, "12010 - Michel Bizot", "251 Avenue Daumesnil -", "251 Avenue Daumesnil - 75012 Paris", 48.8375398604, 2.40185832354 },
        { 12009, 10, "12009 - Diderot", "Face 124 Rue De Charenton -", "Face 124 Rue De Charenton - 75012 Paris", 48.8462230254, 2.37906002736 },
        { 12008, 10, "12008 - Hector Malot", "15 Bis Rue Hector Malot -", "15 Bis Rue Hector Malot - 75012 Paris", 48.8464125623, 2.37671798256 },
        { 12007, 10, "12007 - Gare De Lyon Chalon", "Face 54 Rue De Chalon -", "Face 54 Rue De Chalon - 75012 Paris", 48.8451731151, 2.37412979026 },
        { 12006, 10, "12006 - Gare De Lyon Van Gogh", "15 Rue Van Gogh -", "15 Rue Van Gogh - 75012 Paris", 48.8440322231, 2.37239964536 },
        { 12005, 10, "12005 - Crozatier", "74 Rue Crozatier -", "74 Rue Crozatier - 75012 Paris", 48.8503484176, 2.37868203545 },
        { 12004, 10, "12004 - Traversiere", "76 Rue Traversiere -", "76 Rue Traversiere - 75012 Paris", 48.8505380577, 2.37599934032 },
        { 12003, 10, "12003 - Quai De La Rapee", "Face 98 Quai De La Rapee -", "Face 98 Quai De La Rapee - 75012 Paris", 48.8458400979, 2.36734886058 },
        { 12002, 10, "12002 - Lacuee", "17 Rue Lacuee -", "17 Rue Lacuee - 75012 Paris", 48.8491915831, 2.37055107185 },
        { 12001, 10, "12001 - Bastille", "48 Boulevard De La Bastille -", "48 Boulevard De La Bastille - 75012 Paris", 48.8516993741, 2.36951765182 },
        { 16011, 10, "16011 - Victor Hugo Rue De La Pompe", "118 Avenue Victor Hugo -", "118 Avenue Victor Hugo - 75016 Paris", 48.8679847484, 2.28123652718 },
        { 2102, 1, "02102 - Saint Marc", "8 Rue Saint Marc -", "8 Rue Saint Marc - 75002 Paris", 48.8702985886, 2.34183224461 },
        { 16004, 10, "16004 - Boulevard Lannes", "Face 2 Boulevard Lannes -", "Face 2 Boulevard Lannes - 75016 Paris", 48.8707765847, 2.27474856871 },
        { 16003, 10, "16003 - Andre Maurois", "2 Bis Boulevard Andre Maurois -", "2 Bis Boulevard Andre Maurois - 75016 Paris", 48.8778249818, 2.27940005345 },
        { 16002, 10, "16002 - Pergolese", "Face 25 Rue Pergolese -", "Face 25 Rue Pergolese - 75016 Paris", 48.8750861342, 2.28429447043 },
        { 1026, 1, "01026 - Colonel Driant", "Place Du Lieutenant Henri Karcher -", "Place Du Lieutenant Henri Karcher - 75001 Paris", 48.8633424301, 2.33997905586 },
        { 1011, 1, "01011 - Rivoli Mairie Du 1Er", "36 Rue De L'Arbre Sec -", "36 Rue De L'Arbre Sec - 75001 Paris", 48.8601428418, 2.34229446296 },
        { 1010, 1, "01010 - Pont Neuf", "10 Rue Boucher -", "10 Rue Boucher - 75001 Paris", 48.8592709695, 2.34416042808 },
        { 1007, 1, "01007 - Etienne Marcel", "2 Rue De Turbigo -", "2 Rue De Turbigo - 75001 Paris", 48.8634408714, 2.34762094543 },
        { 1006, 1, "01006 - Les Halles - Pierre Lescot", "91 Rue Rambuteau -", "91 Rue Rambuteau - 75001 Paris", 48.8621106968, 2.34808381213 },
        { 1005, 1, "01005 - Les Halles - Sebastopol", "3 Rue De La Cossonnerie -", "3 Rue De La Cossonnerie - 75001 Paris", 48.8612387681, 2.34963646039 },
        { 1004, 1, "01004 - Marguerite De Navarre", "1 Place Marguerite De Navarre -", "1 Place Marguerite De Navarre - 75001 Paris", 48.8602774099, 2.34638079595 },
        { 1003, 1, "01003 - Rivoli Saint Denis", "7 Rue Saint Denis -", "7 Rue Saint Denis - 75001 Paris", 48.8589651904, 2.34710246326 },
        { 1002, 1, "01002 - Place Du Chatelet", "14 Avenue Victoria -", "14 Avenue Victoria - 75001 Paris", 48.8579406369, 2.3469524437 },
        { 17043, 10, "17043 - Place General Koenig", "10 Rue Belidor -", "10 Rue Belidor - 75017 Paris", 48.8802722841, 2.28540653081 },
        { 13053, 10, "13053 - Chevaleret Tolbiac", "56 Rue Chevaleret -", "56 Rue Chevaleret - 75013 Paris", 48.8303074889, 2.37471820676 },
        { 13052, 10, "13052 - Tolbiac Lerrede", "2 Rue Leredde -", "2 Rue Leredde - 75013 Paris", 48.8290313269, 2.37445864094 },
        { 13051, 10, "13051 - Quai Francois Mauriac Tolbiac", "9 Quai Francois Mauriac -", "9 Quai Francois Mauriac - 75013 Paris", 48.8327597284, 2.37887219992 },
        { 13050, 10, "13050 - Quai Panhard Et Levassor", "23 Quai Panhard Et Levassor -", "23 Quai Panhard Et Levassor - 75013 Paris", 48.828263879, 2.38434088574 },
        { 17036, 10, "17036 - Avenue De Ternes", "2-4 Place Tristan Bernard -", "2-4 Place Tristan Bernard - 75017 Paris", 48.8793850918, 2.29163454094 },
        { 13047, 10, "13047 - Boutroux Vitry", "1 Avenue Boutroux -", "1 Avenue Boutroux - 75013 Paris", 48.8227389167, 2.37767998818 },
        { 13046, 10, "13046 - Oudine Patay", "10 Rue Eugene Dudine -", "10 Rue Eugene Dudine - 75013 Paris", 48.8257057358, 2.37497351251 },
        { 13045, 10, "13045 - Tolbiac Albert", "Face 1 Rue Jean Colly -", "Face 1 Rue Jean Colly - 75013 Paris", 48.827774119, 2.37089125508 },
        { 13043, 10, "13043 - Dunois Clisson", "55 Rue Dunois -", "55 Rue Dunois - 75013 Paris", 48.8322239204, 2.36743625909 },
        { 13042, 10, "13042 - Nationale Bach", "150 Rue Nationale -", "150 Rue Nationale - 75013 Paris", 48.8311281996, 2.36423646906 },
        { 2011, 1, "02011 - Bibliotheque Nationale", "71 Rue De Richelieu -", "71 Rue De Richelieu - 75002 Paris", 48.8681147499, 2.33808569235 },
        { 13040, 10, "13040 - Porte De Choisy", "111 Boulevard Massena -", "111 Boulevard Massena - 75013 Paris", 48.8200192957, 2.36492482918 },
        { 13039, 10, "13039 - Ivry Pointe D'Ivry", "2 Rue De La Pointe D'Ivry -", "2 Rue De La Pointe D'Ivry - 75013 Paris", 48.8232187905, 2.36544376607 },
        { 2008, 1, "02008 - Mairie Du 2Eme", "11 Rue De La Banque -", "11 Rue De La Banque - 75002 Paris", 48.8670092664, 2.34041517933 },
        { 2007, 1, "02007 - Chabanais", "1 Rue Chabanais -", "1 Rue Chabanais - 75002 Paris", 48.8668655086, 2.33655991905 },
        { 2006, 1, "02006 - Place Des Victoires", "2 Rue D'Aboukir -", "2 Rue D'Aboukir - 75002 Paris", 48.8657869429, 2.34173648862 },
        { 2005, 1, "02005 - Montorgueil Rue Montmartre Version 2", "46 Rue De Montmartre -", "46 Rue De Montmartre - 75002 Paris", 48.8648071391, 2.34519645698 },
        { 2004, 1, "02004 - Reaumur Montorgueil", "83 Allee Pierre Lazaref -", "83 Allee Pierre Lazaref - 75002 Paris", 48.8670268103, 2.34786687352 },
        { 13033, 10, "13033 - Porte D'Italie", "15 Avenue De La Porte D'Italie -", "15 Avenue De La Porte D'Italie - 75013 Paris", 48.8164071637, 2.36059506512 },
        { 13032, 10, "13032 - Massena", "163 Avenue D'Italie -", "163 Avenue D'Italie - 75013 Paris", 48.8192025409, 2.35956194044 },
        { 2001, 2, "02001 - Sebastopol-Grenata", "12 Rue Greneta -", "12 Rue Greneta - 75002 Paris", 48.865201978, 2.35165351611 },
        { 13030, 10, "13030 - Italie Tolbiac", "88 Avenue D'Italie -", "88 Avenue D'Italie - 75013 Paris", 48.8257819223, 2.35731878667 },
        { 13029, 10, "13029 - Italie", "30 Avenue D'Italie -", "30 Avenue D'Italie - 75013 Paris", 48.8298715101, 2.35602712494 },
        { 3101, 3, "03101 - Porte Saint Martin", "62 Rue Meslay -", "62 Rue Meslay - 75003 Paris", 48.8686436468, 2.35525101373 },
        { 13026, 10, "13026 - Place Henocque Version 2", "21 Rue Du Dr Leray Et Landouzy -", "21 Rue Du Dr Leray Et Landouzy - 75013 Paris", 48.8234636564, 2.35372447952 },
        { 13025, 10, "13025 - Place De Rungis", "Face 35 Rue De La Fontaine A Mulard -", "Face 35 Rue De La Fontaine A Mulard - 75013 Paris", 48.8224397871, 2.34717719818 },
        { 13024, 10, "13024 - Bobillot Tolbiac", "81 Rue Bobillot -", "81 Rue Bobillot - 75013 Paris", 48.8256930165, 2.35034941378 },
        { 13022, 10, "13022 - Butte Aux Cailles", "27 Et 36 Rue De La Butte Aux Cailles -", "27 Et 36 Rue De La Butte Aux Cailles - 75013 Paris", 48.8275715625, 2.34913837698 },
        { 13021, 10, "13021 - Boussingault - Tolbiac", "55 Rue Boussingault -", "55 Rue Boussingault - 75013 Paris", 48.8262778471, 2.34181474804 },
        { 13020, 10, "13020 - Mendes France", "Face 15 Rue Paul Klee -", "Face 15 Rue Paul Klee - 75013 Paris", 48.8389187865, 2.37074871069 },
        { 13019, 10, "13019 - Auriol Quai De La Gare", "20 Rue Fernand Braudel -", "20 Rue Fernand Braudel - 75013 Paris", 48.8364287227, 2.37250341324 },
        { 13017, 10, "13017 - Nationale", "167 Rue Nationale -", "167 Rue Nationale - 75013 Paris", 48.8325936314, 2.36216793353 },
        { 13016, 10, "13016 - Primo Levi", "9 Rue Primo Levi -", "9 Rue Primo Levi - 75013 Paris", 48.8308001939, 2.37953768148 },
        { 13015, 10, "13015 - Weiss", "2 Rue Louis Weiss -", "2 Rue Louis Weiss - 75013 Paris", 48.8326632663, 2.37131645296 },
        { 14117, 10, "14117 - Mouchotte", "5 Rue Du Commandant Rene Mouchotte -", "5 Rue Du Commandant Rene Mouchotte - 75014 Paris", 48.839362728, 2.32063006318 },
        { 13013, 5, "13013 - Saint Marcel", "3 Bd Saint Marcel -", "3 Bd Saint Marcel - 75013 Paris", 48.8396850122, 2.36129993671 },
        { 14114, 10, "14114 - Place De Catalogne", "4 Rue Alain -", "4 Rue Alain - 75014 Paris", 48.8373041129, 2.31759456981 },
        { 13010, 10, "13010 - Place D Italie Auriol", "Face 11 Place D'Italie -", "Face 11 Place D'Italie - 75013 Paris", 48.8314892538, 2.35620468588 },
        { 13009, 10, "13009 - Blanqui Corvisart", "46 Boulevard Auguste Blanqui -", "46 Boulevard Auguste Blanqui - 75013 Paris", 48.8298543419, 2.34991484544 },
        { 13008, 10, "13008 - Italie Rosalie", "Face 2 Place D'Italie -", "Face 2 Place D'Italie - 75013 Paris", 48.8318129824, 2.35507487575 },
        { 13007, 10, "13007 - Le Brun Gobelins", "42 Rue Le Brun -", "42 Rue Le Brun - 75013 Paris", 48.8350667366, 2.3533741873 },
        { 2022, 1, "02022 - Bonne Nouvelle Saint Fiacre", "20 Rue Saint Fiacre -", "20 Rue Saint Fiacre - 75002 Paris", 48.8708555799, 2.34586495201 },
        { 2021, 1, "02021 - Clery", "4 Rue De Clery -", "4 Rue De Clery - 75002 Paris", 48.8672967003, 2.34421598881 },
        { 2020, 1, "02020 - Opera Casanova", "02 Rue Daniel Casanova -", "02 Rue Daniel Casanova - 75002 Paris", 48.867620383, 2.3333040131 },
        { 13002, 10, "13002 - Arago", "55 Bd Arago -", "55 Bd Arago - 75013 Paris", 48.8348518962, 2.34464729536 },
        { 2017, 1, "02017 - Bourse Reaumur", "1 Rue Leon Cladel -", "1 Rue Leon Cladel - 75002 Paris", 48.8684381471, 2.34323527096 },
        { 2016, 2, "02016 - Aboukir", "108 Rue D'Aboukir -", "108 Rue D'Aboukir - 75002 Paris", 48.8685095222, 2.3499242846 },
        { 2015, 1, "02015 - Opera - Capucines", "25 Rue Louis Le Grand -", "25 Rue Louis Le Grand - 75002 Paris", 48.8704514164, 2.33398498442 },
        { 2013, 1, "02013 - Richelieu Drouot", "20 Rue Favart -", "20 Rue Favart - 75002 Paris", 48.8716108209, 2.33839910149 },
        { 2012, 1, "02012 - Quatre Septembre", "10 Rue De Choiseul -", "10 Rue De Choiseul - 75002 Paris", 48.8697234814, 2.33608305666 },
        { 2010, 1, "02010 - Boulevard Montmartre", "21 Rue D'Uzes -", "21 Rue D'Uzes - 75002 Paris", 48.8707568904, 2.34303118119 },
        { 2009, 1, "02009 - Bourse", "1 Rue Des Filles Saint Thomas -", "1 Rue Des Filles Saint Thomas - 75002 Paris", 48.8687258654, 2.33978861287 },
        { 18047, 1, "18047 - St Ouen Lamarck", "53 Avenue De Saint Ouen -", "53 Avenue De Saint Ouen - 75018 Paris", 48.8911216861, 2.32674659033 },
        { 2003, 2, "02003 - Allee Pierre Lazaeff", "189 Rue Saint Denis -", "189 Rue Saint Denis - 75002 Paris", 48.86632549, 2.35087733677 },
        { 2002, 1, "02002 - Montorgueil Etienne Marcel", "32 Rue Etienne Marcel -", "32 Rue Etienne Marcel - 75002 Paris", 48.8645554293, 2.34609548297 },
        { 18041, 1, "18041 - Martyrs 2", "Face 112 Boulevard De Rochechouart -", "Face 112 Boulevard De Rochechouart - 75018 Paris", 48.8821528643, 2.34059325161 },
        { 19109, 10, "19109 - Place Du Maroc", "27 Rue De Tanger -", "27 Rue De Tanger - 75019 Paris", 48.8861929854, 2.368816845 },
        { 18038, 10, "18038 - Rond Point De La Chapelle", "70 Rue De La Chapelle -", "70 Rue De La Chapelle - 75018 Paris", 48.8953080638, 2.35964922194 },
        { 18037, 10, "18037 - Amiraux", "48 Rue Boinod -", "48 Rue Boinod - 75018 Paris", 48.8944913938, 2.35224774697 },
        { 18036, 1, "18036 - Francis De Croisset", "7 Rue Francis De Croisset -", "7 Rue Francis De Croisset - 75018 Paris", 48.8994349504, 2.34586970135 },
        { 18034, 1, "18034 - Leibnitz", "50 Rue Leibnitz -", "50 Rue Leibnitz - 75018 Paris", 48.8962178056, 2.33335635579 },
        { 18032, 1, "18032 - Porte De Clignancourt", "Face 59 Rue Belliard -", "Face 59 Rue Belliard - 75018 Paris", 48.897511811, 2.34426094093 },
        { 18031, 1, "18031 - Albert Kahn", "67 Rue Championnet -", "67 Rue Championnet - 75018 Paris", 48.8957412635, 2.34552832755 },
        { 5004, 5, "05004 - Saint Jacques Val De Grace", "272 Rue Saint Jacques -", "272 Rue Saint Jacques - 75005 Paris", 48.841862361, 2.34121700424 },
        { 4104, 4, "04104 - Sebastopol Rambuteau", "Face 40 Boulevard Sebastopol -", "Face 40 Boulevard Sebastopol - 75004 Paris", 48.8618588552, 2.35004525292 },
        { 4103, 3, "04103 - Hotel De Ville", "1 Rue Des Archives -", "1 Rue Des Archives - 75004 Paris", 48.8569782217, 2.35384408494 },
        { 3014, 3, "03014 - Grenier Saint Lazare", "Face 34 Rue Grenier Saint Lazare -", "Face 34 Rue Grenier Saint Lazare - 75003 Paris", 48.8630358814, 2.35275627969 },
        { 3013, 3, "03013 - Rue De Sevigne", "36 Rue De Sevigne -", "36 Rue De Sevigne - 75003 Paris", 48.8567070628, 2.36257450099 },
        { 3012, 3, "03012 - Gaite Lyrique", "Face 8 Rue Salomon De Caus -", "Face 8 Rue Salomon De Caus - 75003 Paris", 48.8674575878, 2.35335701162 },
        { 3011, 3, "03011 - Turbigo", "55 Rue Turbigo -", "55 Rue Turbigo - 75003 Paris", 48.8655878153, 2.35609454573 },
        { 3010, 3, "03010 - Beaubourg", "46 Rue Beaubourg -", "46 Rue Beaubourg - 75003 Paris", 48.8623705986, 2.35433618831 },
        { 14037, 10, "14037 - Jean Moulin", "56 Avenue Jean Moulin -", "56 Avenue Jean Moulin - 75014 Paris", 48.8256927134, 2.32164172899 },
        { 14036, 10, "14036 - Boulard Daguerre", "14 Rue Boulard -", "14 Rue Boulard - 75014 Paris", 48.8341867694, 2.32916783563 },
        { 14035, 10, "14035 - Maine Gaite", "90 Avenue Du Maine -", "90 Avenue Du Maine - 75014 Paris", 48.8376912869, 2.32249587246 },
        { 14034, 10, "14034 - Rue De L Ouest Chateau", "48 Rue De L'Ouest -", "48 Rue De L'Ouest - 75014 Paris", 48.8361090134, 2.31916071563 },
        { 14033, 10, "14033 - Daguerre Gassendi", "31 Rue Frodevaux -", "31 Rue Frodevaux - 75014 Paris", 48.835714584, 2.32811927197 },
        { 14032, 10, "14032 - Mouton Duvernet - Mairie Du 14Eme", "26 Rue Mouton Duvernet -", "26 Rue Mouton Duvernet - 75014 Paris", 48.8324428479, 2.32528818583 },
        { 14031, 10, "14031 - Didot Chateau", "11 Rue Didot -", "11 Rue Didot - 75014 Paris", 48.8338445057, 2.32174818947 },
        { 14030, 10, "14030 - Losserand - Pernety", "61 Rue Pernety -", "61 Rue Pernety - 75014 Paris", 48.8342303547, 2.31756850589 },
        { 14029, 10, "14029 - Gergovie Vercingetorix", "112 Rue Vercingetorix -", "112 Rue Vercingetorix - 75014 Paris", 48.834229552, 2.31319833872 },
        { 14028, 10, "14028 - Plaisance Alesia", "164 Rue Alesia -", "164 Rue Alesia - 75014 Paris", 48.8316414841, 2.3150645948 },
        { 14027, 10, "14027 - Alesia Gergovie", "Face 83 Rue De Gergovie -", "Face 83 Rue De Gergovie - 75014 Paris", 48.8307883078, 2.31886307755 },
        { 14026, 10, "14026 - Plantes Moulin Vert", "23 Rue Des Plantes -", "23 Rue Des Plantes - 75014 Paris", 48.8299260747, 2.3230970571 },
        { 14024, 10, "14024 - Raymond Lausserand", "Rue Vercingetorix -", "Rue Vercingetorix - 75014 Paris", 48.828026337, 2.30567344529 },
        { 14022, 10, "14022 - Brune Didot", "108 Rue Didot -", "108 Rue Didot - 75014 Paris", 48.8264642264, 2.31310665273 },
        { 3007, 3, "03007 - Archives Pastourelle", "67 Rue Des Archives -", "67 Rue Des Archives - 75003 Paris", 48.8622708365, 2.35975754841 },
        { 3006, 3, "03006 - Mairie Du 3Eme", "10 Rue Perree -", "10 Rue Perree - 75003 Paris", 48.8644813656, 2.36162474519 },
        { 15122, 10, "15122 - Place Charles Vallin", "Place Charles Vallin -", "Place Charles Vallin - 75015 Paris", 48.8354941712, 2.30253755107 },
        { 3004, 3, "03004 - Republique 23", "19 Place De La Republique -", "19 Place De La Republique - 75003 Paris", 48.8676896842, 2.36244363399 },
        { 3003, 3, "03003 - Turenne Bretagne", "4 Rue Des Filles Du Calvaire -", "4 Rue Des Filles Du Calvaire - 75003 Paris", 48.8619101996, 2.36515150429 },
        { 3002, 3, "03002 - Saint Gilles", "26 Rue Saint Gilles -", "26 Rue Saint Gilles - 75003 Paris", 48.8581894955, 2.36479536933 },
        { 3001, 3, "03001 - Chemin Vert Beaumarchais", "69 Boulevard Beaumarchais -", "69 Boulevard Beaumarchais - 75003 Paris", 48.8580899242, 2.3677101019 },
        { 13044, 10, "13044 - Place Jeanne D'Arc", "20 Place Jeanne D'Arc -", "20 Place Jeanne D'Arc - 75013 Paris", 48.8294733053, 2.36898653909 },
        { 19041, 10, "19041 - Pyrnes Version 2", "101 Rue De Belleville -", "101 Rue De Belleville - 75019 Paris", 48.8744408945, 2.38588155123 },
        { 19040, 10, "19040 - Telegraphe", "265 Rue De Belleville -", "265 Rue De Belleville - 75019 Paris", 48.8756478471, 2.39949416624 },
        { 14011, 10, "14011 - Alesia Sarrette", "6 Rue Sarrette -", "6 Rue Sarrette - 75014 Paris", 48.8275900153, 2.33200026059 },
        { 19039, 10, "19039 - Pailleron", "6 Rue Edouard Pailleron -", "6 Rue Edouard Pailleron - 75019 Paris", 48.8795946645, 2.37464481686 },
        { 19038, 10, "19038 - Jourdain", "9 Rue Lassus -", "9 Rue Lassus - 75019 Paris", 48.875527055, 2.38897546219 },
        { 3008, 3, "03008 - Perle", "22 Rue De La Perle -", "22 Rue De La Perle - 75003 Paris", 48.859843957, 2.36120031633 },
        { 14007, 10, "14007 - Saint Jacques Ferrus", "1 Rue Ferrus -", "1 Rue Ferrus - 75014 Paris", 48.8313379113, 2.34108006553 },
        { 19035, 10, "19035 - Porte Chaumont", "Rue Sigmund Freud / Porte Chaumont -", "Rue Sigmund Freud / Porte Chaumont - 75019 Paris", 48.8859211133, 2.3978847928 },
        { 14005, 10, "14005 - Denfert Rochereau", "2 Avenue Rene Coty -", "2 Avenue Rene Coty - 75014 Paris", 48.8332971823, 2.33263954011 },
        { 19033, 10, "19033 - Cambrai", "30 Rue De Cambrai -", "30 Rue De Cambrai - 75019 Paris", 48.8957782904, 2.38145806259 },
        { 3005, 3, "03005 - Turbigo Sainte Elisabeth", "7 Rue Sainte Elisabeth -", "7 Rue Sainte Elisabeth - 75003 Paris", 48.865883849, 2.35929595007 },
        { 19031, 10, "19031 - Manin Crimee Version 2", "8 Rue Manin -", "8 Rue Manin - 75019 Paris", 48.8828978706, 2.3859985008 },
        { 4005, 4, "04005 - Sully Morland", "2 Quai Des Celestins -", "2 Quai Des Celestins - 75004 Paris", 48.8512606729, 2.36254460481 },
        { 4001, 4, "04001 - Notre Dame", "10 Rue D'Arcole -", "10 Rue D'Arcole - 75004 Paris", 48.8535455886, 2.3490626131 },
        { 6103, 6, "06103 - Mezieres Rennes", "16 Rue De Mezieres -", "16 Rue De Mezieres - 75006 Paris", 48.8503194741, 2.33036374478 },
        { 4007, 4, "04007 - Bourdon", "Boulevard Bourbon -", "Boulevard Bourbon - 75004 Paris", 48.8526702961, 2.36848320648 },
        { 4006, 4, "04006 - Bassin De L'Arsenal", "Face 1 Boulevard Bourbon -", "Face 1 Boulevard Bourbon - 75004 Paris", 48.8476469325, 2.36594728054 },
        { 4021, 4, "04021 - Beaubourg Rambuteau", "49 Rue Rambuteau -", "49 Rue Rambuteau - 75004 Paris", 48.8613463214, 2.35221092071 },
        { 4003, 4, "04003 - Pont Saint Louis", "1 Quai Aux Fleurs -", "1 Quai Aux Fleurs - 75004 Paris", 48.8527903326, 2.35185435671 },
        { 4002, 4, "04002 - Marche Aux Fleurs", "Place Louis Lepine -", "Place Louis Lepine - 75004 Paris", 48.8551455181, 2.34727879424 },
        { 5104, 5, "05104 - Buffon", "47 Rue Buffon -", "47 Rue Buffon - 75005 Paris", 48.8418425106, 2.35875470233 },
        { 4017, 4, "04017 - Place De L'Hotel De Ville", "7 Place De L'Hotel De Ville -", "7 Place De L'Hotel De Ville - 75004 Paris", 48.856879713, 2.35107915806 },
        { 4016, 4, "04016 - Lobau", "3 Rue Lobau -", "3 Rue Lobau - 75004 Paris", 48.8557111026, 2.35304010743 },
        { 4015, 4, "04015 - Mairie Du 4 Eme", "25 Rue Du Pont Louis Philippe -", "25 Rue Du Pont Louis Philippe - 75004 Paris", 48.8558454296, 2.35634978468 },
        { 4014, 3, "04014 - Archives Blancs Manteaux", "29 Rue Des Blancs Manteaux -", "29 Rue Des Blancs Manteaux - 75004 Paris", 48.859305683, 2.35575174313 },
        { 4013, 3, "04013 - Francs Bourgeois", "50 Rue Vieille Du Temple -", "50 Rue Vieille Du Temple - 75004 Paris", 48.8585323135, 2.35846196836 },
        { 4012, 4, "04012 - Ecouffes Rivoli", "2 Rue Tiron -", "2 Rue Tiron - 75004 Paris", 48.8559619549, 2.35820213853 },
        { 4011, 4, "04011 - Place Du Bataillon Francais De L'Onu", "Face 18 Rue De L'Hotel De Ville -", "Face 18 Rue De L'Hotel De Ville - 75004 Paris", 48.8538410863, 2.35722068681 },
        { 4009, 4, "04009 - Village Saint Paul", "6 Rue Saint Paul -", "6 Rue Saint Paul - 75004 Paris", 48.8527079582, 2.36107444997 },
        { 5001, 5, "05001 - Saint Germain Harpe", "32 Rue De La Harpe -", "32 Rue De La Harpe - 75005 Paris", 48.8514339504, 2.34361463468 },
        { 15070, 10, "15070 - Blanc", "88 Rue Balard -", "88 Rue Balard - 75015 Paris", 48.8386212478, 2.27819115357 },
        { 15069, 10, "15069 - Boucicaut Faure", "41 Avenue Felix Faure -", "41 Avenue Felix Faure - 75015 Paris", 48.8411602754, 2.28818244399 },
        { 15068, 10, "15068 - Boulevard Victor", "Face 5 Boulevard Martial Valin -", "Face 5 Boulevard Martial Valin - 75015 Paris", 48.838257551, 2.27026746901 },
        { 15067, 10, "15067 - Desaix", "23 Rue Desaix -", "23 Rue Desaix - 75015 Paris", 48.852818852, 2.29272019705 },
        { 4019, 4, "04019 - Beaubourg Saint Merry", "4 Rue Du Cloitre Saint Merri -", "4 Rue Du Cloitre Saint Merri - 75004 Paris", 48.8588568569, 2.35182882329 },
        { 15065, 10, "15065 - Humbert", "23 Rue Emile Zola -", "23 Rue Emile Zola - 75015 Paris", 48.8464234219, 2.28022488532 },
        { 15064, 10, "15064 - Javel", "Dev 5 Avenue Emile Zola -", "Dev 5 Avenue Emile Zola - 75015 Paris", 48.8463417339, 2.27857726842 },
        { 15063, 10, "15063 - Saint Charles - Convention", "59 Rue De La Convention -", "59 Rue De La Convention - 75015 Paris", 48.8432701635, 2.28314230491 },
        { 15062, 10, "15062 - Boucicaut", "87 Rue De La Convention -", "87 Rue De La Convention - 75015 Paris", 48.8420669817, 2.28573065457 },
        { 15061, 10, "15061 - Desnouettes", "12 Square Desnouettes -", "12 Square Desnouettes - 75015 Paris", 48.8347145096, 2.28426760463 },
        { 15060, 10, "15060 - Mondrian", "9 Place De La Montagne Du Goulet -", "9 Place De La Montagne Du Goulet - 75015 Paris", 48.8441929709, 2.27708184562 },
        { 15059, 10, "15059 - Citroen", "Rue Balard -", "Rue Balard - 75015 Paris", 48.840966884, 2.27795701125 },
        { 15058, 10, "15058 - Georges Pompidou", "4 Place Du Moulin De Javel -", "4 Place Du Moulin De Javel - 75015 Paris", 48.8400288204, 2.27155867881 },
        { 4010, 4, "04010 - Saint Paul Pave", "105-109 Terre Plein Saint Paul -", "105-109 Terre Plein Saint Paul - 75004 Paris", 48.8551614502, 2.36148416853 },
        { 15056, 10, "15056 - Balard", "13 Place Balard -", "13 Place Balard - 75015 Paris", 48.8365362733, 2.27847943851 },
        { 15055, 10, "15055 - Vasco De Gama", "44 Rue Vasco De Gama -", "44 Rue Vasco De Gama - 75015 Paris", 48.8366916014, 2.28387075417 },
        { 15054, 10, "15054 - Chandon", "293 Rue Lecourbe -", "293 Rue Lecourbe - 75015 Paris", 48.8379243989, 2.28732774678 },
        { 15053, 10, "15053 - Lecourbe", "250 Rue Lecourbe -", "250 Rue Lecourbe - 75015 Paris", 48.8391753755, 2.29157458794 },
        { 15051, 10, "15051 - Rollet", "1 Place Henri Rollet -", "1 Place Henri Rollet - 75015 Paris", 48.8358325797, 2.29311598638 },
        { 4020, 4, "04020 - Beaubourg Place Michelet", "Face 27 Rue Quincampoix -", "Face 27 Rue Quincampoix - 75004 Paris", 48.8599535011, 2.35027633962 },
        { 15049, 10, "15049 - Porte De Versailles", "2 Avenue Ernest Renan -", "2 Avenue Ernest Renan - 75015 Paris", 48.8322173151, 2.28741492001 },
        { 13048, 10, "13048 - Tolbiac Wurtz", "20 Rue Wurtz -", "20 Rue Wurtz - 75013 Paris", 48.8263586349, 2.34395186483 },
        { 15047, 10, "15047 - Dantzig", "Face Au 37 Rue Morillons -", "Face Au 37 Rue Morillons - 75015 Paris", 48.8326088631, 2.3015592875 },
        { 15046, 10, "15046 - Georges Brassens", "42 Rue Des Morillons -", "42 Rue Des Morillons - 75015 Paris", 48.8323035584, 2.30248523077 },
        { 15045, 10, "15045 - Plaine", "Avenue De La Porte De La Plaine -", "Avenue De La Porte De La Plaine - 75015 Paris", 48.8279411876, 2.29240123138 },
        { 20041, 10, "20041 - Belleville", "116 Bd De Belleville -", "116 Bd De Belleville - 75020 Paris", 48.8711544588, 2.37809920718 },
        { 20040, 10, "20040 - Parc De Belleville", "57 & 36 Rue Julien Lacroix -", "57 & 36 Rue Julien Lacroix - 75020 Paris", 48.8702714841, 2.38412018432 },
        { 20039, 10, "20039 - Couronnes", "44 Boulevard De Belleville -", "44 Boulevard De Belleville - 75020 Paris", 48.8689424242, 2.38132619732 },
        { 20038, 10, "20038 - Leon Frapie", "6 Rue Leon Frapie -", "6 Rue Leon Frapie - 75020 Paris", 48.8733589398, 2.41029565346 },
        { 20037, 10, "20037 - Saint Fargeau", "177 Avenue Gambetta -", "177 Avenue Gambetta - 75020 Paris", 48.8712687402, 2.40372596052 },
        { 15039, 10, "15039 - Charles Vallin", "133 Rue De L'Abbe Groult -", "133 Rue De L'Abbe Groult - 75015 Paris", 48.8357816622, 2.30215614889 },
        { 15038, 10, "15038 - Place Adolphe Cherioux", "18 Place Adolphe Cherioux -", "18 Place Adolphe Cherioux - 75015 Paris", 48.8393583102, 2.30080578742 },
        { 15037, 10, "15037 - Groult", "202 Rue Lecourbe -", "202 Rue Lecourbe - 75015 Paris", 48.8403990843, 2.29538594837 },
        { 15036, 10, "15036 - Lambert", "102 Rue De La Croix Nivert -", "102 Rue De La Croix Nivert - 75015 Paris", 48.8430413298, 2.29512510171 },
        { 13035, 10, "13035 - Ivry Tolbiac", "116 Avenue De Choisy -", "116 Avenue De Choisy - 75013 Paris", 48.8259701364, 2.36023184076 },
        { 15034, 10, "15034 - Commerce", "2 Rue Lakanal -", "2 Rue Lakanal - 75015 Paris", 48.8443710288, 2.29385765096 },
        { 15033, 10, "15033 - Violet", "5 Place Violet -", "5 Place Violet - 75015 Paris", 48.8448281245, 2.29050748365 },
        { 15032, 10, "15032 - Lourmel", "112 Ave Felix Faure -", "112 Ave Felix Faure - 75015 Paris", 48.8386499962, 2.28190812282 },
        { 15031, 10, "15031 - Theatre", "60 Rue Du Theatre -", "60 Rue Du Theatre - 75015 Paris", 48.8482521053, 2.28985073839 },
        { 15030, 10, "15030 - Linois", "66 Rue Emeriau -", "66 Rue Emeriau - 75015 Paris", 48.8480431245, 2.2844582582 },
        { 15029, 10, "15029 - Emeriau", "27 Rue Emeriau -", "27 Rue Emeriau - 75015 Paris", 48.8505339025, 2.28734284728 },
        { 13028, 10, "13028 - Gouthiere", "12 Rue Gouthiere -", "12 Rue Gouthiere - 75013 Paris", 48.8207856646, 2.35106954268 },
        { 13027, 10, "13027 - Mazagrand Coubertin", "Avenue De La Porte De Gentilly -", "Avenue De La Porte De Gentilly - 75013 Paris", 48.8162564644, 2.34410026566 },
        { 15025, 7, "15025 - Amette", "26 Rue Dupleix -", "26 Rue Dupleix - 75015 Paris", 48.8513014326, 2.29682073188 },
        { 15024, 7, "15024 - Laos", "88 Avenue De Suffren -", "88 Avenue De Suffren - 75015 Paris", 48.8507455719, 2.30105653883 },
        { 15021, 10, "15021 - Croix Nivert", "Dev 2 Rue Joseph Louville -", "Dev 2 Rue Joseph Louville - 75015 Paris", 48.8449475176, 2.29754738738 },
        { 13023, 10, "13023 - Bobillot Verlaine", "30 Rue Bobillot -", "30 Rue Bobillot - 75013 Paris", 48.8285597542, 2.3530046218 },
        { 15019, 10, "15019 - Vaugirard Cambronne", "3 Rue Paul Barruel -", "3 Rue Paul Barruel - 75015 Paris", 48.8401951988, 2.30439976941 },
        { 15018, 10, "15018 - Alleray", "85 Rue Dutot -", "85 Rue Dutot - 75015 Paris", 48.8366997392, 2.30705688384 },
        { 15017, 10, "15017 - Procession", "7 Place Falguiere -", "7 Place Falguiere - 75015 Paris", 48.836314048, 2.31028381026 },
        { 15016, 10, "15016 - Dutot", "59 Rue Dutot -", "59 Rue Dutot - 75015 Paris", 48.8382549332, 2.30844473785 },
        { 17050, 10, "17050 - Batignolles", "1 Rue Des Batignolles -", "1 Rue Des Batignolles - 75017 Paris", 48.8830239286, 2.32392743369 },
        { 15012, 10, "15012 - Mademoiselle", "76 Rue Cambronne -", "76 Rue Cambronne - 75015 Paris", 48.8429538447, 2.30253255933 },
        { 13014, 5, "13014 - Gare D'Austerlitz", "5 Bis Boulevard De L'Hopital -", "5 Bis Boulevard De L'Hopital - 75013 Paris", 48.8423448958, 2.36334362343 },
        { 15010, 7, "15010 - Cambronne", "Face 3 Bd Garibaldi -", "Face 3 Bd Garibaldi - 75015 Paris", 48.8476273997, 2.30269284415 },
        { 15009, 10, "15009 - Suffren", "140 Avenue De Suffren -", "140 Avenue De Suffren - 75015 Paris", 48.8471522609, 2.30710526991 },
        { 15008, 10, "15008 - Sevres Lecourbe", "Face 4 Boulevard Pasteur -", "Face 4 Boulevard Pasteur - 75015 Paris", 48.8447984556, 2.31100110063 },
        { 15005, 10, "15005 - Place Trefouel", "Face 24 Boulevard Pasteur -", "Face 24 Boulevard Pasteur - 75015 Paris", 48.8426507943, 2.3126770094 },
        { 15004, 10, "15004 - Vaugirard Pasteur", "Dev 71 Boulevard De Vaugirard -", "Dev 71 Boulevard De Vaugirard - 75015 Paris", 48.8405212577, 2.31529226711 },
        { 14015, 10, "14015 - Cite Universitaire", "Face 15 Boulevard Jourdan -", "Face 15 Boulevard Jourdan - 75014 Paris", 48.8204449272, 2.33854768832 },
        { 15001, 6, "15001 - Arrivee", "8 Rue De L'Arrivee -", "8 Rue De L'Arrivee - 75015 Paris", 48.8438657673, 2.32278006798 },
        { 14013, 10, "14013 - Liart Amiral Mouchez", "1 Rue Liard -", "1 Rue Liard - 75014 Paris", 48.8211818125, 2.34242678637 },
        { 18046, 1, "18046 - Fourche", "12 Rue Etienne Jogelle -", "12 Rue Etienne Jogelle - 75018 Paris", 48.8879850881, 2.32599766703 },
        { 18045, 1, "18045 - Ganneron", "2 Rue Pierre Ginier -", "2 Rue Pierre Ginier - 75018 Paris", 48.8865561487, 2.32628416475 },
        { 14010, 10, "14010 - Jean Moulin Alesia", "12 Avenue Jean Moulin -", "12 Avenue Jean Moulin - 75014 Paris", 48.8274367778, 2.32567048851 },
        { 14009, 10, "14009 - Coty Tombe D'Issoire", "49 Rue De La Tombe D'Issoire -", "49 Rue De La Tombe D'Issoire - 75014 Paris", 48.8305559994, 2.33378329803 },
        { 14008, 10, "14008 - Mouton Duvernet", "5 Rue Mouton Duvernet -", "5 Rue Mouton Duvernet - 75014 Paris", 48.8313916493, 2.32954944868 },
        { 16024, 10, "16024 - Kennedy Ranelagh", "4 Rue Ranelagh Devant Rer -", "4 Rue Ranelagh Devant Rer - 75016 Paris", 48.8528316457, 2.28053107925 },
        { 14006, 10, "14006 - Saint Jacques Tombe Issoire", "46 Boulevard Saint Jacques -", "46 Boulevard Saint Jacques - 75014 Paris", 48.8332613201, 2.33672373561 },
        { 14004, 5, "14004 - Port Royal Cochin", "111 Bd Port Royal -", "111 Bd Port Royal - 75014 Paris", 48.8381145297, 2.3418157888 },
        { 14003, 10, "14003 - Raspail Schoelcher", "2 Rue Victor Schoelcher -", "2 Rue Victor Schoelcher - 75014 Paris", 48.8369101346, 2.33131857048 },
        { 14002, 10, "14002 - Raspail Quinet", "Face 4 Bd Edgar Quinet -", "Face 4 Bd Edgar Quinet - 75014 Paris", 48.8392648091, 2.33007928613 },
        { 5013, 5, "05013 - Ulm Erasme", "13 Rue Erasme -", "13 Rue Erasme - 75005 Paris", 48.8424194314, 2.34453944295 },
        { 5012, 5, "05012 - Ulm - Lhomond", "20 Rue De L'Estrapade -", "20 Rue De L'Estrapade - 75005 Paris", 48.8450796752, 2.34552024608 },
        { 5010, 5, "05010 - Saint Michel Henri Barbusse", "1 Rue Henri Barbusse -", "1 Rue Henri Barbusse - 75005 Paris", 48.8436239646, 2.33937888519 },
        { 5009, 4, "05009 - Square Viviani", "6 Rue Du Fouarre -", "6 Rue Du Fouarre - 75005 Paris", 48.8515505239, 2.34741428712 },
        { 5008, 5, "05008 - St Germain-Dante", "9 Rue De Dante -", "9 Rue De Dante - 75005 Paris", 48.8507327672, 2.34612036372 },
        { 5006, 5, "05006 - Saint Jacques Soufflot", "174 Rue Saint Jacques -", "174 Rue Saint Jacques - 75005 Paris", 48.8464908555, 2.34315103531 },
        { 5005, 5, "05005 - Saint Jacques Gay Lussac", "27 Rue Gay Lussac -", "27 Rue Gay Lussac - 75005 Paris", 48.8446125163, 2.34200699768 },
        { 15002, 10, "15002 - Bourdelle", "26 Avenue Du Maine -", "26 Avenue Du Maine - 75015 Paris", 48.8430925457, 2.3205335522 },
        { 5003, 5, "05003 - Gay Lussac Le Goff", "9 Rue Le Goff -", "9 Rue Le Goff - 75005 Paris", 48.8459606684, 2.34133987318 },
        { 5002, 5, "05002 - Saint Jacques", "20 Rue Sommerard -", "20 Rue Sommerard - 75005 Paris", 48.8502205545, 2.34507165739 },
        { 17016, 10, "17016 - Brochant", "3 Rue Brochant -", "3 Rue Brochant - 75017 Paris", 48.8880378178, 2.31697568008 },
        { 20036, 10, "20036 - Menilmontant - Pelleport", "164 Rue De Menilmontant -", "164 Rue De Menilmontant - 75020 Paris", 48.8704174455, 2.39907917559 },
        { 20035, 10, "20035 - Pyrenees", "262 Rue Des Pyrenees -", "262 Rue Des Pyrenees - 75020 Paris", 48.8693589116, 2.39515435809 },
        { 20032, 10, "20032 - Amandiers", "55 Rue Des Cendriers -", "55 Rue Des Cendriers - 75020 Paris", 48.8659015914, 2.38904759654 },
        { 5035, 5, "05035 - Buffon Austerlitz", "1 Rue Buffon -", "1 Rue Buffon - 75005 Paris", 48.843198603, 2.36383424976 },
        { 5034, 5, "05034 - Censier", "21 Rue Censier -", "21 Rue Censier - 75005 Paris", 48.8405401103, 2.35378436461 },
        { 5033, 5, "05033 - Saint Severin", "42 Rue Saint Severin -", "42 Rue Saint Severin - 75005 Paris", 48.85269217, 2.34407783753 },
        { 5032, 5, "05032 - Pantheon Carmes", "2 Rue Valette -", "2 Rue Valette - 75005 Paris", 48.8467782468, 2.34644650826 },
        { 5031, 5, "05031 - Lacepede", "2 Rue Lacepede -", "2 Rue Lacepede - 75005 Paris", 48.8436047248, 2.35473850942 },
        { 5030, 5, "05030 - Sorbonne", "5 Rue De La Sorbonne -", "5 Rue De La Sorbonne - 75005 Paris", 48.849690374, 2.34372336713 },
        { 5029, 5, "05029 - Port Royal", "Face 41 Avenue Georges Bernanos -", "Face 41 Avenue Georges Bernanos - 75005 Paris", 48.8399480795, 2.33729552803 },
        { 5028, 5, "05028 - Censier Buffon", "6 Rue Censier -", "6 Rue Censier - 75005 Paris", 48.8409982538, 2.35530950315 },
        { 5027, 5, "05027 - Gobelins", "22 Avenue Des Gobelins -", "22 Avenue Des Gobelins - 75005 Paris", 48.8369992916, 2.35161845852 },
        { 5026, 5, "05026 - Mouffetard Saint Medard", "3 Rue Pascal -", "3 Rue Pascal - 75005 Paris", 48.8389228142, 2.35001236682 },
        { 5023, 5, "05023 - Place Jussieu", "13 Rue Jussieu -", "13 Rue Jussieu - 75005 Paris", 48.845429018, 2.35588296643 },
        { 5022, 5, "05022 - Cardinal Lemoine", "40 Rue Bou Langers -", "40 Rue Bou Langers - 75005 Paris", 48.8462563841, 2.35223380436 },
        { 5021, 5, "05021 - Jussieu", "41 Rue Jussieu -", "41 Rue Jussieu - 75005 Paris", 48.847235891, 2.35324179276 },
        { 5020, 4, "05020 - Pont De Sully Rive Gauche", "03 Rue Des Fosses Saint Bernard -", "03 Rue Des Fosses Saint Bernard - 75005 Paris", 48.8491947161, 2.35629286358 },
        { 5019, 4, "05019 - Poissy", "8-10 Rue De Poissy -", "8-10 Rue De Poissy - 75005 Paris", 48.8493030615, 2.35288835713 },
        { 5018, 4, "05018 - Mutualite", "20 Rue Monge -", "20 Rue Monge - 75005 Paris", 48.8482069053, 2.35024615471 },
        { 5017, 5, "05017 - Descartes", "17 Rue Descartes -", "17 Rue Descartes - 75005 Paris", 48.8463016676, 2.34916990315 },
        { 5016, 5, "05016 - Contrescarpe-Thouin", "1 Rue Thouin -", "1 Rue Thouin - 75005 Paris", 48.8449894279, 2.34978236906 },
        { 5015, 5, "05015 - Mouffetard Epee De Bois", "12 Rue De L'Epee De Bois -", "12 Rue De L'Epee De Bois - 75005 Paris", 48.8412865066, 2.350326118 },
        { 16044, 10, "16044 - Stade Francais", "24 Avenue De La Porte De Saint Cloud -", "24 Avenue De La Porte De Saint Cloud - 75016 Paris", 48.8386685575, 2.25237630345 },
        { 16043, 10, "16043 - Place De Passy", "2 Place De Passy -", "2 Place De Passy - 75016 Paris", 48.8577552708, 2.27747472306 },
        { 16042, 10, "16042 - Porte De Saint Cloud", "120 Boulevard Murat -", "120 Boulevard Murat - 75016 Paris", 48.8372973087, 2.25796071333 },
        { 16040, 10, "16040 - Exelmans", "73 Bis Boulevard Exelmans -", "73 Bis Boulevard Exelmans - 75016 Paris", 48.8430056558, 2.25985830392 },
        { 16039, 10, "16039 - Versailles Exelmans", "27 Boulevard Exelmans -", "27 Boulevard Exelmans - 75016 Paris", 48.8406538319, 2.2644776093 },
        { 16038, 10, "16038 - Rue Molitor", "Rue Molitor -", "Rue Molitor - 75016 Paris", 48.8449508422, 2.26607839283 },
        { 5007, 5, "05007 - Ecoles Carmes", "39 Rue Des Ecoles -", "39 Rue Des Ecoles - 75005 Paris", 48.8487823928, 2.34726394634 },
        { 16036, 10, "16036 - Porte Molitor", "Place De La Porte Molitor -", "Place De La Porte Molitor - 75016 Paris", 48.8449630883, 2.25706388796 },
        { 16035, 10, "16035 - Hyppodrome D Auteuil", "Allee Des Fortifications -", "Allee Des Fortifications - 75016 Paris", 48.8486125696, 2.25788894491 },
        { 16034, 10, "16034 - Porte D'Auteuil", "76 Rue D'Auteuil -", "76 Rue D'Auteuil - 75016 Paris", 48.8479312955, 2.26059993561 },
        { 16033, 10, "16033 - Michel Ange Auteuil", "85 Rue Jean De La Fontaine -", "85 Rue Jean De La Fontaine - 75016 Paris", 48.8483205818, 2.26512051398 },
        { 16032, 10, "16032 - Eglise D Auteuil", "Place De L'Eglise D'Auteuil -", "Place De L'Eglise D'Auteuil - 75016 Paris", 48.8474240262, 2.26883939185 },
        { 16031, 10, "16031 - Boulainvilliers", "51 Rue Des Vignes -", "51 Rue Des Vignes - 75016 Paris", 48.8563518554, 2.27479319286 },
        { 16030, 10, "16030 - Mirabeau", "4 Place De Barcelone -", "4 Place De Barcelone - 75016 Paris", 48.847723125, 2.27336009852 },
        { 16029, 10, "16029 - Maison De Radio France", "1 Rue Gros -", "1 Rue Gros - 75016 Paris", 48.8512935426, 2.27797244361 },
        { 13038, 10, "13038 - Choisy Point D'Ivry", "28 Avenue De Choisy -", "28 Avenue De Choisy - 75013 Paris", 48.8218980827, 2.36333334455 },
        { 13037, 10, "13037 - Ivry Baudicourt", "76 Avenue D'Ivry -", "76 Avenue D'Ivry - 75013 Paris", 48.8246213777, 2.36319859602 },
        { 13036, 10, "13036 - Tolbiac Nationale", "86 Rue Tolbiac -", "86 Rue Tolbiac - 75013 Paris", 48.8271731181, 2.36645323017 },
        { 16025, 10, "16025 - Fontaine Raynouard", "4 Rue Jean De La Fontaine -", "4 Rue Jean De La Fontaine - 75016 Paris", 48.8526584411, 2.27561478465 },
        { 13034, 10, "13034 - Edison", "54 Avenue Edison -", "54 Avenue Edison - 75013 Paris", 48.8291516665, 2.36072331388 },
        { 16023, 10, "16023 - Rue De Passy", "1 Rue De Passy -", "1 Rue De Passy - 75016 Paris", 48.8583875829, 2.28421617808 },
        { 16022, 10, "16022 - Rue Jean Bologne", "16 Rue Jean Bologne -", "16 Rue Jean Bologne - 75016 Paris", 48.8576036832, 2.27991294362 },
        { 13031, 10, "13031 - Italie Maison Blanche", "121 Avenue D'Italie -", "121 Avenue D'Italie - 75013 Paris", 48.8219799007, 2.35867841827 },
        { 16020, 10, "16020 - Porte De Passy", "1 Place De La Porte De Passy -", "1 Place De La Porte De Passy - 75016 Paris", 48.8572536995, 2.26442707585 },
        { 16019, 10, "16019 - Henri Martin", "Face 98 Av. Henri Martin -", "Face 98 Av. Henri Martin - 75016 Paris", 48.8630172181, 2.26879157692 },
        { 16018, 10, "16018 - Flandrin", "2 Boulevard Flandrin -", "2 Boulevard Flandrin - 75016 Paris", 48.8642775006, 2.27245426384 },
        { 16017, 10, "16017 - Rue De Siam", "1 Bis Rue De Siam -", "1 Bis Rue De Siam - 75016 Paris", 48.8616187424, 2.27529084199 },
        { 16016, 10, "16016 - Paul Doumer / La Tour", "53 Avenue Paul Doumer -", "53 Avenue Paul Doumer - 75016 Paris", 48.8600936456, 2.28085004106 },
        { 16015, 10, "16015 - Rue De Bassano", "1 Rue De Bassano -", "1 Rue De Bassano - 75016 Paris", 48.8679907953, 2.2960584481 },
        { 16014, 10, "16014 - Avenue D Eylau", "4 Avenue D'Eylau -", "4 Avenue D'Eylau - 75016 Paris", 48.8636192169, 2.28643120477 },
        { 16013, 10, "16013 - Avenue Henri Martin", "Avenue Henri Martin -", "Avenue Henri Martin - 75016 Paris", 48.8640101498, 2.27677278809 },
        { 13041, 10, "13041 - Porte D'Ivry", "4 Avenue D'Ivry -", "4 Avenue D'Ivry - 75013 Paris", 48.8214652984, 2.36899525362 },
        { 16010, 10, "16010 - Belles Feuilles", "4 Rue Des Belles Feuilles -", "4 Rue Des Belles Feuilles - 75016 Paris", 48.8658554964, 2.28285990898 },
        { 16009, 10, "16009 - Saint Didier", "32 Rue Saint Didier -", "32 Rue Saint Didier - 75016 Paris", 48.8662971548, 2.28573382497 },
        { 16008, 10, "16008 - Galilee Kleber", "1 Rue Galilee -", "1 Rue Galilee - 75016 Paris", 48.8673686166, 2.29050078649 },
        { 16007, 10, "16007 - Longchamp", "4 Rue De Longchamp -", "4 Rue De Longchamp - 75016 Paris", 48.8648261757, 2.2930776865 },
        { 16006, 10, "16006 - Rue Lauriston", "60 Rue Lauriston -", "60 Rue Lauriston - 75016 Paris", 48.8690939558, 2.28991342527 },
        { 16005, 10, "16005 - Poincarre Victor Hugo", "89 Avenue Raymond Poincare -", "89 Avenue Raymond Poincare - 75016 Paris", 48.8701614289, 2.2850760494 },
        { 17107, 10, "17107 - Berthier Stuart Merril", "182 Boulevard Berthier -", "182 Boulevard Berthier - 75017 Paris", 48.8857577508, 2.29350956386 },
        { 17106, 10, "17106 - Berthier Porte De Clichy", "4 Boulevard Berthier -", "4 Boulevard Berthier - 75017 Paris", 48.8943550302, 2.31284331126 },
        { 17105, 10, "17105 - Paladines", "18 Boulevard D'Aurelle De Paladines -", "18 Boulevard D'Aurelle De Paladines - 75017 Paris", 48.8836949755, 2.2821734556 },
        { 16001, 10, "16001 - Avenue Des Portugais", "2 Avenue Des Portugais -", "2 Avenue Des Portugais - 75016 Paris", 48.8711714194, 2.29354911791 },
        { 11107, 10, "11107 - Bibliotheque Faidherbe", "11 Rue Faidherbe -", "11 Rue Faidherbe - 75011 Paris", 48.8514700719, 2.38351758959 },
        { 11105, 10, "11105 - Republique Parmentier", "82 Avenue Parmentier -", "82 Avenue Parmentier - 75011 Paris", 48.8644418287, 2.37531499873 },
        { 11104, 10, "11104 - Charonne Du Bureau", "170 Rue De Charonne -", "170 Rue De Charonne - 75011 Paris", 48.8557980792, 2.39275573759 },
        { 6032, 6, "06032 - Rennes Sabot", "7 Rue Du Sabot -", "7 Rue Du Sabot - 75006 Paris", 48.8525933851, 2.33194325237 },
        { 6031, 5, "06031 - Saint Michel Sarrazin", "5 Rue Pierre Sarazin -", "5 Rue Pierre Sarazin - 75006 Paris", 48.8507689324, 2.34248421186 },
        { 6030, 6, "06030 - Vaugirard Assas", "74 Rue De Vaugirard -", "74 Rue De Vaugirard - 75006 Paris", 48.8479197856, 2.3298738219 },
        { 6029, 5, "06029 - Vaugirard Prince", "Face 1 Rue De Vaugirard -", "Face 1 Rue De Vaugirard - 75006 Paris", 48.8487917309, 2.34134009623 },
        { 6028, 5, "06028 - Odeon Quatre Vents", "6 Rue Des Quatre Vents -", "6 Rue Des Quatre Vents - 75006 Paris", 48.8517846276, 2.3382216186 },
        { 6027, 6, "06027 - Vaugirard Desgoffe", "2 Rue Blaise Desgoffe -", "2 Rue Blaise Desgoffe - 75006 Paris", 48.8460588838, 2.32418204142 },
        { 6026, 6, "06026 - Saint Placide Cherche Midi", "28 Rue Saint Placide -", "28 Rue Saint Placide - 75006 Paris", 48.8490608216, 2.32525711655 },
        { 6025, 6, "06025 - Rennes - Assas", "16 Rue D'Assas -", "16 Rue D'Assas - 75006 Paris", 48.8491150349, 2.32857992902 },
        { 6024, 6, "06024 - Saint Germain Des Pres", "55 Rue Des Saints Peres -", "55 Rue Des Saints Peres - 75006 Paris", 48.8540582659, 2.33047220363 },
        { 6022, 6, "06022 - Marche Saint Germain - Mabillon", "17 Rue Lobineau -", "17 Rue Lobineau - 75006 Paris", 48.851568922, 2.33568852159 },
        { 6021, 6, "06021 - Bonaparte Beaux Arts", "17 Rue Des Beaux Arts -", "17 Rue Des Beaux Arts - 75006 Paris", 48.8562873213, 2.33488479817 },
        { 8101, 1, "08101 - Londres Amsterdam", "42 Rue De Londres -", "42 Rue De Londres - 75008 Paris", 48.8780182936, 2.32658573729 },
        { 8047, 8, "08047 - George V", "28 Avenue George V -", "28 Avenue George V - 75008 Paris", 48.8681452412, 2.30118062405 },
        { 8003, 8, "08003 - Galille", "63 Rue Galilee -", "63 Rue Galilee - 75008 Paris", 48.8717033873, 2.29850783092 },
        { 19004, 10, "19004 - Quai De La Loire", "4 Quai De La Loire -", "4 Quai De La Loire - 75019 Paris", 48.8830379061, 2.37087260815 },
        { 12030, 10, "12030 - Wattignies", "245 Rue De Charenton -", "245 Rue De Charenton - 75012 Paris", 48.8367269131, 2.39204097726 },
        { 1028, 1, "01028 - Les Halles - Porte", "Rue Berger -", "Rue Berger - 75001 Paris", 48.8612390332, 2.34674874082 },
        { 5014, 5, "05014 - Calvin", "8 Rue Jean Calvin -", "8 Rue Jean Calvin - 75005 Paris", 48.8415652755, 2.34882841135 },
        { 18035, 1, "18035 - Porte Montmartre", "Face 66 Rue Rene Binet -", "Face 66 Rue Rene Binet - 75018 Paris", 48.8990308399, 2.33666853862 },
        { 3009, 3, "03009 - Temple 113", "76 Rue Du Temple -", "76 Rue Du Temple - 75003 Paris", 48.8615883006, 2.35689675588 },
        { 14023, 10, "14023 - Malakoff Pinard", "76-78 Boulevard Adolphe Pinard -", "76-78 Boulevard Adolphe Pinard - 75014 Paris", 48.8236859741, 2.30833032171 },
        { 6108, 6, "06108 - Saint Romain Cherche Midi", "20 Rue Saint Romain -", "20 Rue Saint Romain - 75006 Paris", 48.8469303255, 2.32133575142 },
        { 5024, 5, "05024 - Place Monge", "4 Rue Dolomieu -", "4 Rue Dolomieu - 75005 Paris", 48.8426703425, 2.35239616616 },
        { 9102, 1, "09102 - Place D'Estienne D'Orves", "2 Rue De Londres -", "2 Rue De Londres - 75009 Paris", 48.8766525227, 2.33067362892 },
        { 19037, 10, "19037 - Porte Des Lilas", "304 Rue De Belleville -", "304 Rue De Belleville - 75019 Paris", 48.8765796386, 2.40479554768 },
        { 17029, 10, "17029 - Place Aime Maillart", "29 Rue Pierre Demours -", "29 Rue Pierre Demours - 75017 Paris", 48.8815161815, 2.29463052834 },
        { 1001, 1, "01001 - Ile De La Cite Pont Neuf", "41 Quai De L'Horloge -", "41 Quai De L'Horloge - 75001 Paris", 48.8571230881, 2.34183108134 },
        { 901, 10, "00901 - Station Mobile 1", "Allee Du Belvedere Paris 19 - 0 75000 Paris -", "Allee Du Belvedere Paris 19 - 0 75000 Paris - 75000 Paris", 48.8927455824, 2.39125515989 },
        { 11011, 10, "11011 - Richard Lenoir", "Face 86 Boulevard Richard Lenoir -", "Face 86 Boulevard Richard Lenoir - 75011 Paris", 48.861773443, 2.37249339788 },
        { 1116, 1, "01116 - Opra Pyramides", "4 Rue De Ventadour -", "4 Rue De Ventadour - 75001 Paris", 48.8665778765, 2.33421681482 },
        { 9106, 1, "09106 - Auber", "3 Rue Boudreau -", "3 Rue Boudreau - 75009 Paris", 48.8721048841, 2.32961152049 },
        { 6104, 5, "06104 - Herschel", "7 Rue Herschel -", "7 Rue Herschel - 75006 Paris", 48.8432375186, 2.33779934465 },
        { 7101, 6, "07101 - Sevres Babylone", "Boulevard Raspail -", "Boulevard Raspail - 75007 Paris", 48.8545792402, 2.32644074282 },
        { 18108, 10, "18108 - Evangile", "61 Rue De L'Evangile -", "61 Rue De L'Evangile - 75018 Paris", 48.8948119431, 2.36786798422 },
        { 904, 7, "00904 - Station Mobile 4", "Ecole Militaire-Avenue De La Motte Picquet -", "Ecole Militaire-Avenue De La Motte Picquet - 75007 Paris", 48.8522916418, 2.30180450329 },
        { 4018, 4, "04018 - Rivoli Sebastopol", "1 Rue Saint Bon -", "1 Rue Saint Bon - 75004 Paris", 48.8580571844, 2.35001707425 },
        { 4101, 4, "04101 - Bastille", "11 Rue De La Bastille -", "11 Rue De La Bastille - 75004 Paris", 48.8538476743, 2.36840219912 },
        { 4107, 4, "04107 - Beaumarchais", "27 Boulevard Beaumarchais -", "27 Boulevard Beaumarchais - 75004 Paris", 48.8556002866, 2.36817171444 },
        { 5102, 5, "05102 - Saint Jacques (2)", "42 Rue Saint Jacques -", "42 Rue Saint Jacques - 75005 Paris", 48.8497801803, 2.34488093468 },
        { 5105, 5, "05105 - Geoffroy Saint Hilaire", "8 Rue Geoffroy Saint Hilaire -", "8 Rue Geoffroy Saint Hilaire - 75005 Paris", 48.8389847625, 2.35706519888 },
        { 5107, 4, "05107 - Pontoise", "1 Rue De Pontoise -", "1 Rue De Pontoise - 75005 Paris", 48.8504894533, 2.35254825233 },
        { 14108, 10, "14108 - Jourdan Le Brix Et Mesnin", "Rue Le Brix Et Mesnin -", "Rue Le Brix Et Mesnin - 75014 Paris", 48.8222061454, 2.32779498343 },
        { 18111, 1, "18111 - Feliz Ziem", "2 Rue Felix Ziem -", "2 Rue Felix Ziem - 75018 Paris", 48.8895313555, 2.33341137357 },
        { 11103, 10, "11103 - Richard Lenoir", "21 Rue Pelee -", "21 Rue Pelee - 75011 Paris", 48.859895452, 2.37119812986 },
        { 7102, 7, "07102 - Sainte Clothilde", "Face 19 Rue Casimir Perier -", "Face 19 Rue Casimir Perier - 75007 Paris", 48.8579217249, 2.31943913579 },
        { 15108, 10, "15108 - Muse Des Tlcommunications", "88 - 90 Rue De Lourmel -", "88 - 90 Rue De Lourmel - 75015 Paris", 48.8446918923, 2.2870216604 },
        { 18110, 10, "18110 - Departement", "Face 53 Rue Du Departement -", "Face 53 Rue Du Departement - 75018 Paris", 48.8866350612, 2.36155339361 },
        { 20107, 10, "20107 - Stade Maryse Hilsz", "26 Rue Maryse Hilsz -", "26 Rue Maryse Hilsz - 75020 Paris", 48.8511855092, 2.41274302953 },
        { 20108, 10, "20108 - Hospice Debrousse", "142 Rue De Bagnolet -", "142 Rue De Bagnolet - 75020 Paris", 48.8615522643, 2.40572947407 },
        { 11109, 10, "11109 - Republique Pierre Levee", "1 Rue De La Pierre Levee -", "1 Rue De La Pierre Levee - 75011 Paris", 48.8663393834, 2.37128408416 },
        { 12106, 10, "12106 - Barthes Troyes", "3 Rue Roland Barthes -", "3 Rue Roland Barthes - 75012 Paris", 48.844218905, 2.37878607523 },
        { 18114, 1, "18114 - Lepic Veron", "35 Rue Veron -", "35 Rue Veron - 75018 Paris", 48.8851725901, 2.33450190531 },
        { 20030, 10, "20030 - Pere Lachaise", "54 Boulevard Menilmontant -", "54 Boulevard Menilmontant - 75020 Paris", 48.863331931, 2.38734229605 },
        { 12105, 10, "12105 - Bercy Villot", "153 Rue De Bercy -", "153 Rue De Bercy - 75012 Paris", 48.8418649882, 2.37637411735 },
        { 13107, 10, "13107 - Marchand Sante", "12 Passage Victor Marchand -", "12 Passage Victor Marchand - 75013 Paris", 48.8289022342, 2.34193749423 },
        { 13109, 10, "13109 - Brillat Savarin", "16 Rue Brillat Savarin -", "16 Rue Brillat Savarin - 75013 Paris", 48.8222057948, 2.35040297809 },
        { 14107, 10, "14107 - Porte De Montrouge 2", "2 Avenue De La Porte De Montrouge -", "2 Avenue De La Porte De Montrouge - 75014 Paris", 48.8235987566, 2.32298989139 },
        { 5106, 5, "05106 - Cujas", "22 Rue Cujas -", "22 Rue Cujas - 75005 Paris", 48.8481625933, 2.34170772956 },
        { 7103, 7, "07103 - Belgrade", "2 Rue De Belgrade -", "2 Rue De Belgrade - 75007 Paris", 48.8561834952, 2.30278248274 },
        { 10110, 10, "10110 - Louis Blanc (Prop 2)", "10 Rue Louis Blanc -", "10 Rue Louis Blanc - 75010 Paris", 48.8793538315, 2.3682948899 },
        { 13113, 10, "13113 - Choisy Vistule", "2 Rue De La Viscule -", "2 Rue De La Viscule - 75013 Paris", 48.8236330762, 2.36157833946 },
        { 20104, 10, "20104 - Rue Louis Lumire", "68 Rue Louis Lumiere -", "68 Rue Louis Lumiere - 75020 Paris", 48.8621242598, 2.41108350129 },
        { 6107, 6, "06107 - Cherche Midi", "29 Rue Du Cherche Midi -", "29 Rue Du Cherche Midi - 75006 Paris", 48.850121562, 2.32765370956 },
        { 10107, 10, "10107 - Magenta Pare", "9 Rue Ambroise Pare -", "9 Rue Ambroise Pare - 75010 Paris", 48.8818014415, 2.35243485046 },
        { 10114, 10, "10114 - Hopital Saint Louis", "12 Bis Rue De La Grange Aux Belles -", "12 Bis Rue De La Grange Aux Belles - 75010 Paris", 48.8751302106, 2.36671186459 },
        { 11101, 10, "11101 - Square Nordling", "15 Rue Charles Delescluze -", "15 Rue Charles Delescluze - 75011 Paris", 48.8523788577, 2.38072650634 },
        { 11110, 10, "11110 - Square Roquette", "176 Rue De La Roquette -", "176 Rue De La Roquette - 75011 Paris", 48.8593957753, 2.38656210665 },
        { 13106, 10, "13106 - Bobillot Mery", "17 Rue Bobillot -", "17 Rue Bobillot - 75013 Paris", 48.8298717702, 2.35429826318 },
        { 13122, 10, "13122 - Parc De Choisy", "Face 153 Avenue De Choisy -", "Face 153 Avenue De Choisy - 75013 Paris", 48.8282533416, 2.35838152987 },
        { 10113, 10, "10113 - Parmentier Louvel-Tessier", "151 Avenue Parmentier -", "151 Avenue Parmentier - 75010 Paris", 48.87130981, 2.36976146229 },
        { 11113, 10, "11113 - Republique Ferry", "Face 140 Boulevard Richard Lenoir -", "Face 140 Boulevard Richard Lenoir - 75011 Paris", 48.866402758, 2.36962215921 },
        { 19020, 10, "19020 - Manin Hautpoul", "4-6 Rue Goubet -", "4-6 Rue Goubet - 75019 Paris", 48.8843969297, 2.39023803413 },
        { 19105, 10, "19105 - Porte Brunet", "Face 1 Avenue Ambroise Rendu -", "Face 1 Avenue Ambroise Rendu - 75019 Paris", 48.8835046058, 2.39576975436 },
        { 12108, 10, "12108 - Palais Omnisport", "81 Rue De Bercy -", "81 Rue De Bercy - 75012 Paris", 48.8388256254, 2.38089215045 },
        { 12110, 10, "12110 - Baron Le Roy Truffaut", "57-61 Rue Des Pirogues De Bercy -", "57-61 Rue Des Pirogues De Bercy - 75012 Paris", 48.8339153516, 2.38855278637 },
        { 15052, 10, "15052 - Convention", "183 Rue De La Convention -", "183 Rue De La Convention - 75015 Paris", 48.8373972774, 2.2954972911 },
        { 19101, 10, "19101 - Simon Bolivar", "36 Avenue Simon Bolivar -", "36 Avenue Simon Bolivar - 75019 Paris", 48.8751072494, 2.38259855968 },
        { 11111, 10, "11111 - Charonne Frot", "30-32 Rue Leon Frot -", "30-32 Rue Leon Frot - 75011 Paris", 48.8548658851, 2.387102586 },
        { 15104, 10, "15104 - Hpital Georges Pompidou (Prop 2)", "Face 66 - 70 Rue Leblanc -", "Face 66 - 70 Rue Leblanc - 75015 Paris", 48.8378650093, 2.27565958978 },
        { 15105, 7, "15105 - Suffren Fdration", "84 Rue De La Federation -", "84 Rue De La Federation - 75015 Paris", 48.8528565929, 2.29780009619 },
        { 7023, 7, "07023 - Bourdonnais Tour Eiffel", "Quai Branly -", "Quai Branly - 75007 Paris", 48.8607647037, 2.29536950713 },
        { 7025, 7, "07025 - Suffren Tour Eiffel", "2 Avenue Octave Creard -", "2 Avenue Octave Creard - 75007 Paris", 48.8564499019, 2.29304396081 },
        { 12111, 10, "12111 - Decaen Cannebiere", "73 Rue Claude Decaen -", "73 Rue Claude Decaen - 75012 Paris", 48.8374613941, 2.39722909837 },
        { 14103, 10, "14103 - Maine Liancourt", "132 / 136 Avenue Du Maine -", "132 / 136 Avenue Du Maine - 75014 Paris", 48.8351030049, 2.32368106641 },
        { 14113, 10, "14113 - Arago 2", "36 Rue De La Sante -", "36 Rue De La Sante - 75014 Paris", 48.8351576226, 2.3416521551 },
        { 8105, 8, "08105 - Francois 1Er Lincoln", "56 Rue Francois 1Er -", "56 Rue Francois 1Er - 75008 Paris", 48.8695206416, 2.30231041734 },
        { 9020, 1, "09020 - Toudouze Clauzel", "Face 27 Rue Clauzel -", "Face 27 Rue Clauzel - 75009 Paris", 48.8794297726, 2.33728193422 },
        { 9034, 1, "09034 - Godot De Mauroy", "2 Rue Godot De Mauroy -", "2 Rue Godot De Mauroy - 75009 Paris", 48.8698039018, 2.32665554514 },
        { 15106, 7, "15106 - Grenelle Violet (Prop3)", "Boulevard De Grenelle -", "Boulevard De Grenelle - 75015 Paris", 48.8497548028, 2.29457491711 },
        { 17047, 10, "17047 - Courcelles - Demoures", "172 Rue De Courcelles -", "172 Rue De Courcelles - 75017 Paris", 48.883719452, 2.29873051228 },
        { 17101, 10, "17101 - Alexandre Charpentier", "Face 3 Rue Alexandre Charpentier -", "Face 3 Rue Alexandre Charpentier - 75017 Paris", 48.8843448774, 2.28865940432 },
        { 19121, 10, "19121 - Belleville Pre Saint Gervais", "195 Rue De Belleville -", "195 Rue De Belleville - 75019 Paris", 48.8751390111, 2.39251756832 },
        { 9019, 1, "09019 - Victor Masse", "38 Rue Victor Masse -", "38 Rue Victor Masse - 75009 Paris", 48.8811643114, 2.33651884813 },
        { 11002, 10, "11002 - Roquette Thiere", "37 Rue De La Roquette -", "37 Rue De La Roquette - 75011 Paris", 48.8552123666, 2.37336060314 },
        { 20113, 10, "20113 - Parc De Belleville", "30 Rue Piat -", "30 Rue Piat - 75020 Paris", 48.8719249038, 2.38474838881 },
        { 8008, 8, "08008 - Rome Saint Lazare", "1 Rue Joseph Sansboeuf -", "1 Rue Joseph Sansboeuf - 75008 Paris", 48.8752048819, 2.32286669437 },
        { 8020, 8, "08020 - Metro Rome", "74 Boulevard Des Batignolles -", "74 Boulevard Des Batignolles - 75008 Paris", 48.8821516248, 2.31974422595 },
        { 8108, 8, "08108 - L'Isly", "10-12 Rue De L'Isly -", "10-12 Rue De L'Isly - 75008 Paris", 48.874746791, 2.32522392363 },
        { 20103, 10, "20103 - Le Vau Berteaux", "24 Rue Le Vau -", "24 Rue Le Vau - 75020 Paris", 48.8679390444, 2.4111598961 },
        { 20109, 10, "20109 - Surmelin Haxo", "2 Rue Haxo -", "2 Rue Haxo - 75020 Paris", 48.8694883102, 2.40538574392 },
        { 17044, 1, "17044 - Porte De Saint Ouen", "1 Avenue De La Porte De Saint Ouen -", "1 Avenue De La Porte De Saint Ouen - 75017 Paris", 48.8978801918, 2.32883075538 },
        { 17108, 10, "17108 - Bessieres", "102 Boulevard Bessieres -", "102 Boulevard Bessieres - 75017 Paris", 48.8960904448, 2.3176949446 },
        { 9108, 1, "09108 - Rochechouart Maubeuge", "25 Rue De Rochechouart -", "25 Rue De Rochechouart - 75009 Paris", 48.8780814394, 2.34485784724 },
        { 13118, 10, "13118 - Patay Regnault", "36-38 Rue Regnault -", "36-38 Rue Regnault - 75013 Paris", 48.824393174, 2.37610232543 },
        { 20115, 10, "20115 - Porte De Bagnolet", "102 Rue Louis Lumiere -", "102 Rue Louis Lumiere - 75020 Paris", 48.8645962094, 2.41040591041 },
        { 13110, 10, "13110 - Moulin De La Pointe", "66 Rue Du Moulin De La Pointe -", "66 Rue Du Moulin De La Pointe - 75013 Paris", 48.8209377361, 2.3562824974 },
        { 14112, 10, "14112 - Faubourg Saint Jacques Cassini", "24 Rue Mechain -", "24 Rue Mechain - 75014 Paris", 48.8358407557, 2.33831662349 },
        { 14125, 10, "14125 - Dareau", "34 Rue Dareau -", "34 Rue Dareau - 75014 Paris", 48.8307627596, 2.33609754841 },
        { 10105, 2, "10105 - Bonne Nouvelle Prop2", "2 Rue De Mazagran -", "2 Rue De Mazagran - 75010 Paris", 48.8701450798, 2.35116443724 },
        { 19103, 10, "19103 - Manin Carrieres", "139 Rue Manin -", "139 Rue Manin - 75019 Paris", 48.884566905, 2.39196889431 },
        { 19110, 10, "19110 - Macdonald Duchesne", "1 Rue Jacques Duchesne -", "1 Rue Jacques Duchesne - 75019 Paris", 48.8988993528, 2.3740180789 },
        { 20118, 10, "20118 - Orteaux Mouraud", "100 Rue Des Orteaux -", "100 Rue Des Orteaux - 75020 Paris", 48.8555830317, 2.40843194099 },
        { 14001, 10, "14001 - Edgar Quinet", "13 Boulevard Edgar Quinet -", "13 Boulevard Edgar Quinet - 75014 Paris", 48.8410528634, 2.32448285507 },
        { 20116, 10, "20116 - Haies Reunion", "53 Rue Des Haies -", "53 Rue Des Haies - 75020 Paris", 48.8538699275, 2.40231448446 },
        { 13101, 10, "13101 - Croulebarbe Reculettes", "67-69 Rue De Croulebarbe -", "67-69 Rue De Croulebarbe - 75013 Paris", 48.830932982, 2.34867629255 },
        { 20121, 10, "20121 - Menilmontant Boyer", "27 Rue Boyer -", "27 Rue Boyer - 75020 Paris", 48.8689020138, 2.39207497406 },
        { 8030, 8, "08030 - Montaigne", "25 Rue Bayard -", "25 Rue Bayard - 75008 Paris", 48.8672932027, 2.30755673886 },
        { 20122, 10, "20122 - Davout Vitruve", "98 Rue Vitruve -", "98 Rue Vitruve - 75020 Paris", 48.8604089654, 2.40895616667 },
        { 8103, 8, "08103 - D'Artois Berry", "31 Rue D'Artois -", "31 Rue D'Artois - 75008 Paris", 48.8737547707, 2.30628594927 },
        { 9023, 1, "09023 - Italiens Laffite", "1 Rue Laffite -", "1 Rue Laffite - 75009 Paris", 48.8716557629, 2.3370775691 },
        { 14025, 10, "14025 - Jacquier", "10 Rue Jacquier -", "10 Rue Jacquier - 75014 Paris", 48.8296018387, 2.31821007331 },
        { 15118, 6, "15118 - Place Bienvenue", "11 Rue De L'Arrivee -", "11 Rue De L'Arrivee - 75015 Paris", 48.8433174897, 2.32246703883 },
        { 8102, 8, "08102 - Lamenais Washington", "1 Rue Lamennais -", "1 Rue Lamennais - 75008 Paris", 48.8735113044, 2.30331594406 },
        { 11017, 10, "11017 - Alexandre Dumas", "Face 77 Boulevard De Charonne -", "Face 77 Boulevard De Charonne - 75011 Paris", 48.854124914, 2.39588642161 },
        { 11021, 10, "11021 - Philippe Auguste (20Eme Arr.)", "212 Boulevard Charonne -", "212 Boulevard Charonne - 75011 Paris", 48.8583875997, 2.39025232338 },
        { 11029, 10, "11029 - Menilmontant Oberkampf", "137 Boulevard Menilmontant -", "137 Boulevard Menilmontant - 75011 Paris", 48.8667399494, 2.38285007514 },
        { 11112, 10, "11112 - Charonnes Valles", "22 Rue Jules Valles -", "22 Rue Jules Valles - 75011 Paris", 48.8543365016, 2.38496381432 },
        { 12037, 10, "12037 - Daumesnil", "53 Boulevard De Reuilly -", "53 Boulevard De Reuilly - 75012 Paris", 48.8397262595, 2.39723171659 },
        { 12112, 10, "12112 - Charenton Jardinier", "311-313 Rue De Charenton -", "311-313 Rue De Charenton - 75012 Paris", 48.8338136183, 2.39482879631 },
        { 12115, 10, "12115 - Porte De Vincennes", "22 Avenue De La Porte De Vincennes -", "22 Avenue De La Porte De Vincennes - 75012 Paris", 48.8463125254, 2.41547303683 },
        { 13111, 10, "13111 - Cimetiere De Gentilly", "Rue De La Poterne Des Peupliers -", "Rue De La Poterne Des Peupliers - 75013 Paris", 48.8185744158, 2.35326018374 },
        { 13114, 10, "13114 - Nationale Duchamp (Prop 1)", "46 Rue Nationale -", "46 Rue Nationale - 75013 Paris", 48.8248090269, 2.36779946405 },
        { 13116, 10, "13116 - Place Du Docteur Yersin", "Face 5 Avenue De La Porte D'Ivry -", "Face 5 Avenue De La Porte D'Ivry - 75013 Paris", 48.8201342441, 2.37212486201 },
        { 13117, 10, "13117 - Stade Georges Carpentier", "95-97 Boulevard Massena -", "95-97 Boulevard Massena - 75013 Paris", 48.820387477, 2.36624525352 },
        { 14101, 6, "14101 - Place Fernand Mourlot", "33 Bd Edgar Quinet -", "33 Bd Edgar Quinet - 75014 Paris", 48.8417177219, 2.32257642432 },
        { 14110, 10, "14110 - Abbe Carton", "89 Rue De L'Abbe Carton -", "89 Rue De L'Abbe Carton - 75014 Paris", 48.8277238047, 2.32076991659 },
        { 15028, 10, "15028 - Dupleix", "54 Boulevard De Grenelle -", "54 Boulevard De Grenelle - 75015 Paris", 48.8513174337, 2.29137323325 },
        { 15103, 10, "15103 - Square Des Cvennes", "103 Rue Cauchy -", "103 Rue Cauchy - 75015 Paris", 48.8433022914, 2.27529910233 },
        { 20110, 10, "20110 - Porte Des Lilas", "Face 241 Avenue Gambetta -", "Face 241 Avenue Gambetta - 75020 Paris", 48.8752489128, 2.40585656443 },
        { 14014, 10, "14014 - Stade Charlety", "5 Boulevard Jourdan -", "5 Boulevard Jourdan - 75014 Paris", 48.8192763426, 2.34399178163 },
        { 14106, 10, "14106 - Stade Didot", "Face 58 Avenue Marc Sangnier -", "Face 58 Avenue Marc Sangnier - 75014 Paris", 48.8253761398, 2.31039838959 },
        { 14109, 10, "14109 - Tombe Issoire Regnault", "132 Rue De La Tombe Issoire -", "132 Rue De La Tombe Issoire - 75014 Paris", 48.8244712554, 2.33108859444 },
        { 14111, 10, "14111 - Denfert-Rochereau Cassini", "18 Rue Cassini -", "18 Rue Cassini - 75014 Paris", 48.8375573809, 2.33597486121 },
        { 15110, 10, "15110 - Place Robert Guillemard", "Place Robert Guillemard -", "Place Robert Guillemard - 75015 Paris", 48.8360252045, 2.2810123522 },
        { 15111, 10, "15111 - Serres", "48 Rue Olivier De Serres -", "48 Rue Olivier De Serres - 75015 Paris", 48.8347369869, 2.29559473249 },
        { 15114, 10, "15114 - Pasteur Cotentin", "Face 1 Rue Du Cotentin -", "Face 1 Rue Du Cotentin - 75015 Paris", 48.8389036889, 2.3163549573 },
        { 17104, 10, "17104 - General Koenig", "Boulevard Aurelle De Paladines -", "Boulevard Aurelle De Paladines - 75017 Paris", 48.8818531828, 2.28346995276 },
        { 17117, 10, "17117 - Pereire Saussure", "2 Bis Boulevard Pereire -", "2 Bis Boulevard Pereire - 75017 Paris", 48.8881892151, 2.31002513586 },
        { 18039, 10, "18039 - Eole", "41 Rue D'Aubervilliers -", "41 Rue D'Aubervilliers - 75018 Paris", 48.8869394344, 2.36682760078 },
        { 19112, 10, "19112 - Stade Ladoumegue", "Avenue De La Porte De Pantin -", "Avenue De La Porte De Pantin - 75019 Paris", 48.890136646, 2.39682666867 },
        { 18028, 1, "18028 - Vauvenargues", "195 Rue Championnet -", "195 Rue Championnet - 75018 Paris", 48.8939619908, 2.33227976179 },
        { 10111, 10, "10111 - Bourse Du Travail", "100 Quai De Jemmapes -", "100 Quai De Jemmapes - 75010 Paris", 48.8734142291, 2.36420397819 },
        { 19113, 10, "19113 - Pre St Gervais", "27 Rue Du Pre Saint Gervais -", "27 Rue Du Pre Saint Gervais - 75019 Paris", 48.8778785915, 2.39574977833 },
        { 9012, 1, "09012 - Rougemont", "3-5 Rue Rougemont -", "3-5 Rue Rougemont - 75009 Paris", 48.8713319266, 2.34560617569 },
        { 19114, 10, "19114 - Manin Secretan", "31 Rue Manin -", "31 Rue Manin - 75019 Paris", 48.8790451878, 2.37844607432 },
        { 19118, 10, "19118 - Bolivar Burnouf", "82 Avenue Simon Bolivar -", "82 Avenue Simon Bolivar - 75019 Paris", 48.8769884744, 2.37426142432 },
        { 20006, 10, "20006 - Pyrnes - Plaine", "33 Rue Des Pyrenees -", "33 Rue Des Pyrenees - 75020 Paris", 48.8502187788, 2.4062864864 },
        { 20111, 10, "20111 - L'Isle Adam Pyrenes", "60 Rue Villiers De L'Isle Adam -", "60 Rue Villiers De L'Isle Adam - 75020 Paris", 48.8671834192, 2.39628262825 },
        { 12025, 10, "12025 - Bercy", "Face 14 Pl. Du Bataillon Du Pacifique -", "Face 14 Pl. Du Bataillon Du Pacifique - 75012 Paris", 48.8401112109, 2.37988566453 },
        { 14104, 10, "14104 - Losserand Boyer-Barret", "4 Rue Boyer Barret -", "4 Rue Boyer Barret - 75014 Paris", 48.8331967149, 2.31717409323 },
        { 12101, 10, "12101 - Charenton Prague", "89 Ter Rue De Charenton -", "89 Ter Rue De Charenton - 75012 Paris", 48.8481203487, 2.37622903831 },
        { 15112, 10, "15112 - Falguire Lebrun", "19 Rue Vigee Lebrun -", "19 Rue Vigee Lebrun - 75015 Paris", 48.838633089, 2.31139906635 },
        { 12102, 10, "12102 - Diderot Bercy", "224 Rue De Bercy -", "224 Rue De Bercy - 75012 Paris", 48.8461808171, 2.37038573088 },
        { 13120, 10, "13120 - Vitry Desault", "Rue Pierre Et Joseph Desault -", "Rue Pierre Et Joseph Desault - 75013 Paris", 48.8211566955, 2.37880845223 },
        { 1008, 1, "01008 - Les Halles Saint Eustache", "Allee Andre Breton -", "Allee Andre Breton - 75001 Paris", 48.8627939322, 2.34568653079 },
        { 4105, 4, "04105 - Morland", "17 Boulevard Du Morland -", "17 Boulevard Du Morland - 75004 Paris", 48.849930365, 2.36329296542 },
        { 8549, 8, "08549 - Place Dunant", "39 Avenue George V -", "39 Avenue George V - 75008 Paris", 48.8702033421, 2.30117919221 },
        { 10024, 10, "10024 - Buisson Saint Louis", "2 Rue Du Buisson Saint Louis -", "2 Rue Du Buisson Saint Louis - 75010 Paris", 48.8717045499, 2.37224129046 },
        { 16037, 10, "16037 - Molitor - Michel Ange", "35 Rue Molitor -", "35 Rue Molitor - 75016 Paris", 48.8451011699, 2.26207476292 },
        { 16041, 10, "16041 - Versailles", "164 Avenue De Versailles -", "164 Avenue De Versailles - 75016 Paris", 48.8402129653, 2.26370212687 },
        { 17110, 10, "17110 - Legendre", "83 Rue Legendre -", "83 Rue Legendre - 75017 Paris", 48.8877956943, 2.32038284936 },
        { 17114, 10, "17114 - Porte De Clichy", "15 Avenue De La Porte De Clichy -", "15 Avenue De La Porte De Clichy - 75017 Paris", 48.8952894715, 2.31177971013 },
        { 17116, 10, "17116 - Reims", "6 Boulevard De Reims -", "6 Boulevard De Reims - 75017 Paris", 48.8917993846, 2.30010107113 },
        { 18109, 10, "18109 - Riquet Pajol", "55 Rue Pajol -", "55 Rue Pajol - 75018 Paris", 48.8896005666, 2.36284951741 },
        { 19119, 10, "19119 - Bouret Pailleron", "20 Rue Edouard Pailleron -", "20 Rue Edouard Pailleron - 75019 Paris", 48.880528882, 2.37607626156 },
        { 20009, 10, "20009 - Docteur Dejerine", "Rue Des Docteurs Dejerine -", "Rue Des Docteurs Dejerine - 75020 Paris", 48.8538640645, 2.41228386882 },
        { 20031, 10, "20031 - Duris", "33 Rue Duris -", "33 Rue Duris - 75020 Paris", 48.8655156094, 2.38794379295 },
        { 20112, 10, "20112 - Jourdain", "3 Rue Du Jourdain -", "3 Rue Du Jourdain - 75020 Paris", 48.8739450168, 2.3896006183 },
        { 8104, 8, "08104 - Friedland Chateaubriand", "27/31 Rue De Chateaubriand -", "27/31 Rue De Chateaubriand - 75008 Paris", 48.874076426, 2.2997186552 },
        { 12114, 10, "12114 - Porte De Saint Mande", "33 Avenue Courteline -", "33 Avenue Courteline - 75012 Paris", 48.8439762087, 2.4148022913 },
        { 11013, 10, "11013 - Nation Volaire", "5 Place De La Nation -", "5 Place De La Nation - 75011 Paris", 48.8493350865, 2.39487326086 },
        { 11014, 10, "11014 - Nation Trone", "Face 21 Place De La Nation -", "Face 21 Place De La Nation - 75011 Paris", 48.8485699664, 2.39726917825 },
        { 14116, 10, "14116 - Romain Rolland", "49-51 Bd Romain Rolland -", "49-51 Bd Romain Rolland - 75014 Paris", 48.8202284122, 2.32330386036 },
        { 14122, 10, "14122 - Brune", "1 Rue Du Colonel Monteil -", "1 Rue Du Colonel Monteil - 75014 Paris", 48.8263555308, 2.30925446105 },
        { 14115, 10, "14115 - Cit Universitaire", "Avenue Maurice D'Ocagne -", "Avenue Maurice D'Ocagne - 75014 Paris", 48.8237685839, 2.31659244699 },
        { 2108, 1, "02108 - Vivienne", "42 Rue Vivienne -", "42 Rue Vivienne - 75002 Paris", 48.8715208821, 2.34136913587 },
        { 7013, 7, "07013 - Place De Breteuil", "17 Rue Duroc -", "17 Rue Duroc - 75007 Paris", 48.8473871676, 2.31244326488 },
        { 10040, 10, "10040 - Belleville", "8 Boulevard De La Vilette -", "8 Boulevard De La Vilette - 75010 Paris", 48.8730154367, 2.37630225056 },
        { 15022, 10, "15022 - Zola", "2 Rue Fremicourt -", "2 Rue Fremicourt - 75015 Paris", 48.8469332058, 2.29592537736 },
        { 15035, 10, "15035 - Place Etienne Pernet", "2 Rue Des Freres Morane -", "2 Rue Des Freres Morane - 75015 Paris", 48.842411172, 2.29230702329 },
        { 17119, 10, "17119 - Toqueville", "64 Rue De Toqueville -", "64 Rue De Toqueville - 75017 Paris", 48.8849180627, 2.31088538932 },
        { 19120, 10, "19120 - Alouettes", "20 Rue Carducci -", "20 Rue Carducci - 75019 Paris", 48.8775146085, 2.3857345528 },
        { 9101, 1, "09101 - Cadet La Fayette", "24-26 Rue Cadet -", "24-26 Rue Cadet - 75009 Paris", 48.8754212891, 2.3433587021 },
        { 14124, 10, "14124 - Porte D'Arcueil", "Avenue David Weil -", "Avenue David Weil - 75014 Paris", 48.8210470591, 2.33378393368 },
        { 2014, 1, "02014 - Saint Augustin", "1, 3 Rue Daunou -", "1, 3 Rue Daunou - 75002 Paris", 48.869202131, 2.33260909867 },
        { 2107, 1, "02107 - Thorel", "11 Rue Thorel -", "11 Rue Thorel - 75002 Paris", 48.8699026482, 2.34906633856 },
        { 13103, 5, "13103 - Saint Marcel", "89 Boulevard De L'Hopital -", "89 Boulevard De L'Hopital - 75013 Paris", 48.8385257096, 2.36083647727 },
        { 18042, 1, "18042 - Pigalle Germain Pillon", "Face 36 Boulevard De Clichy -", "Face 36 Boulevard De Clichy - 75018 Paris", 48.8826831562, 2.33651882661 },
        { 18113, 1, "18113 - Lepic", "70, 72 Rue Lepic -", "70, 72 Rue Lepic - 75018 Paris", 48.8875452017, 2.33398390654 },
        { 15014, 10, "15014 - Volontaires", "25 Rue Des Volontaires -", "25 Rue Des Volontaires - 75015 Paris", 48.843503205, 2.30661719061 },
        { 2101, 1, "02101 - Bachaumont", "14 Rue Bachaumont -", "14 Rue Bachaumont - 75002 Paris", 48.8661552666, 2.34485609823 },
        { 9113, 1, "09113 - Bleue", "5 Rue Bleue -", "5 Rue Bleue - 75009 Paris", 48.8758164701, 2.34721466579 },
        { 17115, 1, "17115 - Porte De Saint Ouen", "22 Avenue De La Porte De Saint Ouen -", "22 Avenue De La Porte De Saint Ouen - 75017 Paris", 48.8988238906, 2.3295803179 },
        { 18018, 1, "18018 - Carpeaux", "13 Rue Carpeaux -", "13 Rue Carpeaux - 75018 Paris", 48.8908164115, 2.3308217508 },
        { 18104, 10, "18104 - Chapelle", "2 Impasse De La Chapelle -", "2 Impasse De La Chapelle - 75018 Paris", 48.8919647522, 2.36011117665 },
        { 19102, 10, "19102 - Belleville Rampal", "4 Rue De Rampal -", "4 Rue De Rampal - 75019 Paris", 48.8730501675, 2.37985825133 },
        { 15113, 10, "15113 - Falguiere Arsonval", "2 Rue D'Arsonval -", "2 Rue D'Arsonval - 75015 Paris", 48.8403680642, 2.31319549263 },
        { 19117, 10, "19117 - Euryale Dehaynin", "22 Rue Euryale Dehaynin -", "22 Rue Euryale Dehaynin - 75019 Paris", 48.8863611962, 2.37729351502 },
        { 19030, 10, "19030 - Moselle Jaures", "6 Passage De Melun -", "6 Passage De Melun - 75019 Paris", 48.8840428364, 2.37625604844 },
        { 15120, 10, "15120 - Avia", "26 Rue Du Colonel Pierre Avia -", "26 Rue Du Colonel Pierre Avia - 75015 Paris", 48.8292544371, 2.27479858264 },
        { 15123, 7, "15123 - Rue Du Commerce", "20 Rue Du Commerce -", "20 Rue Du Commerce - 75015 Paris", 48.8479490228, 2.29659184177 },
        { 18122, 1, "18122 - Binet", "5 Rue Binet -", "5 Rue Binet - 75018 Paris", 48.899147556, 2.3425572517 },
        { 19006, 10, "19006 - Mathis", "6 Rue Mathis -", "6 Rue Mathis - 75019 Paris", 48.8907745793, 2.37525256212 },
        { 12107, 10, "12107 - Diderot Bourdan", "146 Boulevard Diderot -", "146 Boulevard Diderot - 75012 Paris", 48.8474139136, 2.39024111157 },
        { 16103, 10, "16103 - Traktir", "3 Rue Traktir -", "3 Rue Traktir - 75016 Paris", 48.8728242822, 2.29140869939 },
        { 5110, 5, "05110 - Lacepede", "27 Rue Lacepede -", "27 Rue Lacepede - 75005 Paris", 48.8437938517, 2.35185182457 },
        { 6002, 6, "06002 - Saint Pres", "1 Rue Saint Benoit -", "1 Rue Saint Benoit - 75006 Paris", 48.8555862579, 2.3332640699 },
        { 8113, 8, "08113 - Place St Augustin", "5 Place Saint Augustin -", "5 Place Saint Augustin - 75008 Paris", 48.8749437822, 2.31940603719 },
        { 9031, 1, "09031 - Provence", "69 Rue De Provence -", "69 Rue De Provence - 75009 Paris", 48.8742170759, 2.33312638914 },
        { 10036, 10, "10036 - Aqueduc", "80 Rue De L'Aqueduc -", "80 Rue De L'Aqueduc - 75010 Paris", 48.8835872005, 2.36682568822 },
        { 10115, 10, "10115 - Dodu", "1, 3 Rue Des Ecluses Saint Martin -", "1, 3 Rue Des Ecluses Saint Martin - 75010 Paris", 48.8764780229, 2.36782990699 },
        { 16104, 10, "16104 - Paul Valry", "26-32 Rue Paul Valery -", "26-32 Rue Paul Valery - 75016 Paris", 48.8713763, 2.28882142265 },
        { 16105, 10, "16105 - Crevaux", "1 Rue Crevaux -", "1 Rue Crevaux - 75016 Paris", 48.8706270257, 2.28123367255 },
        { 16107, 10, "16107 - Godard", "2 Rue Benjamin Godard -", "2 Rue Benjamin Godard - 75016 Paris", 48.8658699911, 2.27570806081 },
        { 16108, 10, "16108 - Sablons", "40 Rue Des Sablons -", "40 Rue Des Sablons - 75016 Paris", 48.8637697583, 2.28141816613 },
        { 16110, 10, "16110 - Octave Feuillet", "4, 6 Rue Octave Feuillet -", "4, 6 Rue Octave Feuillet - 75016 Paris", 48.8610064533, 2.27312579288 },
        { 16111, 10, "16111 - Helie", "4,6 Rue Faustin Helie -", "4,6 Rue Faustin Helie - 75016 Paris", 48.8592557495, 2.27664212461 },
        { 16116, 10, "16116 - Georges Sand", "23 Rue Georges Sand -", "23 Rue Georges Sand - 75016 Paris", 48.8499130801, 2.26800538967 },
        { 17102, 10, "17102 - Alfred Roll", "14 Rue Alfred Roll -", "14 Rue Alfred Roll - 75017 Paris", 48.8879618215, 2.29999479512 },
        { 17111, 10, "17111 - Lemercier", "109 Rue Lemercier -", "109 Rue Lemercier - 75017 Paris", 48.8898712835, 2.31743834345 },
        { 18112, 1, "18112 - Hpital Bichat", "2 Rue Arthur Ranc -", "2 Rue Arthur Ranc - 75018 Paris", 48.8978714307, 2.33312450532 },
        { 20024, 10, "20024 - Gambetta - Pre Lachaise", "11 Rue Malte Brun -", "11 Rue Malte Brun - 75020 Paris", 48.8643873192, 2.39832276785 },
        { 20029, 10, "20029 - Porte Des Lilas", "57 Rue Des Freres Flavien -", "57 Rue Des Freres Flavien - 75020 Paris", 48.8782118664, 2.41064313557 },
        { 20119, 10, "20119 - Square De Menilmontant", "138 Rue De Menilmontant -", "138 Rue De Menilmontant - 75020 Paris", 48.8698524025, 2.39680336302 },
        { 20120, 10, "20120 - Noisy Le Sec", "1 Rue Evariste Galois -", "1 Rue Evariste Galois - 75020 Paris", 48.873096667, 2.41292480095 },
        { 20503, 10, "20503 - Cours De Vincennes Pyrnes", "1 Rue Des Pyrenees -", "1 Rue Des Pyrenees - 75020 Paris", 48.8479539486, 2.40625623667 },
        { 12109, 10, "12109 - Charolais", "212 Rue De Charenton -", "212 Rue De Charenton - 75012 Paris", 48.8407823718, 2.38734775686 },
        { 20043, 10, "20043 - Charonne Avron", "48 Boulevard De Charonne -", "48 Boulevard De Charonne - 75011 Paris", 48.8514093507, 2.39856624404 },
        { 20105, 10, "20105 - Gaumont", "Avenue Benoit Frachon -", "Avenue Benoit Frachon - 75020 Paris", 48.8528015574, 2.41537386972 },
        { 12113, 10, "12113 - Cardinal Lavigerie", "4 Place Du Cardinal Lavigerie -", "4 Place Du Cardinal Lavigerie - 75012 Paris", 48.8322900599, 2.40375770864 },
        { 16112, 10, "16112 - Chernovitz", "1-3 Rue Chernovitz -", "1-3 Rue Chernovitz - 75016 Paris", 48.8569038001, 2.28232448992 },
        { 19019, 10, "19019 - Petit Honneger", "124 Rue Petit -", "124 Rue Petit - 75019 Paris", 48.8862826439, 2.393728705 },
        { 14127, 6, "14127 - Odessa", "5-7 Rue D'Odessa -", "5-7 Rue D'Odessa - 75014 Paris", 48.8430660529, 2.3243053444 },
        { 20034, 10, "20034 - Sorbier - Mnilmontant", "1 Rue Sorbier -", "1 Rue Sorbier - 75020 Paris", 48.8661788339, 2.39209934028 },
        { 15003, 10, "15003 - Gare De Montparnasse", "Tp Du 1-13 Boulevard De Vaugirard -", "Tp Du 1-13 Boulevard De Vaugirard - 75015 Paris", 48.8414924469, 2.31840995086 },
        { 10161, 10, "10161 - Gare De L'Est", "Face 129 Rue Du Fbg Saint Martin -", "Face 129 Rue Du Fbg Saint Martin - 75010 Paris", 48.8758327142, 2.35987243649 },
        { 15115, 10, "15115 - Vaugirard", "25-31 Boulevard De Vaugirard -", "25-31 Boulevard De Vaugirard - 75015 Paris", 48.8414024796, 2.31783810687 },
        { 8115, 8, "08115 - Bassano", "10 Rue Vernet -", "10 Rue Vernet - 75008 Paris", 48.8712456008, 2.30029291037 },
        { 13104, 10, "13104 - Gare D'Austerlitz", "Face 109 Quai D'Austerlitz -", "Face 109 Quai D'Austerlitz - 75013 Paris", 48.8440970503, 2.36516915835 },
        { 16115, 10, "16115 - Raffet", "52 Rue Raffet -", "52 Rue Raffet - 75016 Paris", 48.8525251499, 2.26256790699 },
        { 19106, 10, "19106 - Gare Emgp", "35 Rue De La Gare -", "35 Rue De La Gare - 75019 Paris", 48.9017487117, 2.37254784787 },
        { 16101, 10, "16101 - Malakoff", "161 Avenue Malakoff -", "161 Avenue Malakoff - 75016 Paris", 48.8768108432, 2.28241240157 },
        { 16102, 10, "16102 - Pergolse/ Marbeau", "52-54 Rue Pergolse -", "52-54 Rue Pergolse - 75016 Paris", 48.8736737837, 2.28135300187 },
        { 10153, 10, "10153 - Gare Du Nord 3", "7 Boulevard De Denain -", "7 Boulevard De Denain - 75010 Paris", 48.8790331115, 2.35431442701 },
        { 18102, 10, "18102 - Rue De La Chapelle", "69 Bis Rue De La Chapelle -", "69 Bis Rue De La Chapelle - 75018 Paris", 48.895532806, 2.35930856074 },
        { 19018, 10, "19018 - Cit De La Musique Version 2", "Face 210 Avenue Jean Jaures -", "Face 210 Avenue Jean Jaures - 75019 Paris", 48.8886558027, 2.3925864945 },
        { 10032, 10, "10032 - Dodu", "N 12-14 Rue Claude Vellefaux-", "N 12-14 Rue Claude Vellefaux- 75010 Paris", 48.8727297356, 2.37002121502 },
        { 15006, 10, "15006 - Cherche Midi", "Face Au 138 Rue Du Cherche Midi -", "Face Au 138 Rue Du Cherche Midi - 75015 Paris", 48.8444222659, 2.31768719079 },
        { 15109, 10, "15109 - Cevennes", "65 - 67 Rue Des Cevennes -", "65 - 67 Rue Des Cevennes - 75015 Paris", 48.8425859334, 2.28061036359 },
        { 18107, 10, "18107 - Chartres", "22-24 Rue De Chartres -", "22-24 Rue De Chartres - 75018 Paris", 48.8846771647, 2.35388020539 },
        { 10151, 10, "10151 - Gare Du Nord 1", "8-10 Rue De Dunkerque -", "8-10 Rue De Dunkerque - 75010 Paris", 48.8793831618, 2.35723052477 },
        { 10152, 10, "10152 - Gare Du Nord 2", "3 Boulevard De Denain -", "3 Boulevard De Denain - 75010 Paris", 48.8787814836, 2.35420533677 },
        { 18105, 10, "18105 - Beliard Poissonniers", "157 Bis-159 Rue Des Poissonniers -", "157 Bis-159 Rue Des Poissonniers - 75018 Paris", 48.8975110288, 2.35260302286 },
        { 17109, 10, "17109 - Bois Le Prtre", "22 Bd De Bois Le Pretre -", "22 Bd De Bois Le Pretre - 75017 Paris", 48.8996404772, 2.3184160696 },
        { 12023, 10, "12023 - Sahel", "15 Avenue Emile Laurent -", "15 Avenue Emile Laurent - 75012 Paris", 48.8407251859, 2.41091688909 },
        { 12120, 10, "12120 - Conservation", "Route De La Ceinture Du Lac Daumesnil -", "Route De La Ceinture Du Lac Daumesnil - 75012 Paris", 48.827786961, 2.41869851141 },
        { 12124, 10, "12124 - Pyramide Artillerie", "Route De L'Artillerie -", "Route De L'Artillerie - 75012 Paris", 48.8393749069, 2.43833676447 },
        { 12125, 10, "12125 - Pyramide Entre Parc Floral", "Pyramide Entree Parc Floral -", "Pyramide Entree Parc Floral - 75012 Paris", 48.8369193275, 2.44063290626 },
        { 18043, 1, "18043 - Blanche", "55 Boulevard De Clichy -", "55 Boulevard De Clichy - 75018 Paris", 48.8834829503, 2.33309839711 },
        { 20132, 10, "20132 - Reunion", "4 Rue De La Reunion -", "4 Rue De La Reunion - 75020 Paris", 48.8525029075, 2.40398791037 },
        { 12119, 10, "12119 - Dom Prignon Gravelle", "Route Dom Perignon -", "Route Dom Perignon - 75012 Paris", 48.8252940617, 2.40994215321 },
        { 12123, 10, "12123 - Chateau De Vincennes", "Cours Des Marechaux -", "Cours Des Marechaux - 94300 Vincennes", 48.8442279085, 2.4386594085 },
        { 12126, 10, "12126 - Avenue De Gravelle", "Face 71 Avenue De Gravelle -", "Face 71 Avenue De Gravelle - 75012 Paris", 48.8247154202, 2.41535881484 },
        { 903, 10, "00903 - Station Mobile 3", "Fete De L'Oh (Bercy) - Quai Mauriac Ang Pont De Bercy", "Fete De L'Oh (Bercy) - Quai Mauriac Ang Pont De Bercy  ", 48.8332091703, 2.3786955789 },
        { 8110, 8, "08110 - Stockolm Rome", "6 Rue De Stockolm -", "6 Rue De Stockolm - 75008 Paris", 48.8772269686, 2.3224301166 },
        { 20133, 10, "20133 - Rasselins", "2 Rue Des Rasselins -", "2 Rue Des Rasselins - 75020 Paris", 48.8532634907, 2.40972258471 },
        { 905, 10, "00905 - Gare De Bercy (Station Mobile 5)", "Gare De Bercy - Angle Rue Corbineau -", "Gare De Bercy - Angle Rue Corbineau - 75012 Paris", 48.8386725498, 2.3816680993 },
        { 906, 10, "00906 - Station Mobile 6", "Garde De L'Est-Parvis Gare De L'Est -", "Garde De L'Est-Parvis Gare De L'Est - 75010 Paris", 48.8763094063, 2.35785610318 },
        { 17012, 10, "17012 - Mairie Du 17Eme", "Face 16 Rue Des Batignolles -", "Face 16 Rue Des Batignolles - 75017 Paris", 48.8841111814, 2.32222373801 },
        { 20131, 10, "20131 - Repos", "41 Rue Du Repos -", "41 Rue Du Repos - 75020 Paris", 48.8593585236, 2.38961313668 },
        { 15023, 7, "15023 - La Motte Piquet", "146 Boulevard Grenelle -", "146 Boulevard Grenelle - 75015 Paris", 48.848938207, 2.29826609151 },
        { 14021, 10, "14021 - Place De La Porte De Chatillon", "Boulevard Brune Porte De Chatillon -", "Boulevard Brune Porte De Chatillon - 75014 Paris", 48.8244699418, 2.31852502472 },
        { 12041, 10, "12041 - Bois De Vincennes", "Avenue Daumesnil -", "Avenue Daumesnil - 75012 Paris", 48.8336146416, 2.41309866026 },
        { 16129, 10, "16129 - Bois De Boulogne / Porte De La Muette 1", "Chemin De La Ceinture Du Lac Interieur / Avenue De Saint Cloud -", "Chemin De La Ceinture Du Lac Interieur / Avenue De Saint Cloud - 75016 Paris", 48.8587150228, 2.25871796637 },
        { 16130, 10, "16130 - Bois De Boulogne / Porte De La Muette 2", "Avenue Louis Barthou / Place De La Colombie -", "Avenue Louis Barthou / Place De La Colombie - 75016 Paris", 48.8636995083, 2.26749658897 },
        { 16122, 10, "16122 - Muette Neuilly", "Route De La Muette A Neuilly -", "Route De La Muette A Neuilly - 75016 Paris", 48.8798261575, 2.25850884355 },
        { 16121, 10, "16121 - Sablons Maillot", "Route Porte Des Sablons / Porte Maillot -", "Route Porte Des Sablons / Porte Maillot - 75016 Paris", 48.878665034, 2.27032426541 },
        { 14126, 10, "14126 - Vaillant Couturier", "155 Avenue Paul Vaillant Couturier -", "155 Avenue Paul Vaillant Couturier - 75014 Paris", 48.8170924232, 2.3324640538 },
        { 16118, 10, "16118 - Michel Ange", "91 Rue Michel Ange -", "91 Rue Michel Ange - 75016 Paris", 48.840721974, 2.25856819649 },
        { 15107, 10, "15107 -  Palais Des Sports", "42 Boulevard Victor -", "42 Boulevard Victor - 75015 Paris", 48.8335736182, 2.28548042092 },
        { 19123, 10, "19123 - Quai De Metz", "7 Quai De Metz -", "7 Quai De Metz - 75000 Paris", 48.8912827336, 2.38649703868 },
        { 7003, 6, "7003 - Bon Marche", "Rue Velpeau -", "Rue Velpeau - 75007 Paris", 48.851154899, 2.32520215757 },
        { 13121, 10, "13121 - Ivry Bruneseau", "Rue Bruneseau -", "Rue Bruneseau - 75013 Paris", 48.8249276763, 2.38865279643 },
        { 19124, 10, "19124 - Alexander Flemming", "Rue Alexander Flemming -", "Rue Alexander Flemming - 75019 Paris", 48.8818651483, 2.40301733099 },
        { 21005, 10, "21005 - Morizet (Boulogne-Billancourt)", "20 Avenue Andre Morizet -", "20 Avenue Andre Morizet - 92100 Boulogne-Billancourt", 48.8350022335, 2.24134098998 },
        { 19125, 10, "19125 - Ledit De Nantes", "Place Ledit De Nantes -", "Place Ledit De Nantes - 75019 Paris", 48.8888142988, 2.37848109546 },
        { 33003, 10, "33003 - Faure (Aubervilliers)", "Angle Rue Bordier Et Boulevard Felix Faure  -", "Angle Rue Bordier Et Boulevard Felix Faure  - 93300 Aubervilliers", 48.9037212296, 2.38575907285 },
        { 21010, 10, "21010 - Silly (Boulogne-Billancourt)", "93 Rue De Silly -", "93 Rue De Silly - 92100 Boulogne-Billancourt", 48.8356327861, 2.23236779802 },
        { 21006, 10, "21006 - Paris (Boulogne-Billancourt)", "162 Rue De Paris -", "162 Rue De Paris - 92100 Boulogne-Billancourt", 48.8415658, 2.23375826837 },
        { 21004, 10, "21004 - Jaures 2 (Boulogne-Billancourt)", "55 Boulevard Jean Jaures -", "55 Boulevard Jean Jaures - 92100 Boulogne-Billancourt", 48.8405371556, 2.23958792325 },
        { 21008, 10, "21008 - Hugo (Boulogne-Billancourt)", "74 Avenue Victor Hugo -", "74 Avenue Victor Hugo - 92100 Boulogne-Billancourt", 48.8379988801, 2.24615524075 },
        { 21017, 10, "21017 - Republique 1 (Boulogne-Billancourt)", "91 Boulevard De La Republipque -", "91 Boulevard De La Republipque - 92100 Boulogne-Billancourt", 48.833503543, 2.24416186806 },
        { 21013, 10, "21013 - Grenier (Boulogne-Billancourt)", "4 Avenue Pierre Grenier -", "4 Avenue Pierre Grenier - 92100 Boulogne-Billancourt", 48.8255888038, 2.24857273189 },
        { 21015, 10, "21015 - Nationale (Boulogne-Billancourt)", "39 Rue Nationale -", "39 Rue Nationale - 92100 Boulogne-Billancourt", 48.827372113, 2.2418043025 },
        { 21018, 10, "21018 - Seine (Boulogne-Billancourt)", "Face Au 13 Rue De La Seine -", "Face Au 13 Rue De La Seine - 92100 Boulogne-Billancourt", 48.8283314391, 2.25047382158 },
        { 32601, 10, "32601 - Paris (Les Lilas)", "46 Rue De Paris -", "46 Rue De Paris - 93260 Les Lilas", 48.8786063737, 2.41214254177 },
        { 32606, 10, "32606 - Garde Chasse (Les Lilas)", "49 Rue Du Garde Chasse -", "49 Rue Du Garde Chasse - 93260 Les Lilas", 48.8825562324, 2.41904347331 },
        { 21009, 10, "21009 - Lecorbusier (Boulogne-Billancourt)", "Face Au 1 Rue Lecorbusier -", "Face Au 1 Rue Lecorbusier - 92100 Boulogne-Billancourt", 48.8374717043, 2.238749558 },
        { 33012, 0, "33012 - Landy (Aubervilliers)", "Face 2 Rue Du Landy -", "Face 2 Rue Du Landy - 93300 Aubervilliers", 48.9153628056, 2.37666142435 },
        { 21016, 10, "21016 - Point Du Jour (Boulogne-Billancourt)", "118 Rue Du Point Du Jour -", "118 Rue Du Point Du Jour - 92100 Boulogne Billancourt", 48.8288585167, 2.24619851221 },
        { 32602, 10, "32602 - Poulmarch (Les Lilas)", "7 Rue Jean Poulmarch -", "7 Rue Jean Poulmarch - 93200 Les Lilas", 48.8791518313, 2.41642190384 },
        { 21019, 10, "21019 - Vaillant (Boulogne-Billancourt)", "71 Avenue Edouard Vaillant -", "71 Avenue Edouard Vaillant - 92100 Boulogne-Billancourt", 48.8347644592, 2.24761765781 },
        { 21020, 10, "21020 - Republique 2 (Boulogne-Billancourt)", "28 Boulevard De La Republique -", "28 Boulevard De La Republique - 92100 Boulogne Billancourt", 48.8320542286, 2.25313587417 },
        { 21014, 10, "21014 - Hameau Fleuri (Boulogne-Billancourt)", "Face Au 12 Rue Du Hameau Fleurie -", "Face Au 12 Rue Du Hameau Fleurie - 92100 Boulogne Billancourt", 48.8313529176, 2.24091210371 },
        { 21002, 10, "21002 - Denfert Rochereau (Boulogne-Billancourt)", "Place Denfert Rochereau -", "Place Denfert Rochereau - 92100 Boulogne Billancourt", 48.8434722412, 2.24607754624 },
        { 21003, 10, "21003- Jaures 1 (Boulogne-Billancourt)", "2 Boulevard Jean Jaures -", "2 Boulevard Jean Jaures - 92100 Boulogne-Billancourt", 48.8458556422, 2.2370178597 },
        { 35012, 10, "35012 - Candale (Pantin)", "Face Au 12 Rue Candale -", "Face Au 12 Rue Candale - 93500 Pantin", 48.88940786, 2.41398439832 },
        { 35007, 10, "35007 - Delessert (Pantin)", "2 Rue  Benjamin Delessert -", "2 Rue  Benjamin Delessert - 93500 Pantin", 48.8939077304, 2.41808003428 },
        { 21001, 10, "21001 - Transval (Boulogne-Billancourt)", "11 Rue Du Transval -", "11 Rue Du Transval - 92100 Boulogne-Billancourt", 48.848113239, 2.2390970334 },
        { 32604, 10, "32604 - Kock (Les Lilas)", "Face 3 Avenue Paul De Kock -", "Face 3 Avenue Paul De Kock - 93200 Les Lilas", 48.8817731613, 2.42074557805 },
        { 21306, 10, "21306 - Lafayette (Issy Les Moulineaux)", "Place Lafayette -", "Place Lafayette - 92130 Issy Les Moulineaux", 48.8297787632, 2.26434311716 },
        { 21304, 10, "21304 - Blum (Issy Les Moulineaux)", "Face 2 Place Leon Blum -", "Face 2 Place Leon Blum - 92100 Issy Les Moulineaux", 48.8209147673, 2.26089844065 },
        { 21307, 10, "21307 - Cresson 1 (Issy Les Moulineaux)", "Face 36 Avenue Victor Cresson -", "Face 36 Avenue Victor Cresson - 92130 Issy Les Moulineaux", 48.8225102246, 2.26850473182 },
        { 21310, 10, "21310 - Kleber (Issy Les Moulineaux)", "4 Rue Kleber -", "4 Rue Kleber - 92130 Issy Les Moulineaux", 48.826853301, 2.27211984968 },
        { 21303, 10, "21303 - Iles (Issy Les Moulineaux)", "Angle Avenue Jean Monnet Et Boulevard Des Iles -", "Angle Avenue Jean Monnet Et Boulevard Des Iles - 92130 Issy Les Moulineaux", 48.823450547, 2.24966529829 },
        { 21012, 10, "21012 - Leclerc (Boulogne-Billancourt)", "745 Avenue Du General Leclerc -", "745 Avenue Du General Leclerc - 92100 Boulogne-Billancourt", 48.8305925264, 2.23441997851 },
        { 21309, 10, "21309 - Cresson 2 (Issy Les Moulineaux)", "1 Bis Avenue Victor Cresson -", "1 Bis Avenue Victor Cresson - 92130 Issy Les Moulineaux", 48.8236356899, 2.27206944197 },
        { 21311, 10, "21311 - Gambetta (Issy Les Moulineaux)", "Face Au 40 Boulevard Gambetta -", "Face Au 40 Boulevard Gambetta - 92130 Issy Les Moulineaux", 48.8273329344, 2.27843541209 },
        { 42501, 10, "42501 - Raspail 1 (Gentilly)", "80 Avenue Raspail -", "80 Avenue Raspail - 94250 Gentilly", 48.810540263, 2.34401786355 },
        { 42505, 10, "42505 - Frerot (Gentilly)", "37 Rue Charles Frerot -", "37 Rue Charles Frerot - 94250 Gentilly", 48.8157256622, 2.35037411763 },
        { 42503, 10, "42503 - Lenine (Gentilly)", "Face 71 Avenue Lenine -", "Face 71 Avenue Lenine - 94250 Gentilly", 48.8131557796, 2.33206976461 },
        { 16135, 10, "16135 - Stade Wilmille", "Rond Point Du Marechal Delatre De Tassigny -", "Rond Point Du Marechal Delatre De Tassigny - 75016 Paris", 48.8716393963, 2.27480202479 },
        { 43003, 10, "43003 - Paris 2 (Vincennes)", "104 Avenue De Paris -", "104 Avenue De Paris - 94300 Vincennes", 48.8456836968, 2.42774122403 },
        { 21305, 10, "21305 - Madaule (Issy Les Moulineaux)", "Place Madaule -", "Place Madaule - 92130 Issy Les Moulineaux", 48.8239344779, 2.26066260189 },
        { 43001, 10, "43001 - Paris 1 (Vincennes)", "168 Avenue De Paris -", "168 Avenue De Paris - 94300 Vincennes", 48.8463091285, 2.42048423707 },
        { 43002, 10, "43002 - Lagny (Vincennes)", "1 Bis Rue De Lagny -", "1 Bis Rue De Lagny - 94300 Vincennes", 48.8489474996, 2.42596294643 },
        { 43007, 10, "43007 - Vorges (Vincennes)", "4 Avenue Vorges -", "4 Avenue Vorges - 94300 Vincennes", 48.8481993458, 2.43987916591 },
        { 21301, 10, "21301 - Saint Vincent (Issy Les Moulineaux)", "21 Rue Saint Vincent -", "21 Rue Saint Vincent - 92130 Issy Les Moulineaux", 48.8194632174, 2.25413622608 },
        { 43010, 10, "43010 - Jarry (Vincennes)", "139 Rue De La Jarry -", "139 Rue De La Jarry - 94300 Vincennes", 48.849833478, 2.45149884039 },
        { 21302, 10, "21302 - Briand (Issy Les Moulineaux)", "Place De La Resistance Angle Rue Aristide Briand -", "Place De La Resistance Angle Rue Aristide Briand - 92130 Issy Les Moulineaux", 48.8212672391, 2.25062174136 },
        { 43005, 10, "43005 - Aubert (Vincennes)", "18 Avenue Aubert -", "18 Avenue Aubert - 94300 Vincennes", 48.8475581382, 2.4327966739 },
        { 43009, 10, "43009 - Murs Du Parc (Vincennes)", "Avenue Des Murs Du Parc -", "Avenue Des Murs Du Parc - 94300 Vincennes", 48.8468930451, 2.45307200223 },
        { 23009, 10, "23009 - France (Levallois)", "18 Rue Anatole France -", "18 Rue Anatole France - 92300 Levallois-Perret", 48.888703558, 2.28836911852 },
        { 43004, 10, "43004 - Montreuil (Vincennes)", "43 Rue De Montreuil -", "43 Rue De Montreuil - 94300 Vincennes", 48.8503519673, 2.43438156255 },
        { 23006, 10, "23006 - Guesde (Levallois)", "8 Rue Jules Guesde -", "8 Rue Jules Guesde - 92300 Levallois-Perret", 48.8905663514, 2.29474574696 },
        { 23007, 10, "23007 - Wilson (Levallois)", "22 Rue Du President Wilson -", "22 Rue Du President Wilson - 92300 Levallois-Perret", 48.8901880102, 2.29234736576 },
        { 42504, 10, "42504 - Malon (Gentilly)", "Face 59 Rue Benoit Malon -", "Face 59 Rue Benoit Malon - 94250 Gentilly", 48.814539948, 2.34092912724 },
        { 42502, 10, "42502 - Raspail 2 (Gentilly)", "Face Au 79 Avenue Raspail-", "Face Au 79 Avenue Raspail- 94250 Gentilly", 48.8133622226, 2.34686246125 },
        { 21701, 10, "21701 - Larmeroux (Vanves)", "Face 5 Bis Rue Larmeroux -", "Face 5 Bis Rue Larmeroux - 92170 Vanves", 48.8172323966, 2.28180847181 },
        { 32603, 10, "32603 - Calmette (Les Lilas)", "1 Allee Docteur Calmette -", "1 Allee Docteur Calmette - 93260 Les Lilas", 48.8812221652, 2.42461463872 },
        { 32605, 10, "32605 - Hortensias (Les Lilas)", "1 Allee Des Hortensias -", "1 Allee Des Hortensias - 93260 Les Lilas", 48.8820409365, 2.42333510001 },
        { 35013, 10, "35013 - Tell (Pantin)", "1 Rue Guillaume Tell -", "1 Rue Guillaume Tell - 93500 Pantin", 48.8897089477, 2.42064933123 },
        { 21703, 10, "21703 - Martinie (Vanves)", "5-7 Avenue Marcel Martinie -", "5-7 Avenue Marcel Martinie - 92170 Vanves", 48.8207145735, 2.29101918644 },
        { 33006, 0, "33006 - Karman (Aubervilliers)", "Face 143 Rue Andre Karman -", "Face 143 Rue Andre Karman - 93300 Aubervilliers", 48.9104887879, 2.38501552412 },
        { 41103, 10, "41103 - Briand (Arcueil)", "Avenue Aristide Briand (Carrefour Vache Noire) -", "Avenue Aristide Briand (Carrefour Vache Noire) - 94110 Arcueil", 48.8103782263, 2.32691262004 },
        { 21705, 10, "21705 - Hugo (Vanves)", "11 Avenue Victor Hugo -", "11 Avenue Victor Hugo - 92170 Vanves", 48.8224293222, 2.28636265056 },
        { 35014, 10, "35014 - De Gaulle (Pantin)", "139 Avenue Jean Lolive / Mail Charles De Gaulle -", "139 Avenue Jean Lolive / Mail Charles De Gaulle - 93500 Pantin", 48.8938193446, 2.41585822453 },
        { 35011, 10, "35011 - D'Orves (Pantin)", "12 Rue Honore D'Estienne D'Orves -", "12 Rue Honore D'Estienne D'Orves - 93500 Pantin", 48.8906167246, 2.40650384195 },
        { 35006, 10, "35006 - Delizy (Pantin)", "Face Au 23 Rue Delizy -", "Face Au 23 Rue Delizy - 93500 Pantin", 48.8953330808, 2.40971326135 },
        { 35009, 10, "35009 - Lolive 1 (Pantin)", "104 Avenue Lolive -", "104 Avenue Lolive - 93500 Pantin", 48.8919816269, 2.40845467048 },
        { 41101, 10, "41101 - Doumer (Arcueil)", "Face Au 11 Avenue Paul Doumer -", "Face Au 11 Avenue Paul Doumer - 94110 Arcueil", 48.8064420268, 2.3375948531 },
        { 21706, 10, "21706 - Bleuzen (Vanves)", "74 Rue Jean Bleuzen -", "74 Rue Jean Bleuzen - 92170 Vanves", 48.8229273177, 2.2958356033 },
        { 42706, 10, "42706 - Salengro (Kremlin Bicetre)", "3 Rue Roger Salengro -", "3 Rue Roger Salengro - 94270 Le Kremlin Bicetre", 48.8147173324, 2.36128836991 },
        { 23011, 10, "23011 - Bineau (Levallois)", "16 Boulevard Bineau -", "16 Boulevard Bineau - 92300 Levallois-Perret", 48.8866616978, 2.28424175947 },
        { 23010, 10, "23010 - Voltaire (Levallois)", "47 Rue Voltaire -", "47 Rue Voltaire - 92300 Levallois-Perret", 48.8921439866, 2.28446785245 },
        { 41102, 10, "41102 - Renan (Arcueil)", "3 Rue Ernest Renan -", "3 Rue Ernest Renan - 94110 Arcueil", 48.8080777364, 2.33321329067 },
        { 21704, 10, "21704 - Republique (Vanves)", "2 Rue De La Republique -", "2 Rue De La Republique - 92170 Vanves", 48.8217188961, 2.28543780259 },
        { 42705, 10, "42705 - Convention (Le Kremlin Bicetre)", "1 Rue De La Convention -", "1 Rue De La Convention - 94270 Le Kremlin Bicetre", 48.8124883939, 2.36117846963 },
        { 21702, 10, "21702 - Basch (Vanves)", "6 Avenue Victor Basch -", "6 Avenue Victor Basch - 92170 Vanves", 48.81906125, 2.29209586906 },
        { 35001, 0, "35001 - Jaures 1 (Pantin)", "168 Avenue Jean Jaures -", "168 Avenue Jean Jaures - 93500 Pantin", 48.9100688049, 2.39930373683 },
        { 35002, 10, "35002 - Jaures 2 (Pantin)", "130 Rue Jean Jaures -", "130 Rue Jean Jaures - 93500 Pantin", 48.9066825663, 2.39557779882 },
        { 21707, 10, "21707 - Pasteur (Vanves)", "9 Avenue Pasteur Angle Carrefour Albert Legris -", "9 Avenue Pasteur Angle Carrefour Albert Legris - 92170 Vanves", 48.8250742449, 2.29271678117 },
        { 42702, 10, "42702 - Leclerc (Kremlin Bicetre)", "73 Rue Du General Leclerc -", "73 Rue Du General Leclerc - 94270 Le Kremelin Bicetre", 48.8108442033, 2.35815671453 },
        { 42701, 10, "42701 - Gide (Le Kremlin Bicetre)", "Face 50 Avenue Charles Gide -", "Face 50 Avenue Charles Gide - 94270 Le Kremelin Bicetre", 48.8068995935, 2.35114748939 },
        { 42703, 10, "42703 - Fontainebleau (Kremlin Bicetre)", "93 Avenue De Fontainebleau -", "93 Avenue De Fontainebleau - 94270 Le Kremlin Bicetre", 48.8096749025, 2.36272846095 },
        { 23005, 10, "23005 - Briand (Levallois)", "152 Rue Aristide Briand -", "152 Rue Aristide Briand - 92300 Levallois", 48.8959324175, 2.29684043316 },
        { 42704, 10, "42704 - Rossel (Le Kremlin Bicetre)", "Rue Rossel / Avenue De La Convention -", "Rue Rossel / Avenue De La Convention - 94270 Le Kremlin Bicetre", 48.8114645086, 2.35728603578 },
        { 35005, 10, "35005 - General Leclerc (Pantin)", "Quai De L'Aisne/Avenue Du General Leclerc", "Quai De L'Aisne/Avenue Du General Leclerc 93500 Pantin", 48.8954435525, 2.40525630294 },
        { 35004, 10, "35004 - Allende (Pantin)", "Avenue De La Gare / Place Du President Salvador Allende -", "Avenue De La Gare / Place Du President Salvador Allende - 93500 Pantin", 48.8976121651, 2.40032476859 },
        { 34007, 1, "34007 - Rosiers (Saint Ouen)", "43-45 Rue Blanqui / Rue Des Rosiers -", "43-45 Rue Blanqui / Rue Des Rosiers - 93400 Saint Ouen", 48.9054476283, 2.33754097437 },
        { 33001, 10, "33001 - Emgp (Aubervilliers)", "Emgp Avenue De Porte De Paris / Parking 264 -", "Emgp Avenue De Porte De Paris / Parking 264 - 93300 Aubervilliers", 48.9037088032, 2.36934554912 },
        { 32008, 10, "32008 - Emgp Nord (Saint Denis)", "Emgp Parking Entree Nord -", "Emgp Parking Entree Nord - 93200 Saint Denis", 48.9050320908, 2.35980338612 },
        { 33104, 10, "33104 - Joineau (Pre Saint Gervais)", "Rue Andre Joineau / Place Anatole France -", "Rue Andre Joineau / Place Anatole France - 93310 Le Pre Saint Gervais", 48.8851539451, 2.40397543615 },
        { 33102, 10, "33102 - Jaures 1 (Pre Saint Gervais)", "Rue Gabriel Peri Angle Avenue Jaures -", "Rue Gabriel Peri Angle Avenue Jaures - 93310 Le Pre Saint Gervais", 48.8866527415, 2.40757515817 },
        { 33103, 10, "33103 - Jaures 2 (Pre Saint Gervais)", "34 Avenue Jean Jaures -", "34 Avenue Jean Jaures - 93310 Le Pre Saint Gervais", 48.8842618025, 2.40814426426 },
        { 23008, 10, "23008 - Republique (Levallois)", "Place De La Republique -", "Place De La Republique - 92300 Levallois", 48.893152434, 2.28891011054 },
        { 23002, 10, "23002- France (Levallois)", "157 Anatole France -", "157 Anatole France - 92300 Levallois", 48.8982616813, 2.27898193731 },
        { 23004, 10, "23004 - Couturier 2 (Levallois)", "109 Rue  Paul Vaillant Couturier -", "109 Rue  Paul Vaillant Couturier - 92300 Levallois", 48.8982948197, 2.29340356347 },
        { 23001, 10, "23001 - Couturier 1 (Levallois)", "2 Rue Paul Vaillant Couturier -", "2 Rue Paul Vaillant Couturier - 92300 Levallois", 48.8933987924, 2.27728368314 },
        { 31706, 10, "31706 - Chateau (Bagnolet)", "Rue Du Chateau -", "Rue Du Chateau - 93170 Bagnolet", 48.8630110416, 2.41572979449 },
        { 31705, 10, "31705 - Champeaux (Bagnolet)", "Rue Des Champeaux (Pres De La Gare Routiere) -", "Rue Des Champeaux (Pres De La Gare Routiere) - 93170 Bagnolet", 48.8641885583, 2.41547275657 },
        { 31707, 10, "31707 - Vaillant (Bagnolet)", "Face 70 Rue Edouard Vaillant -", "Face 70 Rue Edouard Vaillant - 93170 Bagnolet", 48.858616713, 2.41494676878 },
        { 22014, 10, "22014 - Hugo (Neuilly)", "35 Boulevard Victor Hugo -", "35 Boulevard Victor Hugo - 92200 Neuilly", 48.8886987173, 2.27772523453 },
        { 22012, 10, "22012- Michelis (Neuilly)", "32 Rue De Madeleine Michelis -", "32 Rue De Madeleine Michelis - 92200 Neuilly", 48.8828209482, 2.27747307154 },
        { 22011, 10, "22011 - Montrosier (Neuilly)", "7 Rue Montrosier -", "7 Rue Montrosier - 92200 Neuilly", 48.8794691919, 2.27845801677 },
        { 23003, 10, "23003 - Wilson (Levallois)", "132 Rue Du President Wilson -", "132 Rue Du President Wilson - 92300 Levallois", 48.8982912615, 2.28461153241 },
        { 42208, 10, "42208 - Paris 4 (Charenton)", "178 Rue De Paris -", "178 Rue De Paris - 94220 Charenton", 48.8292625765, 2.40130350125 },
        { 34005, 1, "34005 - Lesenne (Saint Ouen)", "44 Rue Adrien Lesenne -", "44 Rue Adrien Lesenne - 93400 Saint Ouen", 48.9025892195, 2.34835128421 },
        { 33011, 0, "33011 - Faure (Aubervilliers)", "Face 172-174 Boulevard Felix Faure -", "Face 172-174 Boulevard Felix Faure - 93300 Aubervilliers", 48.9114630189, 2.3748723351 },
        { 42013, 10, "42013 - Barbes (Ivry)", "Rue Barbes / Avenue De Verdun -", "Rue Barbes / Avenue De Verdun - 94200 Ivry Sur Seine", 48.8169977316, 2.37144226927 },
        { 34006, 1, "34006 - Michelet (Saint Ouen)", "92 Avenue Michelet -", "92 Avenue Michelet - 93400 Saint Ouen", 48.9056361512, 2.34426203967 },
        { 33009, 10, "33009 - Felix (Aubervilliers)", "120 Boulevard Felix Faure -", "120 Boulevard Felix Faure - 93300 Aubervilliers", 48.9081725206, 2.37861920231 },
        { 33010, 0, "33010 - Hugo (Aubervilliers)", "161 Avenue Victor Hugo -", "161 Avenue Victor Hugo - 93300 Aubervilliers", 48.9110840304, 2.37945322697 },
        { 33007, 0, "33007 - Republique 1 (Aubervilliers)", "2 Avenue De La Republique Sur Chausse -", "2 Avenue De La Republique Sur Chausse - 93300 Aubervilliers", 48.9138779716, 2.38225071098 },
        { 34002, 1, "34002 - Peri (Saint Ouen)", "128 Avenue Gabriel Peri / Avenue Du Capitaine Glamer -", "128 Avenue Gabriel Peri / Avenue Du Capitaine Glamer - 93400 Saint Ouen", 48.9025536119, 2.33077939736 },
        { 34004, 1, "34004 - Voltaire (Saint Ouen)", "1 Rue Voltaire -", "1 Rue Voltaire - 93400 Saint Ouen", 48.9024368452, 2.34238037044 },
        { 34008, 1, "34008- Garibaldi (Saint Ouen)", "Face Au 4 Avenue Garibaldi / Avenue Gabriel Peri -", "Face Au 4 Avenue Garibaldi / Avenue Gabriel Peri - 93400 Saint Ouen", 48.9058429097, 2.33126977596 },
        { 42012, 10, "42012 - Barbusse (Ivry)", "1 Rue Henry Barbusse -", "1 Rue Henry Barbusse - 94200 Ivry", 48.8104880339, 2.37945309612 },
        { 22002, 10, "22002 - Argenson (Neuilly)", "44 Boulevard D'Argenson -", "44 Boulevard D'Argenson - 92200 Neuilly", 48.8880804516, 2.26483349952 },
        { 22001, 10, "22001 - Chateau (Neuilly)", "26 Boulevard Du Chateau -", "26 Boulevard Du Chateau - 92200 Neuilly", 48.8906898474, 2.27014518846 },
        { 42201, 10, "42201 - Necker (Charenton)", "Rue Necker/ Rue Du Port Aux Lions -", "Rue Necker/ Rue Du Port Aux Lions - 94220 Charenton", 48.8226853765, 2.39793341661 },
        { 42205, 10, "42205 - Paris 1 (Charenton)", "89 Rue De Paris -", "89 Rue De Paris - 94220 Charenton", 48.8225873817, 2.41218420709 },
        { 21021, 10, "21021 - Paradis (Boulogne-Billancourt)", "Face Au 128 Rue Des Enfants Du Paradis -", "Face Au 128 Rue Des Enfants Du Paradis - 92100 Boulogne Billancourt", 48.8332344475, 2.25725899522 },
        { 42206, 10, "42206 - Paris 2 (Charenton)", "111 Rue De Paris -", "111 Rue De Paris - 94220 Charenton", 48.8239368417, 2.41007636762 },
        { 42207, 10, "42207 - Paris 3 (Charenton)", "136 Rue De Paris -", "136 Rue De Paris - 94220 Charenton", 48.8261678935, 2.40654034737 },
        { 21102, 10, "21102 - Nations Unies (Clichy)", "Place Des Nations Unies -", "Place Des Nations Unies - 92110 Clichy", 48.8968437579, 2.30958440693 },
        { 21104, 10, "21104 - Sanzillon (Clichy)", "64 Rue De Madame De Sanzillon -", "64 Rue De Madame De Sanzillon - 92110 Clichy", 48.903864423, 2.31846906406 },
        { 42007, 10, "42007- General De Gaulle (Ivry)", "Place Du General De Gaulle -", "Place Du General De Gaulle - 94200 Ivry", 48.8130883148, 2.37056873854 },
        { 42008, 10, "42008 - Casanova (Ivry)", "128 Avenue Daniel Casanova -", "128 Avenue Daniel Casanova - 94200 Ivry", 48.8147465233, 2.38401561364 },
        { 42015, 10, "42015 - Paul Bert (Ivry)", "En Vis A Vis Du 7 Rue Paul Bert -", "En Vis A Vis Du 7 Rue Paul Bert - 94200 Ivry", 48.818040009, 2.37246370457 },
        { 21308, 10, "21308 - Lasserre (Issy Les Moulineaux)", "Face Au 27 Rue Lasserre -", "Face Au 27 Rue Lasserre - 92130 Issy Les Moulineaux", 48.8211735695, 2.27299806913 },
        { 22005, 10, "22005- De Gaulle 3 (Neuilly)", "195 Avenue Charles De Gaulle -", "195 Avenue Charles De Gaulle - 92200 Neuilly", 48.8843482745, 2.26085951374 },
        { 34010, 1, "34010 - Diderot 2 (Saint Ouen)", "Face 61-63 Rue Diderot-", "Face 61-63 Rue Diderot- 93400 Saint Ouen", 48.9111094379, 2.33441872115 },
        { 34009, 10, "34009 - Maar (Saint Ouen)", "Rue Dora Maar / Gare Rer -", "Rue Dora Maar / Gare Rer - 93400 Saint Ouen", 48.905617388, 2.321849409 },
        { 35008, 10, "35008 - Lolive 2 (Pantin)", "132 Rue Jean Lolive -", "132 Rue Jean Lolive - 93500 Pantin", 48.8927523879, 2.41194490883 },
        { 22013, 10, "22013 - Sainte Foy (Neuilly)", "Face Au 6 Avenue Sainte Foy -", "Face Au 6 Avenue Sainte Foy - 92200 Neuilly", 48.8852062175, 2.26764480547 },
        { 42006, 10, "42006 - Brossolette (Ivry)", "23 Rue Pierre Brossolette -", "23 Rue Pierre Brossolette - 94200 Ivry", 48.8167966522, 2.38159494147 },
        { 22007, 10, "22007 - Charcot (Neuilly)", "35-37 Boulevard Du Commandant Charcot -", "35-37 Boulevard Du Commandant Charcot - 92200 Neuilly Sur Seine", 48.875582537, 2.25609002223 },
        { 33005, 10, "33005 - Republique 2 (Aubervilliers)", "Face Au 106 Avenue De La Republique -", "Face Au 106 Avenue De La Republique - 93300 Aubervilliers", 48.907737426, 2.3882168711 },
        { 42204, 10, "42204 - Briand (Charenton)", "Avenue Jean Jaures / Place Aristide Briand -", "Avenue Jean Jaures / Place Aristide Briand - 94220 Charenton", 48.8231167549, 2.41360054864 },
        { 35003, 10, "35003 - Vaillant (Pantin)", "Angle Rue General Gosserand Et Avenue Edouard Vaillant -", "Angle Rue General Gosserand Et Avenue Edouard Vaillant - 93500 Pantin", 48.9045347963, 2.39528909442 },
        { 42203, 10, "42203 - Eluard (Charenton)", "Face Au 7 Rue Paul Eluard -", "Face Au 7 Rue Paul Eluard - 94220 Charenton", 48.8200363465, 2.40981229515 },
        { 22008, 10, "22008 - De Gaulle (Neuilly)", "153 Bis Avenue Charles De Gaulle -", "153 Bis Avenue Charles De Gaulle - 92200 Neuilly Sur Seine", 48.8830566058, 2.2648541453 },
        { 22009, 10, "22009 - De Gaulle 2 (Neuilly)", "101 Avenue Charles De Gaulle -", "101 Avenue Charles De Gaulle - 92200 Neuilly Sur Seine", 48.8810022836, 2.27132961002 },
        { 42016, 10, "42016 - Curie (Ivry)", "1 Bis Rue Pierre Et Marie Curie -", "1 Bis Rue Pierre Et Marie Curie - 94200 Ivry", 48.815720029, 2.3761502715 },
        { 34001, 10, "34001 - Fructidor (Saint Ouen)", "Face 10 Rue Fructidor / Face Bat 2 Le Colysee -", "Face 10 Rue Fructidor / Face Bat 2 Le Colysee - 93400 Saint Ouen", 48.9011061731, 2.32441352824 },
        { 42010, 10, "42010 - Robespierre (Ivry)", "1 Rue Robespierre -", "1 Rue Robespierre - 94200 Ivry", 48.8109447753, 2.38383528334 },
        { 42001, 10, "42001 - Jules (Ivry)", "1 Rue Jules Vanzuppe -", "1 Rue Jules Vanzuppe - 94200 Ivry", 48.8200810496, 2.39365666821 },
        { 21103, 10, "21103 - Hugo (Clichy)", "94-98 Boulevard Victor Hugo -", "94-98 Boulevard Victor Hugo - 92110 Clichy", 48.9015455942, 2.31748840683 },
        { 42009, 10, "42009 - Verdun (Ivry)", "157-165 Avenue De Verdun -", "157-165 Avenue De Verdun - 94200 Ivry", 48.8067594398, 2.3755040276 },
        { 21105, 10, "21105 - Morice (Clichy)", "35-37 Rue Morice -", "35-37 Rue Morice - 92110 Clichy", 48.9026860999, 2.312866651 },
        { 21110, 10, "21110 - Villeneuve (Clichy)", "Face 51 Rue Villeneuve -", "Face 51 Rue Villeneuve - 92110 Clichy", 48.9053817588, 2.31068411438 },
        { 34003, 1, "34003 - Curie (Saint Ouen)", "2 Rue Neuve Pierre Curie -", "2 Rue Neuve Pierre Curie - 93401 Saint Ouen", 48.9014124261, 2.33718652314 },
        { 22004, 10, "22004 - Charles De Gaulle (Neuilly)", "162 Avenue Charles De Gaulle -", "162 Avenue Charles De Gaulle - 92200 Neuilly", 48.8846006536, 2.26201747624 },
        { 22010, 10, "22010 - De Gaulle 4 (Neuilly)", "72, Avenue Charles De Gaulle -", "72, Avenue Charles De Gaulle - 92200 Neuilly Sur Seine", 48.8817124266, 2.27160124098 },
        { 22006, 10, "22006 - Pierret (Neuilly)", "33 Rue Pierret -", "33 Rue Pierret - 92200 Neuilly Sur Seine", 48.8828110369, 2.26020768352 },
        { 21106, 10, "21106 - Morice 2 (Clichy)", "2-4 Rue Morice -", "2-4 Rue Morice - 92110 Clichy", 48.9009146724, 2.30851895678 },
        { 31708, 10, "31708 - Noisy (Bagnolet)", "116-118 Rue De Noisy Le Sec -", "116-118 Rue De Noisy Le Sec - 93170 Bagnolet", 48.87461409, 2.41514786455 },
        { 34011, 1, "34011 - Dhalenne (Saint Ouen)", "Face Au 61 Rue Albert Dhalenne -", "Face Au 61 Rue Albert Dhalenne - 93401 Saint Ouen", 48.9150816012, 2.33165050211 },
        { 31703, 10, "31703 - Carnot (Bagnolet)", "177, Rue Sadi Carnot -", "177, Rue Sadi Carnot - 93170 Bagnolet", 48.8752731699, 2.42381436348 },
        { 42014, 10, "42014 - Cachin (Ivry)", "Place Marcel Cachin -", "Place Marcel Cachin - 94200 Ivry Sur Seine", 48.814168354, 2.3910101032 },
        { 21101, 10, "21101 - Valiton (Clichy)", "4 Rue De Valiton -", "4 Rue De Valiton - 92110 Clichy", 48.9025201222, 2.29727152475 },
        { 42005, 10, "42005 - Gambetta (Ivry)", "1, Place De Leon Gambetta -", "1, Place De Leon Gambetta - 94200 Ivry", 48.8145043538, 2.40211544322 },
        { 22003, 10, "22003 - Bessfroy (Neuilly)", "3 Rue Bessfroy -", "3 Rue Bessfroy - 92200 Neuilly", 48.8865592258, 2.26100616292 },
        { 21112, 10, "21112 - Debussy (Clichy)", "31/35 Avenue Claude Debussy -", "31/35 Avenue Claude Debussy - 92110 Clichy", 48.9100458775, 2.3099591124 },
        { 21108, 10, "21108 - Villeneuve 2 (Clichy)", "6-8 Rue Villeneuve -", "6-8 Rue Villeneuve - 92110 Clichy", 48.9031606098, 2.30523231734 },
        { 21109, 10, "21109 - Guichet (Clichy)", "12Bis Rue Du Guichet -", "12Bis Rue Du Guichet - 92110 Clichy", 48.905307703, 2.30231354871 },
        { 31702, 10, "31702 - Curie (Bagnolet)", "40 Pierre Et Marie Curie -", "40 Pierre Et Marie Curie - 93170 Bagnolet", 48.8705186954, 2.4240652776 },
        { 21111, 10, "21111 - Leriche (Clichy)", "14 Rue Du Professeur Rene Leriche -", "14 Rue Du Professeur Rene Leriche - 92110 Clichy", 48.9080052243, 2.30747886959 },
        { 42002, 10, "42002 - Gare (Ivry)", "Vis-A-Vis Du 17 Rue De La Gare -", "Vis-A-Vis Du 17 Rue De La Gare - 94200 Ivry Sur Seine", 48.8147251094, 2.39207219085 },
        { 908, 10, "00908 - Porte De La Villette", "Porte De La Villette -", "Porte De La Villette - 75019 Paris", 48.8985893928, 2.38624499031 },
        { 42011, 10, "42011 - Boyer (Ivry)", "26 Quai Marcel Boyer -", "26 Quai Marcel Boyer - 94200 Ivry", 48.8226880401, 2.39246171547 },
        { 42003, 10, "42003 - Insurrection Aout 1944 (Ivry)", "2 Place De L'Insurrection Aout 1944 -", "2 Place De L'Insurrection Aout 1944 - 94200 Ivry Sur Seine", 48.8145517243, 2.39748841802 },
        { 31002, 10, "31002 - Republique (Montreuil)", "38 Rue De La Republique -", "38 Rue De La Republique - 93100 Montreuil", 48.8529157196, 2.41935083062 },
        { 42202, 10, "42202 - Ronsard (Charenton)", "1 Rue  Kennedy / Allee Ronsard -", "1 Rue  Kennedy / Allee Ronsard - 94220 Charenton", 48.8228339746, 2.40566477683 },
        { 31704, 10, "31704 - Hornet (Bagnolet)", "Face Au 1 Rue Jeanne Hornet -", "Face Au 1 Rue Jeanne Hornet - 93170 Bagnolet", 48.8739400211, 2.42788591238 },
        { 31709, 10, "31709 - Marcel (Bagnolet)", "Face Au 184 Rue Etienne Marcel -", "Face Au 184 Rue Etienne Marcel - 93170 Bagnolet", 48.8572273826, 2.4226401416 },
        { 31701, 10, "31701 - Berton (Bagnolet)", "3 Rue Raoul Berton -", "3 Rue Raoul Berton - 93170 Bagnolet", 48.8684020859, 2.41779505803 },
        { 22405, 10, "22405 - Nord (Malakoff)", "Angle Passage Du Nord / Gabriel Peri -", "Angle Passage Du Nord / Gabriel Peri - 92240 Malakoff", 48.8194244301, 2.30311993388 },
        { 31013, 10, "31013 - Centenaire (Montreuil)", "8 Rue Du Centenaire -", "8 Rue Du Centenaire - 93100 Montreuil", 48.8578080213, 2.42744910807 },
        { 22403, 10, "22403 - Brossolette (Malakoff)", "Face 35 Avenue Pierre Brossolette -", "Face 35 Avenue Pierre Brossolette - 92240 Malakoff", 48.8214309546, 2.31225150946 },
        { 22404, 10, "22404 - Brossolette 2 (Malakoff)", "102 Avenue Pierre Brossolette -", "102 Avenue Pierre Brossolette - 92240 Malakoff", 48.8175830885, 2.30735381221 },
        { 22401, 10, "22401 - De Gaulle (Malakoff)", "Boulevard Charles De Gaulle (Station De Metro) -", "Boulevard Charles De Gaulle (Station De Metro) - 92240 Malakoff", 48.822658568, 2.29844916718 },
        { 22402, 10, "22402 - Crie (Malakoff)", "40 Rue Gabriel Crie -", "40 Rue Gabriel Crie - 92240 Malakoff", 48.821751881, 2.30187980617 },
        { 31003, 10, "31003 - Paris (Montreuil)", "237-241 Rue De Paris -", "237-241 Rue De Paris - 93100 Montreuil", 48.8546781073, 2.41811423636 },
        { 31006, 10, "31006 - Republique 2 (Montreuil)", "2/4 Place De La Republique -", "2/4 Place De La Republique - 93100 Montreuil", 48.8534604638, 2.42426825442 },
        { 31009, 10, "31009 - De Gaulle (Montreuil)", "13/15 Place Du General De Gaulle-", "13/15 Place Du General De Gaulle- 93100 Montreuil", 48.8673921846, 2.43430449763 },
        { 22406, 10, "22406 - Moquet (Malakoff)", "81 Rue Guy Moquet -", "81 Rue Guy Moquet - 92240 Malakoff", 48.8152076002, 2.2979648045 },
        { 21107, 10, "21107 - Sincholle (Clichy)", "Rue Bertrand Sincholle -", "Rue Bertrand Sincholle - 92110 Clichy", 48.8995475117, 2.3041985644 },
        { 42004, 10, "42004 - Couturier (Ivry)", "30, Rue Paul Vaillant Couturier -", "30, Rue Paul Vaillant Couturier - 94200 Ivry Sur Seine", 48.8179847296, 2.39809124081 },
        { 31001, 10, "31001 - Lagny (Montreuil)", "96 Rue De Lagny -", "96 Rue De Lagny - 93100 Montreuil", 48.8492562499, 2.42159203846 },
        { 21206, 10, "21206- Peri (Montrouge)", "35/37 Rue Gabriel Peri -", "35/37 Rue Gabriel Peri - 92120 Montrouge", 48.8182688398, 2.32129010073 },
        { 22407, 10, "22407 - Barbusse (Malakoff)", "Rond Point Henri Barbusse -", "Rond Point Henri Barbusse - 92240 Malakoff", 48.814331801, 2.28732322012 },
        { 21202, 10, "21202- Barbes (Montrouge)", "16 Rue Barbes -", "16 Rue Barbes - 92120 Montrouge", 48.8173797322, 2.32756449611 },
        { 21113, 10, "21113 - Petit (Clichy)", "2, Rue Petit -", "2, Rue Petit - 92110 Clichy", 48.8995002105, 2.29655139178 },
        { 21203, 10, "21203 - Briand (Montrouge)", "Place Jules Ferry / Avenue Aristide Briand -", "Place Jules Ferry / Avenue Aristide Briand - 92120 Montrouge", 48.8123014955, 2.32570108244 },
        { 28002, 10, "28002 - Soljenitsyne (Puteaux)", "Rue Alexandre Soljenitsyne -", "Rue Alexandre Soljenitsyne - 92800 Puteaux", 48.8843040555, 2.24889473291 },
        { 31004, 10, "31004 - Paris 2 (Montreuil)", "175/179 Rue De Paris -", "175/179 Rue De Paris - 93100 Montreuil", 48.8553404794, 2.4219969056 },
        { 21211, 10, "21211 - Marne (Montrouge)", "100 Avenue De La Marne -", "100 Avenue De La Marne - 92120 Montrouge", 48.8119737276, 2.30356030149 },
        { 28003, 10, "28003 - Jaures (Puteaux)", "152 Rue Jean Jaures -", "152 Rue Jean Jaures - 92800 Puteaux", 48.8808082224, 2.23775423863 },
        { 32003, 10, "32003 - Metallurgie (Saint Denis)", "Avenue Du President Wilson / Rue De La Metallurgie -", "Avenue Du President Wilson / Rue De La Metallurgie - 93200 Saint Denis", 48.9093999884, 2.3587963726 },
        { 21208, 10, "21208 - Carves (Montrouge)", "67 Rue Carves Angle Avenue Henri Ginoux -", "67 Rue Carves Angle Avenue Henri Ginoux - 92120 Montrouge", 48.8131366623, 2.31997163534 },
        { 35010, 10, "35010 - Gervais (Pantin)", "1-3 Rue Du Pre Saint Gervais -", "1-3 Rue Du Pre Saint Gervais - 93500 Pantin", 48.8909961922, 2.40296077139 },
        { 21209, 10, "21209 - Georges Messier (Montrouge)", "35 Rue Moliere -", "35 Rue Moliere - 92120 Montrouge", 48.81155366, 2.31329049594 },
        { 28001, 10, "28001 - Wallace (Puteaux)", "Face Au 4 Boulevard Richard Wallace -", "Face Au 4 Boulevard Richard Wallace - 92800 Puteaux", 48.8787630036, 2.24251361485 },
        { 21502, 10, "21502 - Verdun (Suresnes)", "18 Bis Rue De Verdun / Cour Madelaine -", "18 Bis Rue De Verdun / Cour Madelaine - 92150 Suresnes", 48.8712007085, 2.22741847529 },
        { 32001, 10, "32001 - Proudhon (Saint Denis)", "Avenue President Wilson / Rue Proudhon -", "Avenue President Wilson / Rue Proudhon - 93200 Saint Denis", 48.906631961, 2.35887702121 },
        { 21503, 10, "21503 - Ledru Rollin (Suresnes)", "13/15 Rue Ledru Rollin -", "13/15 Rue Ledru Rollin - 92150 Suresnes", 48.8707261976, 2.22940855879 },
        { 21501, 10, "21501 - Sellier (Suresnes)", "Rue De Saint Cloud / Boulevard Henri Sellier -", "Rue De Saint Cloud / Boulevard Henri Sellier - 92150 Suresnes", 48.8676410327, 2.22667674966 },
        { 21204, 10, "21204 - D'Orves (Montrouge)", "Face 44 Rue D'Estiennes D'Orves / Piscine -", "Face 44 Rue D'Estiennes D'Orves / Piscine - 92120 Montrouge", 48.815168026, 2.3209236051 },
        { 32006, 10, "32006 - Eglise Saint Juste (Saint Denis)", "Avenue Du President Wilson / Parking De L'Eglise Saint Juste -", "Avenue Du President Wilson / Parking De L'Eglise Saint Juste - 93210 Saint Denis", 48.9087702506, 2.36210912796 },
        { 21210, 10, "21210 - Peri 2 (Montrouge)", "8 Rue Gabriel Peri -", "8 Rue Gabriel Peri - 92120 Montrouge", 48.8177748616, 2.32412111448 },
        { 21207, 10, "21207 - Verdier (Montrouge)", "Avenue Verdier Angle Avenue De La Republique -", "Avenue Verdier Angle Avenue De La Republique - 92120 Montrouge", 48.8153023891, 2.31790230612 },
        { 21201, 10, "21201 - Jaures (Montrouge)", "6 Place Jean Jaures / Rue Maurice Arnoux Et Rue Camille Pelletin -", "6 Place Jean Jaures / Rue Maurice Arnoux Et Rue Camille Pelletin - 92120 Montrouge", 48.8161010467, 2.31132863241 },
        { 31010, 10, "31010 - Stalingrad (Montreuil)", "67-69 Rue De Stalingrad -", "67-69 Rue De Stalingrad - 93100 Montreuil", 48.8568317547, 2.44503105275 },
        { 41601, 10, "41601 - General De Gaulle (Saint Mande)", "86 Avenue Du General De Gaulle -", "86 Avenue Du General De Gaulle - 94160 Saint Mande", 48.8389776074, 2.41710945165 },
        { 31012, 10, "31012 - Carnot (Montreuil)", "35/37 Rue Carnot -", "35/37 Rue Carnot - 93100 Montreuil", 48.8560170267, 2.44151541004 },
        { 31008, 10, "31008 - Vincennes (Montreuil)", "7 Bis Rue De Vincennes-", "7 Bis Rue De Vincennes- 93100 Montreuil", 48.8576920794, 2.43756886174 },
        { 31011, 10, "31011 - Stalingrad 2 (Montreuil)", "27 Rue De Stalingrad-", "27 Rue De Stalingrad- 93100 Montreuil", 48.8589993592, 2.4432103778 },
        { 31007, 10, "31007 - Paris 1 (Montreuil)", "63/65 Rue De Paris -", "63/65 Rue De Paris - 93100 Montreuil", 48.8572196764, 2.43278723185 },
        { 31005, 10, "31005 - Paris 2  (Montreuil)", "127/129 Rue De Paris -", "127/129 Rue De Paris - 93100 Montreuil", 48.8562178939, 2.42658828216 },
        { 41605, 10, "41605 - General De Gaulle 2 (Saint Mande)", "120 Avenue General De Gaulle -", "120 Avenue General De Gaulle - 94160 Saint Mande", 48.8361991838, 2.41897039649 },
        { 41604, 10, "41604 - Lagny (Saint Mande)", "126 Rue Lagny / Angle Avenue Joffre -", "126 Rue Lagny / Angle Avenue Joffre - 94160 Saint Mande", 48.8492046318, 2.41826912195 },
        { 15125, 10, "15125 - Aquaboulevard", "2 Avenue De La Porte De Sevres / Aquaboulevard -", "2 Avenue De La Porte De Sevres / Aquaboulevard - 75015 Paris", 48.8365723912, 2.27881976877 },
        { 41602, 10, "41602 - Digeon (Saint Mande)", "Place Charles Digeon -", "Place Charles Digeon - 94160 Saint Mande", 48.84370453, 2.41789288105 },
        { 13514, 5, "13514 - Gare D'Austerlitz 2", "9 Boulevard De L'Hopital -", "9 Boulevard De L'Hopital - 75013 Paris", 48.8413383536, 2.36305717925 },
        { 21007, 10, "21007 - Rhin Danube (Boulogne Billancourt)", "15 Rond Point Rhin Danube -", "15 Rond Point Rhin Danube - 92100 Boulogne Billancourt", 48.8405812503, 2.22825940579 },
        { 41202, 10, "41202 - Charmes (Fontenay Sous Bois)", "Angle Avenue Des Charmes / Avenue Foch -", "Angle Avenue Des Charmes / Avenue Foch - 94120 Fontenay Sous Bois", 48.8445351371, 2.45629395475 },
        { 21011, 10, "21011 - Silly (Boulogne Billancourt)", "153 Rue De Silly - Boulogne Billancourt", "153 Rue De Silly - Boulogne Billancourt  ", 48.8333994248, 2.23766816699 },
        { 41302, 30, "41302 - Charles De Gaulle (Nogent)", "Face Au 60 Avenue Charles De Gaulles -", "Face Au 60 Avenue Charles De Gaulles - 94130 Nogent Sur Marne", 48.8365188659, 2.48022408087 },
        { 33013, 0, "33013 - Rechaussiere (Aubervilliers)", "52 Rue Leopold Rechaussiere - Aubervilliers", "52 Rue Leopold Rechaussiere - Aubervilliers  ", 48.9137572566, 2.39157703526 },
        { 41603, 10, "41603 - Pasteur (Saint Mande)", "Avenue Pasteur/Avenue De Paris -", "Avenue Pasteur/Avenue De Paris - 94160 Saint Mande", 48.8453183319, 2.42353288823 },
        { 22101, 10, "22101 - Gare Routiere ( Saint Cloud)", "Gare Routiere - Arret Tram -", "Gare Routiere - Arret Tram - 92210 Saint Cloud", 48.8438112967, 2.2224382645 },
        { 43008, 10, "43008 - Fontenay (Vincennes)", "12 Rue De Fontenay -", "12 Rue De Fontenay - 94300 Vincennes", 48.8478885316, 2.44578868732 },
        { 41201, 20, "41201 - De Ricard (Fontenay Sous Bois)", "Rue Louis-Xavier De Ricard -", "Rue Louis-Xavier De Ricard - 94120 Fontenay Sous Bois", 48.8454217385, 2.47583664849 },
        { 41203, 10, "41203 - Stalingrad (Fontenay Sous Bois)", "14 Avenue Stalingrad -", "14 Avenue Stalingrad - 94120 Fontenay Sous Bois", 48.8502613061, 2.45516314604 },
        { 43401, 20, "43401 - Gare Rer (Joinville)", "Parc Du Stationnement / Gare Rer -", "Parc Du Stationnement / Gare Rer - 94340 Joinville-Le-Pont", 48.8214918384, 2.46408098221 },
        { 13123, 10, "13123 - Bibliothque Franois Mitterand", "53 Quai Francois Mauriac -", "53 Quai Francois Mauriac - 75013 Paris", 48.8347558557, 2.37627345669 },
        { 43006, 10, "43006 - Milimes (Vincennes)", "30 Avenue Des Milimes -", "30 Avenue Des Milimes - 94300 Vincennes", 48.8414125767, 2.43038891835 },
        { 15126, 10, "15126 - Renan", "Rue Ernest Renan / Parc Des Expositions -", "Rue Ernest Renan / Parc Des Expositions - 75015 Paris", 48.8326269857, 2.27912371559 },
        { 44101, 10, "44101 - Place Mongolfier (Saint Maurice)", "Place Montgolfier -", "Place Montgolfier - 94410 Saint Maurice", 48.8149986422, 2.45936994243 },
        { 21205, 10, "21205 - Jaures 2 (Montrouge)", "Avenue Jean Jaures / Rue Roger Salengero -", "Avenue Jean Jaures / Rue Roger Salengero - 92120 Montrouge", 48.8139428894, 2.3066890724 },
        { 41301, 20, "41301 - Clemanceau (Nogent)", "2 Rue Georges Clemenceau -", "2 Rue Georges Clemenceau - 94130 Nogent", 48.8362250969, 2.47002580629 },
        { 9003, 1, "09003 - Place Barbs", "Place Barbes -", "Place Barbes - 75009 Paris", 48.8836801575, 2.3490558511 },
        { 13151, 13, "13151 - Gare D'Austerlitz", "Gare D'Austerlitz -", "Gare D'Austerlitz - 75013 Paris", 27.1409734276, -3.40456063168 },
        { 12151, 13, "12151 - Gare De Lyon", "Gare De Lyon", "Gare De Lyon  ", 27.1409734276, -3.40456063168 },
        { 1009, 1, "01009 - Pont Neuf - 14", "14 Rue Du Pont Neuf -", "14 Rue Du Pont Neuf - 75001 Paris", 48.8599989426, 2.34428311398 },
        { 6020, 6, "06020 - Saint Michel Danton", "2 Rue Danton -", "2 Rue Danton - 75006 Paris", 48.8527281869, 2.3427840293 },
        { 6018, 6, "06018 - Michelet Assas", "13 Rue Michelet -", "13 Rue Michelet - 75006 Paris", 48.8425005192, 2.33491266032 },
        { 6017, 5, "06017 - Senat Conde", "34 Rue Conde -", "34 Rue Conde - 75006 Paris", 48.8493580115, 2.33781302731 },
        { 6015, 6, "06015 - Mazet Saint Andre Des Arts", "10 Rue Andre Mazet -", "10 Rue Andre Mazet - 75006 Paris", 48.8536090746, 2.33891623774 },
        { 6014, 6, "06014 - Pont De Lodi Dauphine", "7 Rue Du Pont De Lodi -", "7 Rue Du Pont De Lodi - 75006 Paris", 48.8551998287, 2.3401829239 },
        { 6013, 6, "06013 - Jacques Callot", "1 Rue Jacques Callot -", "1 Rue Jacques Callot - 75006 Paris", 48.8550920151, 2.33749983602 },
        { 6012, 6, "06012 - Saint Germain Copeau", "141 Bd Saint Germain -", "141 Bd Saint Germain - 75006 Paris", 48.8532855088, 2.33462616986 },
        { 6010, 6, "06010 - Montparnasse Chevreuse", "5 Rue De Chevreuse -", "5 Rue De Chevreuse - 75006 Paris", 48.8416465907, 2.33157673602 },
        { 6009, 6, "06009 - Guynemer Luxembourg", "26 Rue Guynemer -", "26 Rue Guynemer - 75006 Paris", 48.8467964792, 2.33243407669 },
        { 6008, 6, "06008 - Assas Luxembourg", "90 Rue D'Assas -", "90 Rue D'Assas - 75006 Paris", 48.8440013873, 2.33310155917 },
        { 6007, 6, "06007 - Vavin", "18 Rue Brea -", "18 Rue Brea - 75006 Paris", 48.8426530923, 2.3297247902 },
        { 6006, 6, "06006 - Notre Dame Des Champs", "41 Rue Notre Dame Des Champs -", "41 Rue Notre Dame Des Champs - 75006 Paris", 48.8448100749, 2.32935681805 },
        { 6005, 6, "06005 - Montparnasse", "40 Rue Du Montparnasse -", "40 Rue Du Montparnasse - 75006 Paris", 48.843183109, 2.32649758428 },
        { 6004, 6, "06004 - Regard", "19 Rue Du Regard -", "19 Rue Du Regard - 75006 Paris", 48.8472724648, 2.32690526595 },
        { 6003, 6, "06003 - Saint Sulpice", "15 Rue Du Vieux Colombier -", "15 Rue Du Vieux Colombier - 75006 Paris", 48.8515687604, 2.33085385491 },
        { 17032, 10, "17032 - Espace Champerret", "12 Rue Jean Oestreicher -", "12 Rue Jean Oestreicher - 75017 Paris", 48.885692534, 2.28762243209 },
        { 6001, 1, "06001 - Institut", "5 Quai Malaqais -", "5 Quai Malaqais - 75006 Paris", 48.8575455741, 2.3356338599 },
        { 17030, 10, "17030 - Rennequin Pereire", "143 Boulevard De Pereire -", "143 Boulevard De Pereire - 75017 Paris", 48.8834935924, 2.29524212498 },
        { 17028, 10, "17028 - Porte De Courcelle", "34 Boulevard De Reims -", "34 Boulevard De Reims - 75017 Paris", 48.8885266952, 2.2959876125 },
        { 17027, 10, "17027 - Pereire Levallois", "121 Boulevard Pereire -", "121 Boulevard Pereire - 75017 Paris", 48.8851303139, 2.29832063578 },
        { 17026, 8, "17026 - Wagram Courcelles", "105 Rue Jouffroy D'Abbans -", "105 Rue Jouffroy D'Abbans - 75017 Paris", 48.8817430061, 2.30111665497 },
        { 17025, 8, "17025 - Courcelles", "2 Rue De Chazelles -", "2 Rue De Chazelles - 75017 Paris", 48.8792362374, 2.30342120465 },
        { 17024, 8, "17024 - Villiers", "1/3 Place Prosper Goubaux -", "1/3 Place Prosper Goubaux - 75017 Paris", 48.881288326, 2.31648776314 },
        { 17023, 10, "17023 - Avenue De La Porte D'Asnires", "22 Avenue De La Porte D'Asnieres -", "22 Avenue De La Porte D'Asnieres - 75017 Paris", 48.8908116607, 2.30299114673 },
        { 17022, 10, "17022 - Place De Wagram", "67 Boulevard Pereire -", "67 Boulevard Pereire - 75017 Paris", 48.8870464138, 2.30437007394 },
        { 17021, 10, "17021 - Wagram (17Eme Arr.)", "Rue Jouffroy D'Abbans -", "Rue Jouffroy D'Abbans - 75017 Paris", 48.88402696, 2.30529864637 },
        { 17020, 10, "17020 - Nicaragua", "49 Rue Jouffroy D'Abbans -", "49 Rue Jouffroy D'Abbans - 75017 Paris", 48.8850699437, 2.30708321666 },
        { 17019, 10, "17019 - Malesherbes", "20 Rue De Phalsbourg -", "20 Rue De Phalsbourg - 75017 Paris", 48.8826438844, 2.30910141644 },
        { 17018, 8, "17018 - Monceau", "4 Rue De Thann -", "4 Rue De Thann - 75017 Paris", 48.8808913936, 2.30919775354 },
        { 17017, 10, "17017 - Pont Cardinet", "167 Rue De Rome -", "167 Rue De Rome - 75017 Paris", 48.8870936637, 2.31423679858 },
        { 17015, 10, "17015 - Place De Levis", "19Bis/21 Rue Legendre -", "19Bis/21 Rue Legendre - 75017 Paris", 48.8835075328, 2.31308008138 },
        { 17013, 10, "17013 - Legendre", "62 Rue Legendre -", "62 Rue Legendre - 75017 Paris", 48.8853775091, 2.3164316143 },
        { 17011, 10, "17011 - Porte De Clichy Fragonard", "4 Rue Fragonard -", "4 Rue Fragonard - 75017 Paris", 48.8941307113, 2.31466983214 },
        { 17010, 10, "17010 - Joncquiere", "90 Rue De La Jonquiere -", "90 Rue De La Jonquiere - 75017 Paris", 48.894796461, 2.31873132354 },
        { 17009, 10, "17009 - Bodin Avenue De Clichy", "2 Rue Paul Bodin -", "2 Rue Paul Bodin - 75017 Paris", 48.8924505789, 2.31728743256 },
        { 17008, 10, "17008 - Porche Pouchet", "7 Place Arnaud Tzanck -", "7 Place Arnaud Tzanck - 75017 Paris", 48.8987333508, 2.3224784894 },
        { 17007, 10, "17007 - Navier", "Face 57 Rue Navier -", "Face 57 Rue Navier - 75017 Paris", 48.8958754608, 2.32262923885 },
        { 17006, 10, "17006 - Guy Mocquet Davy", "34 Rue Guy Mocquet -", "34 Rue Guy Mocquet - 75017 Paris", 48.891975106, 2.32323003289 },
        { 17005, 10, "17005 - Brochant", "43 Rue Brochant -", "43 Rue Brochant - 75017 Paris", 48.8901952128, 2.31994594258 },
        { 17003, 1, "17003 - Jacques Kellner", "4-6 Rue Jacques Kellner -", "4-6 Rue Jacques Kellner - 75017 Paris", 48.8958400351, 2.32780880596 },
        { 17002, 10, "17002 - La Fourche Rue De La Condamine", "4 Rue De La Condamine -", "4 Rue De La Condamine - 75017 Paris", 48.8878680917, 2.32438955103 },
        { 17001, 1, "17001 - Guy Mocquet", "Rue Guy Mocquet -", "Rue Guy Mocquet - 75017 Paris", 48.8927753368, 2.32686892155 },
        { 18103, 10, "18103 - Charles Hermite", "Face 54 Rue Charles Hermite -", "Face 54 Rue Charles Hermite - 75018 Paris", 48.8987850622, 2.36455795255 },
        { 18101, 10, "18101 - Championnet", "32 Rue Championnet -", "32 Rue Championnet - 75018 Paris", 48.8955521638, 2.34976733239 },
        { 12028, 10, "12028 - Vivaldi", "42 Allee Vivaldi -", "42 Allee Vivaldi - 75012 Paris", 48.8418598745, 2.38967717326 },
        { 7024, 7, "07024 - Avenue Rapp", "43 Avenue Rapp -", "43 Avenue Rapp - 75007 Paris", 48.858016259, 2.30053388642 },
        { 7022, 7, "07022 - Pont De L'Alma", "3 Avenue Bosquet -", "3 Avenue Bosquet - 75007 Paris", 48.8616028235, 2.30249283081 },
        { 7021, 7, "07021 - Bosquet Saint Dominique", "37 Avenue Bosquet -", "37 Avenue Bosquet - 75007 Paris", 48.8587002695, 2.3038159796 },
        { 7020, 7, "07020 - Cler", "Face 3 Rue Du Champ De Mars -", "Face 3 Rue Du Champ De Mars - 75007 Paris", 48.8567777119, 2.30660934949 },
        { 7019, 7, "07019 - Ecole Militaire", "85 Avenue Bosquet -", "85 Avenue Bosquet - 75007 Paris", 48.8546474181, 2.30557551936 },
        { 7018, 7, "07018 - Segur Estrees", "23 Avenue De Segur -", "23 Avenue De Segur - 75007 Paris", 48.8512781597, 2.30975851914 },
        { 7017, 7, "07017 - La Tour Maubourg", "1 Avenue De La Motte Picquet -", "1 Avenue De La Motte Picquet - 75007 Paris", 48.8567604449, 2.30949683012 },
        { 7016, 7, "07016 - Tour Maubourg Universite", "13 Rue Surcouf -", "13 Rue Surcouf - 75007 Paris", 48.8613260387, 2.30943990115 },
        { 7015, 7, "07015 - Varenne", "9 Boulevard Des Invalides -", "9 Boulevard Des Invalides - 75007 Paris", 48.8567975978, 2.31525813498 },
        { 7014, 7, "07014 - Saint Francois Xavier", "35 Boulevard Des Invalides -", "35 Boulevard Des Invalides - 75007 Paris", 48.8516297174, 2.31474281215 },
        { 7012, 7, "07012 - Cite Vaneau", "7 Cite Vaneau -", "7 Cite Vaneau - 75007 Paris", 48.8542908047, 2.31946762184 },
        { 7011, 7, "07011 - St Dominique", "30 Bis Rue Las Cases -", "30 Bis Rue Las Cases - 75007 Paris", 48.8590630212, 2.31874408564 },
        { 7010, 7, "07010 - Invalides", "Face 3 Rue De Constantine -", "Face 3 Rue De Constantine - 75007 Paris", 48.8607699495, 2.31479332955 },
        { 7009, 7, "07009 - Assemblee Nationale", "Face 119 Rue De Lille -", "Face 119 Rue De Lille - 75007 Paris", 48.8612831086, 2.32006456236 },
        { 7008, 7, "07008 - Solferino", "10 Rue De Villersexel -", "10 Rue De Villersexel - 75007 Paris", 48.8582997641, 2.32375671939 },
        { 7007, 1, "07007 - Muse D'Orsay", "62 Rue De Lille -", "62 Rue De Lille - 75007 Paris", 48.8597469519, 2.32579948184 },
        { 7006, 1, "07006 - Quai Voltaire", "Quai Voltaire -", "Quai Voltaire - 75007 Paris", 48.8590463302, 2.33119345083 },
        { 7005, 6, "07005 - Bac", "Face 2 Boulevard Raspail -", "Face 2 Boulevard Raspail - 75007 Paris", 48.8556217107, 2.3256641944 },
        { 7004, 6, "07004 - Raspail Varenne", "Face 28 Boulevard Raspail -", "Face 28 Boulevard Raspail - 75007 Paris", 48.8531771901, 2.32635931988 },
        { 18033, 1, "18033 - Moskowa", "111 Rue Belliard -", "111 Rue Belliard - 75018 Paris", 48.8965863393, 2.3380588884 },
        { 7002, 7, "07002 - Vaneau", "86 Rue Vaneau -", "86 Rue Vaneau - 75007 Paris", 48.84854794, 2.32035476001 },
        { 7001, 7, "07001 - Duroc", "63 Boulevard Des Invalides -", "63 Boulevard Des Invalides - 75007 Paris", 48.847630561, 2.31624249961 },
        { 18030, 1, "18030 - Simplon", "1 Rue Joseph Dijon -", "1 Rue Joseph Dijon - 75018 Paris", 48.8936830566, 2.34744980723 },
        { 18029, 1, "18029 - Poteau", "1 Rue Emile Blemont -", "1 Rue Emile Blemont - 75018 Paris", 48.894510246, 2.34119377076 },
        { 18027, 1, "18027 - Damremont Ordener", "102 Rue Damremont -", "102 Rue Damremont - 75018 Paris", 48.8933509654, 2.33651867539 },
        { 18026, 1, "18026 - Ruisseau Ordener", "37 Rue Du Ruisseau -", "37 Rue Du Ruisseau - 75018 Paris", 48.8928746167, 2.33998060903 },
        { 18025, 1, "18025 - Mairie Du 18 Eme", "81 Rue Mont-Cenis -", "81 Rue Mont-Cenis - 75018 Paris", 48.8927216553, 2.34434207082 },
        { 18024, 1, "18024 - Clignancourt Marcadet", "105 Rue De Clignancourt -", "105 Rue De Clignancourt - 75018 Paris", 48.8914271673, 2.34866236693 },
        { 18023, 10, "18023 - Poissonniers Ordener", "57 Rue Ordener -", "57 Rue Ordener - 75018 Paris", 48.8911033545, 2.35123820837 },
        { 18022, 1, "18022 - Barbes Marcadet", "57 Rue Marcadet -", "57 Rue Marcadet - 75018 Paris", 48.8903846009, 2.34920729659 },
        { 18021, 1, "18021 - Marcadet - Ramey", "98 Rue Marcadet -", "98 Rue Marcadet - 75018 Paris", 48.8910320347, 2.34485974739 },
        { 18020, 1, "18020 - Ruisseau", "31 Rue Francoeur -", "31 Rue Francoeur - 75018 Paris", 48.8910142755, 2.33981696141 },
        { 18019, 1, "18019 - Montcalm", "2 Rue Montcalm -", "2 Rue Montcalm - 75018 Paris", 48.8917512343, 2.33522391096 },
        { 18017, 1, "18017 - Pecqueur", "93 Rue Coulaincourt -", "93 Rue Coulaincourt - 75018 Paris", 48.88963926, 2.33819506828 },
        { 18016, 1, "18016 - Francoeur Caulaincourt", "1 Rue Francoeur -", "1 Rue Francoeur - 75018 Paris", 48.889890787, 2.34255630445 },
        { 18015, 1, "18015 - Custine", "23 Rue Custine -", "23 Rue Custine - 75018 Paris", 48.8886323258, 2.34667198811 },
        { 18014, 10, "18014 - Doudeauville Leon", "26 Rue Leon -", "26 Rue Leon - 75018 Paris", 48.888361958, 2.35362244693 },
        { 18013, 10, "18013 - Chateau Rouge", "28 Rue Poulet -", "28 Rue Poulet - 75018 Paris", 48.8875265599, 2.3502832674 },
        { 18012, 10, "18012 - Doudeauville Stephenson", "51 Rue Stephenson -", "51 Rue Stephenson - 75018 Paris", 48.8887480689, 2.35592579359 },
        { 18011, 10, "18011 - Herbert", "85 Rue Pajol -", "85 Rue Pajol - 75018 Paris", 48.8928897465, 2.3634372163 },
        { 18010, 10, "18010 - Marx Dormoy", "81 Rue Riquet -", "81 Rue Riquet - 75018 Paris", 48.890077405, 2.36031477777 },
        { 18009, 10, "18009 - Lepine", "12 Rue Jean Francois Lepine -", "12 Rue Jean Francois Lepine - 75018 Paris", 48.8861056948, 2.35676976866 },
        { 18008, 10, "18008 - Square Leon", "Face 36 Rue Cave -", "Face 36 Rue Cave - 75018 Paris", 48.886519647, 2.35313125847 },
        { 18007, 10, "18007 - Goutte D' Or", "65 Rue De La Goutte D'Or -", "65 Rue De La Goutte D'Or - 75018 Paris", 48.8851270233, 2.34981932594 },
        { 18006, 1, "18006 - Marche St-Pierre", "Place Saint Pierre -", "Place Saint Pierre - 75018 Paris", 48.8844534265, 2.34444995946 },
        { 18005, 1, "18005 - Tardieu", "8 Rue Tardieu -", "8 Rue Tardieu - 75018 Paris", 48.8841120477, 2.34165630954 },
        { 18004, 1, "18004 - Abbesses", "2 Rue De La Vieuville -", "2 Rue De La Vieuville - 75018 Paris", 48.8844536329, 2.33886271762 },
        { 18003, 1, "18003 - Joseph De Maistre Lepic", "2 Rue Joseph De Maistre -", "2 Rue Joseph De Maistre - 75018 Paris", 48.8863678367, 2.33274383987 },
        { 18002, 1, "18002 - Clignancourt", "25 Rue De Clignancourt -", "25 Rue De Clignancourt - 75018 Paris", 48.8852710649, 2.34721648272 },
        { 18001, 1, "18001 - Damremont Caulaincourt", "6 Rue Damremont -", "6 Rue Damremont - 75018 Paris", 48.8870149139, 2.3326892712 },
        { 14020, 10, "14020 - Porte De Montrouge", "Av. De La Porte De Montrouge -", "Av. De La Porte De Montrouge - 75014 Paris", 48.821216774, 2.32105781022 },
        { 14019, 10, "14019 - Sarette General Leclerc", "58 Rue Sarrette -", "58 Rue Sarrette - 75014 Paris", 48.8248933096, 2.32606579775 },
        { 14018, 10, "14018 - Porte D'Orleans", "6 Place Du 25 Aout 1944 -", "6 Place Du 25 Aout 1944 - 75014 Paris", 48.8228709849, 2.32505900124 },
        { 14017, 10, "14017 - Jourdan Tombe Issoire", "160 Rue Tombe Issoire -", "160 Rue Tombe Issoire - 75014 Paris", 48.8222872064, 2.33028579919 },
        { 14016, 10, "14016 - Reille Montsouris", "61 Avenue Rene Coty -", "61 Avenue Rene Coty - 75014 Paris", 48.8246242002, 2.33615213189 },
        { 8057, 8, "08057 - Hoche", "62 Avenue Hoche -", "62 Avenue Hoche - 75008 Paris", 48.8748935682, 2.29755170325 },
        { 8056, 8, "08056 - Wagram", "21 Rue Beaujon -", "21 Rue Beaujon - 75008 Paris", 48.8752976564, 2.29654314276 },
        { 8055, 8, "08055 - Ternes Courcelles", "87 Bd Courcelles -", "87 Bd Courcelles - 75008 Paris", 48.8782373546, 2.29912973377 },
        { 8054, 8, "08054 - Hoche Albrecht", "10 Avenue Berthier Albrecht -", "10 Avenue Berthier Albrecht - 75008 Paris", 48.8761350289, 2.30137944334 },
        { 8053, 8, "08053 - Friedland", "Place Georges Guillaumin -", "Place Georges Guillaumin - 75008 Paris", 48.8746522233, 2.30170746561 },
        { 8052, 8, "08052 - Washington", "2 Rue Balzac -", "2 Rue Balzac - 75008 Paris", 48.8725396132, 2.29977426492 },
        { 8051, 8, "08051 - Chaptal", "45 Bd Batignolles -", "45 Bd Batignolles - 75008 Paris", 48.8818281686, 2.32033028457 },
        { 8050, 8, "08050 - Boetie Ponthieu", "116 Rue De La Boetie -", "116 Rue De La Boetie - 75008 Paris", 48.8715352061, 2.3074725651 },
        { 8049, 8, "08049 - Dunant", "42 Avenue George V -", "42 Avenue George V - 75008 Paris", 48.8701403355, 2.3008658919 },
        { 8046, 8, "08046 - Alma Marceau", "2 Rue Marceau -", "2 Rue Marceau - 75008 Paris", 48.8651251538, 2.30009293765 },
        { 8045, 8, "08045 - Alma", "Face 3 Avenue Montaigne -", "Face 3 Avenue Montaigne - 75008 Paris", 48.8648742311, 2.30249063789 },
        { 8044, 8, "08044 - Van Dyck", "2 Rue Alfred De Vigny -", "2 Rue Alfred De Vigny - 75008 Paris", 48.878212215, 2.30532948208 },
        { 8043, 8, "08043 - Hopital Beaujon", "177 Rue Faubourg Saint Honore -", "177 Rue Faubourg Saint Honore - 75008 Paris", 48.8750306057, 2.30492269287 },
        { 8041, 8, "08041 - Champs Elysees Lincoln", "16 Rue De Lincoln -", "16 Rue De Lincoln - 75008 Paris", 48.8708510815, 2.30339942834 },
        { 8040, 8, "08040 - Champs Elysees Charron", "65 Rue Pierre Charron -", "65 Rue Pierre Charron - 75008 Paris", 48.8703391905, 2.30478938106 },
        { 8039, 8, "08039 - Colisee", "6 Rue Du Colisee -", "6 Rue Du Colisee - 75008 Paris", 48.8702229912, 2.30721446886 },
        { 8038, 8, "08038 - Francois 1 Er", "22 Rue Francois 1Er -", "22 Rue Francois 1Er - 75008 Paris", 48.8668795147, 2.30649439726 },
        { 8037, 8, "08037 - Malsherbes Monceau", "75 Rue De Monceau -", "75 Rue De Monceau - 75008 Paris", 48.8795174468, 2.31436279745 },
        { 8036, 8, "08036 - Rio", "39 Rue De Lisbonne -", "39 Rue De Lisbonne - 75008 Paris", 48.8774314417, 2.30982640237 },
        { 8035, 8, "08035 - Narvick", "54 Rue De La Bienfaisance -", "54 Rue De La Bienfaisance - 75008 Paris", 48.8765963238, 2.3130560532 },
        { 8034, 8, "08034 - Haussmann Courcelles", "49 Rue De Berri -", "49 Rue De Berri - 75008 Paris", 48.8748787203, 2.30842438777 },
        { 8033, 8, "08033 - Saint Philippe Du Roule", "1 Rue Du Cdt Riviere -", "1 Rue Du Cdt Riviere - 75008 Paris", 48.8727130855, 2.30971990368 },
        { 8032, 8, "08032 - Matignon", "27 Avenue Matignon -", "27 Avenue Matignon - 75008 Paris", 48.8715905558, 2.31386220764 },
        { 8031, 8, "08031 - Rond Point Des Champs Elysees", "2 Rue Jean Mermoz -", "2 Rue Jean Mermoz - 75008 Paris", 48.8696216741, 2.31072968587 },
        { 8029, 8, "08029 - Place Du Canada", "1 Avenue Franklin Roosevelt -", "1 Avenue Franklin Roosevelt - 75008 Paris", 48.8651098721, 2.31006449913 },
        { 8028, 8, "08028 - Houssaye", "1 Rue Arsene Houssaye -", "1 Rue Arsene Houssaye - 75008 Paris", 48.8733207901, 2.2975529076 },
        { 8027, 8, "08027 - Mairie Du 8 me", "28 Rue De Madrid -", "28 Rue De Madrid - 75008 Paris", 48.8779273999, 2.31835583084 },
        { 8026, 8, "08026 - Messine", "2 Avenue Messine -", "2 Avenue Messine - 75008 Paris", 48.8754374511, 2.31559085334 },
        { 8025, 8, "08025 - Miromesnil", "39 Rue De Miromesnil -", "39 Rue De Miromesnil - 75008 Paris", 48.8737838296, 2.31582316272 },
        { 8019, 8, "08019 - Europe", "03 Rue De Naples -", "03 Rue De Naples - 75008 Paris", 48.8799140404, 2.32147551242 },
        { 8018, 8, "08018 - Saint Augustin", "18 Place Henri Bergson -", "18 Place Henri Bergson - 75008 Paris", 48.8762200325, 2.31977347973 },
        { 8017, 8, "08017 - Rocher", "14 Rue Rocher -", "14 Rue Rocher - 75008 Paris", 48.8759867716, 2.32282560181 },
        { 8016, 8, "08016 - Square Louis Xvi", "Dev 32 Rue Pasquier -", "Dev 32 Rue Pasquier - 75008 Paris", 48.8731918233, 2.32369834497 },
        { 8013, 8, "08013 - Marignan", "24 Rue De Marignan -", "24 Rue De Marignan - 75008 Paris", 48.8696835845, 2.30656085152 },
        { 8011, 8, "08011 - Dublin", "1 Rue Clapeyron -", "1 Rue Clapeyron - 75008 Paris", 48.8808131298, 2.32451393988 },
        { 8010, 1, "08010 - Liege", "22 Rue De Liege -", "22 Rue De Liege - 75008 Paris", 48.8795641041, 2.32658541919 },
        { 8009, 1, "08009 - Saint Lazare Rer", "1 Rue De L'Isly -", "1 Rue De L'Isly - 75008 Paris", 48.8747289498, 2.32662728868 },
        { 9111, 1, "09111 - La Fayette Provence", "28 Rue De La Victoire -", "28 Rue De La Victoire - 75009 Paris", 48.8751697977, 2.3381675555 },
        { 8007, 1, "08007 - Haussmann Rome", "1 Rue De Rome -", "1 Rue De Rome - 75008 Paris", 48.8741446876, 2.32568730346 },
        { 8005, 8, "08005 - Madeleine", "04 Place De La Madeleine -", "04 Place De La Madeleine - 75008 Paris", 48.8690846758, 2.32424435387 },
        { 8004, 8, "08004 - Malesherbes Pasquier", "Face 4 Bd Malesherbes -", "Face 4 Bd Malesherbes - 75008 Paris", 48.8704596046, 2.32307236714 },
        { 19032, 10, "19032 - Porte D'Aubervillier", "Face 4 Av De La Porte D'Aubervilliers -", "Face 4 Av De La Porte D'Aubervilliers - 75019 Paris", 48.8989721523, 2.3709647331 },
        { 8001, 8, "08001 - Petit Palais", "Av. Dutuit -", "Av. Dutuit - 75008 Paris", 48.8666838219, 2.31574436051 },
        { 19029, 10, "19029 - Seine Flandre", "51 Quai De La Seine -", "51 Quai De La Seine - 75019 Paris", 48.8867215735, 2.37455456196 },
        { 19028, 10, "19028 - Place Des Fetes", "17 Rue Des Fetes -", "17 Rue Des Fetes - 75019 Paris", 48.876397408, 2.3921374012 },
        { 19027, 10, "19027 - Pre St Gervais Version 2", "Face 109 Boulevard Serurier -", "Face 109 Boulevard Serurier - 75019 Paris", 48.8805377178, 2.39796025472 },
        { 19026, 10, "19026 - Danube", "53 Rue Miguel Hidalgo -", "53 Rue Miguel Hidalgo - 75019 Paris", 48.8819244316, 2.39245666842 },
        { 19025, 10, "19025 - Botzaris Version 2", "Face 80 Rue Botzaris -", "Face 80 Rue Botzaris - 75019 Paris", 48.8795173827, 2.3890339479 },
        { 19024, 10, "19024 - Buttes Chaumont", "28 / 30 Rue Botzaris -", "28 / 30 Rue Botzaris - 75019 Paris", 48.8777858958, 2.38144272079 },
        { 19023, 10, "19023 - Manin Simon Bolivar", "Face 1 Rue Manin -", "Face 1 Rue Manin - 75019 Paris", 48.8763395191, 2.3798609545 },
        { 19022, 10, "19022 - Bolivar", "53 Rue De Meaux -", "53 Rue De Meaux - 75019 Paris", 48.8813026631, 2.37328338961 },
        { 19021, 10, "19021 - Mairie Du 19 Eme", "4 Rue Armand Carrel -", "4 Rue Armand Carrel - 75019 Paris", 48.8825222116, 2.38136499683 },
        { 16028, 10, "16028 - Millet - Jean De La Fontaine", "12 Rue Francois Millet -", "12 Rue Francois Millet - 75016 Paris", 48.8509490938, 2.27236196548 },
        { 19017, 10, "19017 - Parc De La Villette", "197 Avenue Jean Jaures -", "197 Avenue Jean Jaures - 75019 Paris", 48.888368942, 2.39099165938 },
        { 19016, 10, "19016 - Ourcq", "78 Rue D'Hautpoul -", "78 Rue D'Hautpoul - 75019 Paris", 48.8866094602, 2.386329063 },
        { 19015, 10, "19015 - Thionville", "24 Rue De Thionville -", "24 Rue De Thionville - 75019 Paris", 48.8891539507, 2.3835512261 },
        { 19014, 10, "19014 - Lorraine", "28 Rue De Lorraine -", "28 Rue De Lorraine - 75019 Paris", 48.8862692428, 2.383071673 },
        { 19013, 10, "19013 - Laumiere Et Laumiere Bis", "8 & 1 Rue Petit -", "8 & 1 Rue Petit - 75019 Paris", 48.8845807407, 2.38012665025 },
        { 19012, 10, "19012 - Lally Tollendal", "5 Rue Lally Tollendal -", "5 Rue Lally Tollendal - 75019 Paris", 48.8827132964, 2.37446991588 },
        { 19011, 10, "19011 - Rouvet Dampierre Version 2", "2 Rue Rouvet -", "2 Rue Rouvet - 75019 Paris", 48.8932605317, 2.38497238731 },
        { 19010, 10, "19010 - Porte De La Villette", "Rue Emile Reynaud Sur Tpc -", "Rue Emile Reynaud Sur Tpc - 75019 Paris", 48.9013208955, 2.38763802233 },
        { 19007, 10, "19007 - Ourcq-Flandres", "139 Avenue De Flandre -", "139 Avenue De Flandre - 75019 Paris", 48.892579738, 2.37902927313 },
        { 19005, 10, "19005 - Riquet", "56 Avenue De Flandre -", "56 Avenue De Flandre - 75019 Paris", 48.8878452649, 2.37361501707 },
        { 19003, 10, "19003 - Quai De Seine", "3 Quai De La Seine -", "3 Quai De La Seine - 75019 Paris", 48.8843504593, 2.36936081879 },
        { 19002, 10, "19002 - Tanger", "45 & 48 Rue Riquet -", "45 & 48 Rue Riquet - 75019 Paris", 48.8892031206, 2.37093112182 },
        { 19001, 10, "19001 - Ourcq Crimee", "243 Rue De Crimee -", "243 Rue De Crimee - 75019 Paris", 48.8939297346, 2.37312860918 },
        { 17049, 10, "17049 - Saussure", "116 Bis Rue De Saussure -", "116 Bis Rue De Saussure - 75017 Paris", 48.8882522182, 2.31043395533 },
        { 17048, 10, "17048 - Tocqueville", "12 Rue De Tocqueville -", "12 Rue De Tocqueville - 75017 Paris", 48.8823663324, 2.31397998704 },
        { 17046, 10, "17046 - Mac Mahon", "18 Avenue Marc Mahon -", "18 Avenue Marc Mahon - 75017 Paris", 48.8774808903, 2.29460659482 },
        { 17045, 8, "17045 - Place Des Ternes - 5", "5 Place Des Ternes -", "5 Place Des Ternes - 75017 Paris", 48.8784166609, 2.29778064436 },
        { 17042, 10, "17042 - Porte Maillot", "Face 279 Boulevard Pereire -", "Face 279 Boulevard Pereire - 75017 Paris", 48.8776293782, 2.28393760608 },
        { 17041, 10, "17041 - Porte De Villiers", "51 Rue Guersant -", "51 Rue Guersant - 75017 Paris", 48.8828075997, 2.28754343232 },
        { 17040, 10, "17040 - Ternes Pereire", "227 Boulevard Pereire Sur Tpc -", "227 Boulevard Pereire Sur Tpc - 75017 Paris", 48.8797073756, 2.28845935882 },
        { 17039, 10, "17039 - Place Saint Ferdinand", "26 Rue Saint Ferdinand -", "26 Rue Saint Ferdinand - 75017 Paris", 48.8781795513, 2.28848804837 },
        { 17038, 10, "17038 - Argentine", "42 Avenue De La Grande Armee -", "42 Avenue De La Grande Armee - 75017 Paris", 48.8762831905, 2.28838082993 },
        { 17037, 10, "17037 - Bayern Pereire", "40 Rue Bayen -", "40 Rue Bayen - 75017 Paris", 48.8817759453, 2.29227289265 },
        { 17033, 10, "17033 - Carnot", "8 Avenue Carnot -", "8 Avenue Carnot - 75017 Paris", 48.8754853876, 2.29370898208 },
        { 17031, 10, "17031 - Porte De Champeret", "Place De La Porte De Champeret -", "Place De La Porte De Champeret - 75017 Paris", 48.8855230462, 2.29077059372 },
        { 14012, 10, "14012 - Sibelle Alesia", "Face 2 Avenue De La Sibelle -", "Face 2 Avenue De La Sibelle - 75014 Paris", 48.8267542718, 2.3386567439 },
        { 9038, 1, "09038 - Square Berlioz", "50 Bis Rue Douai -", "50 Bis Rue Douai - 75009 Paris", 48.8832042427, 2.33078181402 },
        { 9037, 1, "09037 - Clichy Parme", "01 Rue De Parme -", "01 Rue De Parme - 75009 Paris", 48.8811639723, 2.32823390305 },
        { 9036, 1, "09036 - Athenes Clichy", "4 Rue D'Athenes -", "4 Rue D'Athenes - 75009 Paris", 48.8780994219, 2.32977414585 },
        { 9035, 1, "09035 - Place De Budapest", "38 Rue De Londres -", "38 Rue De Londres - 75009 Paris", 48.8776768361, 2.32726708944 },
        { 9033, 1, "09033 - Havre Caumartin", "Face 45 Rue Caumartin -", "Face 45 Rue Caumartin - 75009 Paris", 48.8728866936, 2.32835796239 },
        { 9032, 1, "09032 - Mathurins", "12 Rue Des Mathurins -", "12 Rue Des Mathurins - 75009 Paris", 48.8730664926, 2.32909365056 },
        { 9030, 1, "09030 - Victoir Chaussee D Antin", "79 Rue De La Victoire -", "79 Rue De La Victoire - 75009 Paris", 48.8751337426, 2.33214531837 },
        { 9029, 1, "09029 - Trinite", "62 Rue Saint Lazare -", "62 Rue Saint Lazare - 75009 Paris", 48.8768413566, 2.33286729729 },
        { 9028, 1, "09028 - Moncey Blanche", "4 Rue Moncey -", "4 Rue Moncey - 75009 Paris", 48.8801036554, 2.33104110033 },
        { 9027, 1, "09027 - Fontaine Douai", "24 Rue De Douai -", "24 Rue De Douai - 75009 Paris", 48.8823954971, 2.33318024554 },
        { 9026, 1, "09026 - Bruyere Pigalle", "28 Rue J.B.Pigalle -", "28 Rue J.B.Pigalle - 75009 Paris", 48.8793578239, 2.33378003172 },
        { 9025, 1, "09025 - Taitbout Chteaudun", "77 Rue Taitbout -", "77 Rue Taitbout - 75009 Paris", 48.8762931972, 2.33531989301 },
        { 9024, 1, "09024 - Lafayette Taitbout", "27 Rue Taitbout -", "27 Rue Taitbout - 75009 Paris", 48.8733453625, 2.33529275394 },
        { 18040, 10, "18040 - Chapelle Marx Dormoy", "12 Place De La Chapelle -", "12 Place De La Chapelle - 75018 Paris", 48.8845862556, 2.36013517785 },
        { 9022, 1, "09022 - Lafitte Rossini", "19 Rue Rossini -", "19 Rue Rossini - 75009 Paris", 48.8733274022, 2.33790865761 },
        { 9021, 1, "09021 - Saint Georges", "56 Rue Saint Georges -", "56 Rue Saint Georges - 75009 Paris", 48.8779199109, 2.33745906751 },
        { 9018, 1, "09018 - Place Pigalle", "05 Rue Duperre -", "05 Rue Duperre - 75009 Paris", 48.8820540503, 2.33675049092 },
        { 9017, 1, "09017 - Trudaine Martyrs", "01 Rue Lallier -", "01 Rue Lallier - 75009 Paris", 48.8810833698, 2.34098835217 },
        { 9016, 1, "09016 - Martyrs Choron", "24 Rue De Choron -", "24 Rue De Choron - 75009 Paris", 48.8778120367, 2.33978905723 },
        { 9015, 1, "09015 - Lamartine", "43 Rue Lamartine -", "43 Rue Lamartine - 75009 Paris", 48.8765987559, 2.33967999505 },
        { 9014, 1, "09014 - Faubourg Montmartre", "55 Rue Du Faubourg Montmartre -", "55 Rue Du Faubourg Montmartre - 75009 Paris", 48.8752146886, 2.34067455459 },
        { 9013, 1, "09013 - Mairie Du 9Eme", "20 Rue De La Grange Bateliere -", "20 Rue De La Grange Bateliere - 75009 Paris", 48.8733183648, 2.3407698009 },
        { 20042, 10, "20042 - Pyrenees Ermitage", "300 Rue Des Pyrenees -", "300 Rue Des Pyrenees - 75020 Paris", 48.8721735203, 2.39181957349 },
        { 9011, 1, "09011 - Folies Bergeres", "14 Rue Geoffroy Marie -", "14 Rue Geoffroy Marie - 75009 Paris", 48.8739562925, 2.34454387501 },
        { 9010, 1, "09010 - Cadet", "1/3 Rue De Rochechouart -", "1/3 Rue De Rochechouart - 75009 Paris", 48.8767064157, 2.34436713177 },
        { 9009, 1, "09009 - Square Montholon", "26 Rue Montholon -", "26 Rue Montholon - 75009 Paris", 48.8765175799, 2.34592039385 },
        { 9008, 1, "09008 - Tour D'Auvergne", "24 Rue D'Auvergne -", "24 Rue D'Auvergne - 75009 Paris", 48.8790341614, 2.34364527348 },
        { 9007, 1, "09007 - Condorcet", "34 Rue Condorcet -", "34 Rue Condorcet - 75009 Paris", 48.8800586144, 2.34522604641 },
        { 9006, 1, "09006 - Trudainre Rochechouart", "81 Rue Dunkerque -", "81 Rue Dunkerque - 75009 Paris", 48.8819818077, 2.34633011052 },
        { 9005, 1, "09005 - Square D'Anvers", "95 Rue De Dunkerque -", "95 Rue De Dunkerque - 75009 Paris", 48.882620012, 2.34474949755 },
        { 9004, 1, "09004 - Rochechouart Gerando", "19 Rue Guerando -", "19 Rue Guerando - 75009 Paris", 48.8829254714, 2.3462893947 },
        { 20033, 10, "20033 - Etienne Dolet", "29 Rue Etienne Dollet -", "29 Rue Etienne Dollet - 75020 Paris", 48.8682037751, 2.38567135463 },
        { 9002, 1, "09002 - Maubeuge Condorcet", "19 Rue D'Abbeville -", "19 Rue D'Abbeville - 75009 Paris", 48.8791775257, 2.34924559045 },
        { 9001, 1, "09001 - Poissonniere", "5 Rue De Bellefond -", "5 Rue De Bellefond - 75009 Paris", 48.877461014, 2.34865929339 },
        { 20028, 10, "20028 - Gambetta Martin Nadaud", "Face 2 Rue Orfila -", "Face 2 Rue Orfila - 75020 Paris", 48.8651172689, 2.39434590378 },
        { 20027, 10, "20027 - Porte De Menilmontant", "1 Rue Vidal De La Blache -", "1 Rue Vidal De La Blache - 75020 Paris", 48.8691176938, 2.40902270315 },
        { 20026, 10, "20026 - Pelleport", "121 Avenue Gambetta -", "121 Avenue Gambetta - 75020 Paris", 48.8678730602, 2.40091525573 },
        { 20025, 10, "20025 - Gambetta Gatines", "13 Rue Des Gatines -", "13 Rue Des Gatines - 75020 Paris", 48.8653043713, 2.3976563507 },
        { 20023, 10, "20023 - Pelleport Belgrand", "44 Rue Pelleport -", "44 Rue Pelleport - 75020 Paris", 48.8648426278, 2.40400379068 },
        { 20021, 10, "20021 - Prairie L Indre", "2 Rue De L'Indre -", "2 Rue De L'Indre - 75020 Paris", 48.8626230874, 2.40338795779 },
        {0, 0, NULL, NULL, NULL, 0., 0.}
};

QList < Station * > builtinStationsPluginParis(StationsPlugin *plugin)
{
  QList < Station * > list;

  for (int i = 0; stations[i].name; ++i) {
    Station *station = new Station(plugin);

    station->setId(stations[i].number);
    station->setName(QString::fromUtf8(stations[i].name));
    station->setDescription(QString::fromUtf8(stations[i].address));
    station->setPos(QPointF(stations[i].x, stations[i].y));
    station->setRegion(QString("Paris %1").arg(stations[i].arrondissementNumber));
    list.append(station);
  }

  return list;
}

